/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.units.ICompilationUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringToCompilationUnitMap {
    private static final Object PRESENT = new Object();
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    private final Lock readLock;
    private final Lock writeLock;
    private Map<String, Object> map;

    public StringToCompilationUnitMap() {
        this(EMPTY_MAP);
    }

    private StringToCompilationUnitMap(Map<String, Object> map) {
        this.map = map;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WeakReference<ICompilationUnit>> getInvisible(String sortKey) {
        this.readLock.lock();
        try {
            Collection<WeakReference<ICompilationUnit>> collection = StringToCompilationUnitMap.valueToCollection(this.map.get(sortKey), null, Visibility.INVISIBLE_ONLY);
            Object var4_3 = null;
            this.readLock.unlock();
            return collection;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WeakReference<ICompilationUnit>> getVisibleAndInvisible(String sortKey) {
        this.readLock.lock();
        try {
            Collection<WeakReference<ICompilationUnit>> collection = StringToCompilationUnitMap.valueToCollection(this.map.get(sortKey), null, Visibility.ALL);
            Object var4_3 = null;
            this.readLock.unlock();
            return collection;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WeakReference<ICompilationUnit>> get(String sortKey) {
        this.readLock.lock();
        try {
            Collection<WeakReference<ICompilationUnit>> collection = StringToCompilationUnitMap.valueToCollection(this.map.get(sortKey), null, Visibility.VISIBLE_ONLY);
            Object var4_3 = null;
            this.readLock.unlock();
            return collection;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WeakReference<ICompilationUnit>> get(String sortKey, ICompilerProject project) {
        this.readLock.lock();
        try {
            Collection<WeakReference<ICompilationUnit>> collection = StringToCompilationUnitMap.valueToCollection(this.map.get(sortKey), project, Visibility.VISIBLE_ONLY);
            Object var5_4 = null;
            this.readLock.unlock();
            return collection;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WeakReference<ICompilationUnit>> getInvisible(String sortKey, ICompilerProject project) {
        this.readLock.lock();
        try {
            Collection<WeakReference<ICompilationUnit>> collection = StringToCompilationUnitMap.valueToCollection(this.map.get(sortKey), project, Visibility.INVISIBLE_ONLY);
            Object var5_4 = null;
            this.readLock.unlock();
            return collection;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String[] files, ICompilationUnit cu) {
        this.writeLock.lock();
        try {
            for (String file : files) {
                this.add(file, cu);
            }
            Object var8_7 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String sortKey, ICompilationUnit cu) {
        this.writeLock.lock();
        try {
            Object existing;
            if (this.map == EMPTY_MAP) {
                this.map = new HashMap<String, Object>();
            }
            if ((existing = this.map.get(sortKey)) == null) {
                this.map.put(sortKey, new WeakReference<ICompilationUnit>(cu));
            } else if (existing instanceof WeakHashMap) {
                WeakHashMap collection = (WeakHashMap)existing;
                collection.put(cu, PRESENT);
            } else {
                assert (existing instanceof WeakReference);
                WeakHashMap<Object, Object> collection = new WeakHashMap<Object, Object>(2);
                collection.put(((WeakReference)existing).get(), PRESENT);
                collection.put(cu, PRESENT);
                this.map.put(sortKey, collection);
            }
            Object var6_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String sortKey) {
        this.writeLock.lock();
        try {
            this.map.remove(sortKey);
            if (this.map.isEmpty()) {
                this.map = EMPTY_MAP;
            }
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<ICompilationUnit> remove(String sortKey, ICompilerProject project) {
        Object mapValue;
        block18: {
            ICompilationUnit compilationUnit;
            block17: {
                block16: {
                    block15: {
                        assert (project != null);
                        this.writeLock.lock();
                        mapValue = this.map.remove(sortKey);
                        if (mapValue != null) break block15;
                        List<ICompilationUnit> list = Collections.emptyList();
                        Object var10_7 = null;
                        if (this.map.isEmpty()) {
                            this.map = EMPTY_MAP;
                        }
                        this.writeLock.unlock();
                        return list;
                    }
                    try {
                        if (!(mapValue instanceof WeakHashMap)) break block16;
                        WeakHashMap collection = (WeakHashMap)mapValue;
                        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>(collection.size());
                        Iterator iter = collection.entrySet().iterator();
                        while (iter.hasNext()) {
                            ICompilerProject projFromCU;
                            ICompilationUnit compilationUnit2 = (ICompilationUnit)iter.next().getKey();
                            if (compilationUnit2 == null || (projFromCU = compilationUnit2.getProject()) == null || projFromCU != project) continue;
                            result.add(compilationUnit2);
                            iter.remove();
                        }
                        if (!collection.isEmpty()) {
                            this.map.put(sortKey, collection);
                        }
                        List<ICompilationUnit> list = Collections.unmodifiableList(result);
                        Object var10_8 = null;
                        if (this.map.isEmpty()) {
                            this.map = EMPTY_MAP;
                        }
                        this.writeLock.unlock();
                        return list;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        if (this.map.isEmpty()) {
                            this.map = EMPTY_MAP;
                        }
                        this.writeLock.unlock();
                        throw throwable;
                    }
                }
                compilationUnit = (ICompilationUnit)((WeakReference)mapValue).get();
                if (compilationUnit != null) break block17;
                List<ICompilationUnit> list = Collections.emptyList();
                Object var10_9 = null;
                if (this.map.isEmpty()) {
                    this.map = EMPTY_MAP;
                }
                this.writeLock.unlock();
                return list;
            }
            if (compilationUnit == null || compilationUnit.getProject() != project) break block18;
            List<ICompilationUnit> list = Collections.singletonList(compilationUnit);
            Object var10_10 = null;
            if (this.map.isEmpty()) {
                this.map = EMPTY_MAP;
            }
            this.writeLock.unlock();
            return list;
        }
        this.map.put(sortKey, mapValue);
        List<ICompilationUnit> list = Collections.emptyList();
        Object var10_11 = null;
        if (this.map.isEmpty()) {
            this.map = EMPTY_MAP;
        }
        this.writeLock.unlock();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ICompilationUnit> remove(String sortKey, ICompilationUnit cuToRemove) {
        Object mapValue;
        block18: {
            ICompilationUnit compilationUnit;
            block17: {
                block16: {
                    block15: {
                        assert (cuToRemove != null);
                        this.writeLock.lock();
                        mapValue = this.map.remove(sortKey);
                        if (mapValue != null) break block15;
                        List<ICompilationUnit> list = Collections.emptyList();
                        Object var9_7 = null;
                        if (this.map.isEmpty()) {
                            this.map = EMPTY_MAP;
                        }
                        this.writeLock.unlock();
                        return list;
                    }
                    try {
                        if (!(mapValue instanceof WeakHashMap)) break block16;
                        WeakHashMap collection = (WeakHashMap)mapValue;
                        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>(collection.size());
                        Iterator iter = collection.entrySet().iterator();
                        while (iter.hasNext()) {
                            ICompilationUnit compilationUnit2 = (ICompilationUnit)iter.next().getKey();
                            if (compilationUnit2 == null || compilationUnit2 != cuToRemove) continue;
                            result.add(compilationUnit2);
                            iter.remove();
                        }
                        if (!collection.isEmpty()) {
                            this.map.put(sortKey, collection);
                        }
                        List<ICompilationUnit> list = Collections.unmodifiableList(result);
                        Object var9_8 = null;
                        if (this.map.isEmpty()) {
                            this.map = EMPTY_MAP;
                        }
                        this.writeLock.unlock();
                        return list;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        if (this.map.isEmpty()) {
                            this.map = EMPTY_MAP;
                        }
                        this.writeLock.unlock();
                        throw throwable;
                    }
                }
                compilationUnit = (ICompilationUnit)((WeakReference)mapValue).get();
                if (compilationUnit != null) break block17;
                List<ICompilationUnit> list = Collections.emptyList();
                Object var9_9 = null;
                if (this.map.isEmpty()) {
                    this.map = EMPTY_MAP;
                }
                this.writeLock.unlock();
                return list;
            }
            if (compilationUnit == null || compilationUnit != cuToRemove) break block18;
            List<ICompilationUnit> list = Collections.singletonList(compilationUnit);
            Object var9_10 = null;
            if (this.map.isEmpty()) {
                this.map = EMPTY_MAP;
            }
            this.writeLock.unlock();
            return list;
        }
        this.map.put(sortKey, mapValue);
        List<ICompilationUnit> list = Collections.emptyList();
        Object var9_11 = null;
        if (this.map.isEmpty()) {
            this.map = EMPTY_MAP;
        }
        this.writeLock.unlock();
        return list;
    }

    private static Collection<WeakReference<ICompilationUnit>> valueToCollection(Object value, ICompilerProject project, Visibility visibility) {
        if (value instanceof WeakHashMap) {
            WeakHashMap collection = (WeakHashMap)value;
            ArrayList<WeakReference<ICompilationUnit>> result = new ArrayList<WeakReference<ICompilationUnit>>(collection.size());
            for (ICompilationUnit compilationUnit : collection.keySet()) {
                ICompilerProject projFromCU;
                if (compilationUnit == null || (projFromCU = compilationUnit.getProject()) == null || project != null && projFromCU != project || !visibility.match(compilationUnit)) continue;
                result.add(new WeakReference<ICompilationUnit>(compilationUnit));
            }
            return Collections.unmodifiableList(result);
        }
        if (value != null) {
            assert (value instanceof WeakReference);
            WeakReference cuRef = (WeakReference)value;
            ICompilationUnit compilationUnit = (ICompilationUnit)cuRef.get();
            if (compilationUnit != null && (project == null || compilationUnit.getProject() == project) && visibility.match(compilationUnit)) {
                return Collections.singletonList(cuRef);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility INVISIBLE_ONLY = new Visibility();
        public static final /* enum */ Visibility VISIBLE_ONLY = new Visibility();
        public static final /* enum */ Visibility ALL = new Visibility();
        private static final /* synthetic */ Visibility[] $VALUES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String name) {
            return Enum.valueOf(Visibility.class, name);
        }

        private boolean match(ICompilationUnit cu) {
            switch (this) {
                case INVISIBLE_ONLY: {
                    return cu.isInvisible();
                }
                case VISIBLE_ONLY: {
                    return !cu.isInvisible();
                }
                case ALL: {
                    return true;
                }
            }
            assert (false) : "Unhandled visibility!";
            return false;
        }

        static {
            $VALUES = new Visibility[]{INVISIBLE_ONLY, VISIBLE_ONLY, ALL};
        }
    }
}

