/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.royale.compiler.common.ASImportTarget;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.IImportTarget;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.IInitializableDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.PackageNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.ICommonClassNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.as.IScopedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceNode
extends BaseDefinitionNode
implements INamespaceNode,
IInitializableDefinitionNode {
    private static final String EMPTY_URI = "";
    private ExpressionNodeBase uriNode;

    public NamespaceNode(IdentifierNode nameNode) {
        this.init(nameNode);
    }

    @Override
    public final ASTNodeID getNodeID() {
        return ASTNodeID.NamespaceID;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addDecorationChildren(fillInOffsets);
        this.addChildInOrder(this.nameNode, fillInOffsets);
        if (this.uriNode != null) {
            this.addChildInOrder(this.uriNode, fillInOffsets);
        }
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            boolean is_static = this.hasModifier(ASModifier.STATIC);
            if (scope.getContainingDefinition() instanceof IClassDefinition) {
                is_static = true;
            }
            NamespaceDefinition definition = this.buildDefinition(is_static);
            this.setDefinition(definition);
            scope.addDefinition(definition);
        }
        super.analyze(set, scope, problems);
    }

    @Override
    public NamespaceDefinition getDefinition() {
        return (NamespaceDefinition)super.getDefinition();
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public String getQualifiedName() {
        String qualifiedName = null;
        if (this.getNamespaceClassification() == INamespaceDefinition.NamespaceClassification.PACKAGE_MEMBER) {
            IImportTarget importTarget = ASImportTarget.buildImportFromPackageName(this.getWorkspace(), this.getPackageName());
            qualifiedName = importTarget.getQualifiedName(this.getName());
        }
        if (qualifiedName == null) {
            qualifiedName = this.getName();
        }
        return qualifiedName;
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public INamespaceDefinition.NamespaceClassification getNamespaceClassification() {
        IScopedNode scopedNode = this.getScopeNode();
        IScopedNode node = scopedNode;
        if (node.getParent() instanceof PackageNode) {
            return INamespaceDefinition.NamespaceClassification.PACKAGE_MEMBER;
        }
        if (node instanceof ICommonClassNode || node.getParent() instanceof ICommonClassNode) {
            return INamespaceDefinition.NamespaceClassification.CLASS_MEMBER;
        }
        if (node instanceof FileNode) {
            return INamespaceDefinition.NamespaceClassification.FILE_MEMBER;
        }
        return INamespaceDefinition.NamespaceClassification.LOCAL;
    }

    @Override
    public ExpressionNodeBase getNamespaceURINode() {
        return this.uriNode;
    }

    @Override
    public String getURI() {
        return this.uriNode instanceof LiteralNode ? ((LiteralNode)this.uriNode).getValue() : EMPTY_URI;
    }

    @Override
    public void setAssignedValue(IASToken eq, ExpressionNodeBase value) {
        this.uriNode = value;
    }

    private String getURILiteral() {
        return this.uriNode instanceof LiteralNode ? ((LiteralNode)this.uriNode).getValue() : null;
    }

    NamespaceDefinition buildDefinition(boolean is_static) {
        String definitionName = this.getName();
        INamespaceReference namespaceReference = NamespaceDefinition.createNamespaceReference((IASScope)this.getASScope(), this.getNamespaceNode(), is_static);
        ExpressionNodeBase initExpr = this.getNamespaceURINode();
        NamespaceDefinition definition = NamespaceDefinition.createNamespaceDefintionDirective(namespaceReference, this.getScope(), definitionName, this.getURILiteral(), initExpr != null ? initExpr.computeNamespaceReference() : null);
        definition.setNode(this);
        this.fillInModifiers(definition);
        this.fillInMetadata(definition);
        return definition;
    }

    private IASScope getScope() {
        IASScope scope = this.getScopeNode().getScope();
        if (scope instanceof TypeScope) {
            scope = ((TypeScope)scope).getStaticScope();
        }
        return scope;
    }
}

