/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.internal.tree.as.FixedChildrenNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IKeywordNode;

public class KeywordNode
extends FixedChildrenNode
implements IKeywordNode {
    private int keywordType;

    protected KeywordNode() {
    }

    public KeywordNode(IASToken keyword) {
        this.span(keyword);
        this.keywordType = keyword.getType();
    }

    protected KeywordNode(KeywordNode other) {
        this.keywordType = other.keywordType;
    }

    public ASTNodeID getNodeID() {
        switch (this.keywordType) {
            case 44: {
                return ASTNodeID.KeywordFunctionID;
            }
            case 40: {
                return ASTNodeID.KeywordExtendsID;
            }
            case 43: {
                return ASTNodeID.KeywordImplementsID;
            }
            case 50: {
                return ASTNodeID.KeywordVarID;
            }
            case 47: {
                return ASTNodeID.KeywordGetID;
            }
            case 48: {
                return ASTNodeID.KeywordSetID;
            }
            case 152: {
                return ASTNodeID.KeywordNewID;
            }
            case 51: {
                return ASTNodeID.KeywordConstID;
            }
            case 42: {
                return ASTNodeID.KeywordClassID;
            }
            case 39: {
                return ASTNodeID.KeywordInterfaceID;
            }
            case 53: {
                return ASTNodeID.KeywordDefaultXMLNamespaceID;
            }
        }
        return ASTNodeID.UnknownID;
    }

    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getKeyword());
        sb.append('\"');
        return true;
    }

    public int getKeywordId() {
        return this.keywordType;
    }

    public String getKeyword() {
        switch (this.keywordType) {
            case 44: {
                return "function";
            }
            case 40: {
                return "extends";
            }
            case 43: {
                return "implements";
            }
            case 50: {
                return "var";
            }
            case 47: {
                return "get";
            }
            case 48: {
                return "set";
            }
            case 152: {
                return "new";
            }
            case 51: {
                return "const";
            }
            case 42: {
                return "class";
            }
            case 39: {
                return "interface";
            }
            case 53: {
                return "default xml namespace";
            }
        }
        assert (false) : "Unknown keyword type " + this.keywordType;
        return "";
    }
}

