/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.semantics;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.royale.abc.ABCConstants;
import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.ECMASupport;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.PooledValue;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IConstantDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IGetterDefinition;
import org.apache.royale.compiler.definitions.IInterfaceDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.ISetterDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.internal.as.codegen.ABCGeneratingReducer;
import org.apache.royale.compiler.internal.as.codegen.Binding;
import org.apache.royale.compiler.internal.as.codegen.LexicalScope;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.AmbiguousDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.ClassTraitsDefinition;
import org.apache.royale.compiler.internal.definitions.ConstantDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.GetterDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.ParameterDefinition;
import org.apache.royale.compiler.internal.definitions.SetterDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLogicalAndNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLogicalOrNode;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LanguageIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.ModifierNode;
import org.apache.royale.compiler.internal.tree.as.ModifiersContainerNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.NumericLiteralNode;
import org.apache.royale.compiler.internal.tree.as.PackageNode;
import org.apache.royale.compiler.internal.tree.as.ParameterNode;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.tree.as.TernaryOperatorNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.internal.tree.as.VectorLiteralNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLDocumentNode;
import org.apache.royale.compiler.problems.AccessUndefinedMemberProblem;
import org.apache.royale.compiler.problems.AccessUndefinedPropertyInPackageProblem;
import org.apache.royale.compiler.problems.AccessUndefinedPropertyProblem;
import org.apache.royale.compiler.problems.AccessorTypesMustMatchProblem;
import org.apache.royale.compiler.problems.AmbiguousReferenceProblem;
import org.apache.royale.compiler.problems.ArrayCastProblem;
import org.apache.royale.compiler.problems.ArrayDowncastProblem;
import org.apache.royale.compiler.problems.AssignToConstProblem;
import org.apache.royale.compiler.problems.AssignToFunctionProblem;
import org.apache.royale.compiler.problems.AssignToNonReferenceValueProblem;
import org.apache.royale.compiler.problems.AssignToReadOnlyPropertyProblem;
import org.apache.royale.compiler.problems.AssignmentInConditionalProblem;
import org.apache.royale.compiler.problems.AttemptToDeleteFixedPropertyProblem;
import org.apache.royale.compiler.problems.AttributesAreNotCallableProblem;
import org.apache.royale.compiler.problems.BURMDiagnosticNotAllowedHereProblem;
import org.apache.royale.compiler.problems.BadSetterReturnTypeProblem;
import org.apache.royale.compiler.problems.CallNonFunctionProblem;
import org.apache.royale.compiler.problems.CallUndefinedMethodProblem;
import org.apache.royale.compiler.problems.ComparisonBetweenUnrelatedTypesProblem;
import org.apache.royale.compiler.problems.ConflictingInheritedNameInNamespaceProblem;
import org.apache.royale.compiler.problems.ConflictingNameInNamespaceProblem;
import org.apache.royale.compiler.problems.ConstNotInitializedProblem;
import org.apache.royale.compiler.problems.DateCastProblem;
import org.apache.royale.compiler.problems.DecrementMustBeReferenceProblem;
import org.apache.royale.compiler.problems.DefinitionShadowedByPackageNameProblem;
import org.apache.royale.compiler.problems.DuplicateAttributeProblem;
import org.apache.royale.compiler.problems.DuplicateFunctionDefinitionProblem;
import org.apache.royale.compiler.problems.DuplicateVariableDefinitionProblem;
import org.apache.royale.compiler.problems.DynamicNotOnClassProblem;
import org.apache.royale.compiler.problems.ExtraneousSuperStatementProblem;
import org.apache.royale.compiler.problems.FinalOutsideClassProblem;
import org.apache.royale.compiler.problems.FunctionWithoutBodyProblem;
import org.apache.royale.compiler.problems.GetterCannotHaveParametersProblem;
import org.apache.royale.compiler.problems.GetterMustNotBeVoidProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.IllegalAssignmentToClassProblem;
import org.apache.royale.compiler.problems.IllogicalComparionWithNaNProblem;
import org.apache.royale.compiler.problems.IllogicalComparisonWithUndefinedProblem;
import org.apache.royale.compiler.problems.ImplicitCoercionToSubtypeProblem;
import org.apache.royale.compiler.problems.ImplicitCoercionToUnrelatedTypeProblem;
import org.apache.royale.compiler.problems.ImplicitTypeCheckCoercionToUnrelatedTypeProblem;
import org.apache.royale.compiler.problems.InaccessibleMethodReferenceProblem;
import org.apache.royale.compiler.problems.InaccessiblePropertyReferenceProblem;
import org.apache.royale.compiler.problems.IncompatibleDefaultValueOfTypeNullProblem;
import org.apache.royale.compiler.problems.IncompatibleInitializerTypeProblem;
import org.apache.royale.compiler.problems.IncrementMustBeReferenceProblem;
import org.apache.royale.compiler.problems.InitializerValueNotAnIntegerProblem;
import org.apache.royale.compiler.problems.InitializerValueOutOfRangeProblem;
import org.apache.royale.compiler.problems.InlineFunctionNotFinalStaticOrGlobalProblem;
import org.apache.royale.compiler.problems.InlineFunctionTooLargeProblem;
import org.apache.royale.compiler.problems.InlineNestedInliningNotSupportedProblem;
import org.apache.royale.compiler.problems.InlineNoSourceProblem;
import org.apache.royale.compiler.problems.InlineUnsupportedInstructionProblem;
import org.apache.royale.compiler.problems.InlineUnsupportedNodeProblem;
import org.apache.royale.compiler.problems.InstanceOfProblem;
import org.apache.royale.compiler.problems.InterfaceCannotBeInstantiatedProblem;
import org.apache.royale.compiler.problems.InterfaceMethodOverrideProblem;
import org.apache.royale.compiler.problems.InvalidDecrementOperandProblem;
import org.apache.royale.compiler.problems.InvalidIncrementOperandProblem;
import org.apache.royale.compiler.problems.InvalidNamespaceProblem;
import org.apache.royale.compiler.problems.InvalidOverrideProblem;
import org.apache.royale.compiler.problems.InvalidPrivateNamespaceAttrProblem;
import org.apache.royale.compiler.problems.InvalidPrivateNamespaceProblem;
import org.apache.royale.compiler.problems.InvalidProtectedNamespaceAttrProblem;
import org.apache.royale.compiler.problems.InvalidProtectedNamespaceProblem;
import org.apache.royale.compiler.problems.InvalidPublicNamespaceAttrProblem;
import org.apache.royale.compiler.problems.InvalidPublicNamespaceProblem;
import org.apache.royale.compiler.problems.InvalidRestParameterDeclarationProblem;
import org.apache.royale.compiler.problems.InvalidSuperExpressionProblem;
import org.apache.royale.compiler.problems.InvalidSuperStatementProblem;
import org.apache.royale.compiler.problems.LocalBindablePropertyProblem;
import org.apache.royale.compiler.problems.LossyConversionProblem;
import org.apache.royale.compiler.problems.MethodCannotBeConstructorProblem;
import org.apache.royale.compiler.problems.MissingPropertyNameProblem;
import org.apache.royale.compiler.problems.NamespaceOverrideInsideFunctionProblem;
import org.apache.royale.compiler.problems.NativeMethodWithBodyProblem;
import org.apache.royale.compiler.problems.NativeVariableProblem;
import org.apache.royale.compiler.problems.NoDefaultConstructorInBaseClassProblem;
import org.apache.royale.compiler.problems.NullUsedWhereOtherExpectedProblem;
import org.apache.royale.compiler.problems.PackageCannotBeUsedAsValueProblem;
import org.apache.royale.compiler.problems.PropertyIsWriteOnlyProblem;
import org.apache.royale.compiler.problems.RequiredParameterAfterOptionalProblem;
import org.apache.royale.compiler.problems.RestParamAndArgumentsUsedTogetherProblem;
import org.apache.royale.compiler.problems.RestParameterMustBeLastProblem;
import org.apache.royale.compiler.problems.ReturnCannotBeUsedInGlobalProblem;
import org.apache.royale.compiler.problems.ReturnCannotBeUsedInPackageProblem;
import org.apache.royale.compiler.problems.ReturnCannotBeUsedInStaticProblem;
import org.apache.royale.compiler.problems.ReturnMustReturnValueProblem;
import org.apache.royale.compiler.problems.ReturnValueInConstructorProblem;
import org.apache.royale.compiler.problems.ReturnValueMustBeUndefinedProblem;
import org.apache.royale.compiler.problems.SemanticProblem;
import org.apache.royale.compiler.problems.SetterCannotHaveOptionalProblem;
import org.apache.royale.compiler.problems.SetterMustHaveOneParameterProblem;
import org.apache.royale.compiler.problems.StaticOutsideClassProblem;
import org.apache.royale.compiler.problems.StrictUndefinedMethodProblem;
import org.apache.royale.compiler.problems.ThisUsedInStaticFunctionProblem;
import org.apache.royale.compiler.problems.TooFewFunctionParametersProblem;
import org.apache.royale.compiler.problems.TooManyFunctionParametersProblem;
import org.apache.royale.compiler.problems.UnknownImportProblem;
import org.apache.royale.compiler.problems.UnknownNamespaceProblem;
import org.apache.royale.compiler.problems.UnknownTypeProblem;
import org.apache.royale.compiler.problems.UnknownWildcardImportProblem;
import org.apache.royale.compiler.problems.UnresolvedNamespaceProblem;
import org.apache.royale.compiler.problems.VariableDefinitionDuplicatesParameterProblem;
import org.apache.royale.compiler.problems.VariableHasNoTypeDeclarationProblem;
import org.apache.royale.compiler.problems.VirtualOutsideClassProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.ICompoundAssignmentNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.INumericLiteralNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IReturnNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.tree.as.IVariableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodBodySemanticChecker {
    private LexicalScope currentScope;
    private final ICompilerProject project;
    private final SemanticUtils utils;
    private SuperState superState = SuperState.Invalid;

    public MethodBodySemanticChecker(LexicalScope current_scope) {
        this.currentScope = current_scope;
        this.project = this.currentScope.getProject();
        this.utils = new SemanticUtils(this.project);
    }

    public void checkFunctionDecl(IFunctionNode funcNode) {
        IParameterNode[] paramNodes;
        for (IParameterNode paramNode : paramNodes = funcNode.getParameterNodes()) {
            IDefinition paramDef = paramNode.getDefinition();
            ITypeDefinition paramTypeDef = ((IVariableDefinition)paramDef).resolveType(this.project);
            if (SemanticUtils.isType(paramTypeDef)) continue;
            IExpressionNode typeExpression = paramNode.getVariableTypeNode();
            String typeName = paramDef.getTypeAsDisplayString();
            this.addTypeProblem(typeExpression, paramTypeDef, typeName, true);
        }
    }

    public void checkNestedFunctionDecl(IFunctionNode funcNode) {
        IFunctionDefinition funcDef = funcNode.getDefinition();
        List<IDefinition> defs = SemanticUtils.findPotentialFunctionConflicts(this.currentScope.getProject(), funcDef);
        if (defs.size() > 1) {
            DuplicateFunctionDefinitionProblem problem = new DuplicateFunctionDefinitionProblem(funcNode, funcDef.getBaseName());
            this.currentScope.addProblem(problem);
        }
    }

    private void addProblem(ICompilerProblem problem) {
        if (problem != null) {
            this.currentScope.addProblem(problem);
        }
    }

    public void checkAssignment(IASNode iNode, Binding binding) {
        this.checkLValue(iNode, binding);
        if (SemanticUtils.isUnprotectedAssignmentInConditional(iNode)) {
            this.addProblem(new AssignmentInConditionalProblem(SemanticUtils.getNthChild(iNode, 0)));
        }
        ITypeDefinition leftType = null;
        if (binding.getDefinition() != null) {
            IDefinition leftDef = binding.getDefinition();
            leftType = binding.getDefinition().resolveType(this.project);
            IASNode rightNode = SemanticUtils.getNthChild(iNode, 1);
            this.checkImplicitConversion(rightNode, leftType, null);
            this.checkAssignmentValue(leftDef, rightNode);
        }
    }

    public void checkAssignmentValue(IDefinition leftDefinition, IASNode rightNode) {
        ITypeDefinition leftType = leftDefinition.resolveType(this.project);
        if (rightNode instanceof IExpressionNode) {
            ITypeDefinition rightType = ((IExpressionNode)rightNode).resolveType(this.project);
            boolean leftIsNumericOrBoolean = SemanticUtils.isNumericTypeOrBoolean(leftType, this.project);
            boolean rightIsNull = SemanticUtils.isBuiltin(rightType, IASLanguageConstants.BuiltinType.NULL, this.project);
            if (leftIsNumericOrBoolean && rightIsNull) {
                boolean leftIsConstant = leftDefinition instanceof IConstantDefinition;
                this.addProblem(leftIsConstant ? new IncompatibleDefaultValueOfTypeNullProblem(rightNode, leftType.getBaseName()) : new NullUsedWhereOtherExpectedProblem(rightNode, leftType.getBaseName()));
            }
        }
    }

    public void checkInitialization(IASNode iNode, Binding binding) {
        if (binding.getDefinition() != null) {
            this.checkImplicitConversion(SemanticUtils.getNthChild(iNode, 2), binding.getDefinition().resolveType(this.project), null);
        }
    }

    public void checkAssignToBracketExpr(IASNode iNode) {
    }

    public void checkBinaryOperator(IASNode iNode, int opcode) {
        IExpressionNode left = ((IBinaryOperatorNode)iNode).getLeftOperandNode();
        IExpressionNode right = ((IBinaryOperatorNode)iNode).getRightOperandNode();
        this.checkBinaryOperator(iNode, left, right, opcode);
    }

    public void checkBinaryOperator(IASNode root, IASNode left, IASNode right, int opcode) {
        switch (opcode) {
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: {
                this.checkImplicitConversion(left, this.utils.numberType(), null);
                this.checkImplicitConversion(right, this.utils.numberType(), null);
                break;
            }
            case 135: 
            case 179: {
                this.checkTypeCheckImplicitConversion(right);
                break;
            }
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                if (!(left instanceof IExpressionNode) || !(right instanceof IExpressionNode)) break;
                this.checkComparison((IExpressionNode)left, (IExpressionNode)right);
                break;
            }
            case 177: {
                this.addProblem(new InstanceOfProblem(root));
            }
        }
    }

    public void checkImplicitConversion(IASNode iNode, IDefinition expected_type, FunctionDefinition func) {
        if (iNode instanceof BinaryOperatorLogicalOrNode || iNode instanceof BinaryOperatorLogicalAndNode || iNode instanceof TernaryOperatorNode) {
            IExpressionNode leftOp = ((IBinaryOperatorNode)iNode).getLeftOperandNode();
            this.checkImplicitConversion(leftOp, expected_type, null);
            IExpressionNode rightOp = ((IBinaryOperatorNode)iNode).getRightOperandNode();
            this.checkImplicitConversion(rightOp, expected_type, null);
        } else if (iNode instanceof ExpressionNodeBase) {
            this.checkImplicitConversion(iNode, ((ExpressionNodeBase)iNode).resolveType(this.project), expected_type, func);
        }
    }

    public void checkTypeCheckImplicitConversion(IASNode iNode) {
        if (!(iNode instanceof ExpressionNodeBase)) {
            return;
        }
        ITypeDefinition actual_type = ((ExpressionNodeBase)iNode).resolveType(this.project);
        IDefinition expected_type = this.utils.getBuiltinType(IASLanguageConstants.BuiltinType.CLASS);
        if (!SemanticUtils.isValidTypeConversion(expected_type, actual_type, this.project, this.currentScope.getInInvisibleCompilationUnit())) {
            this.addProblem(new ImplicitTypeCheckCoercionToUnrelatedTypeProblem(iNode, actual_type.getBaseName(), expected_type.getBaseName()));
        } else {
            SpecialValue value = this.getSpecialValue((IExpressionNode)iNode);
            if (value == SpecialValue.UNDEFINED) {
                this.addProblem(new ImplicitTypeCheckCoercionToUnrelatedTypeProblem(iNode, "undefined", expected_type.getBaseName()));
            } else if (iNode instanceof LiteralNode && "null".equals(((LiteralNode)iNode).getValue())) {
                this.addProblem(new ImplicitTypeCheckCoercionToUnrelatedTypeProblem(iNode, "null", expected_type.getBaseName()));
            }
        }
    }

    SpecialValue getSpecialValue(IExpressionNode node) {
        SpecialValue ret = SpecialValue.NONE;
        IDefinition def = node.resolve(this.project);
        if (def instanceof IConstantDefinition) {
            if (def == this.project.getUndefinedValue()) {
                ret = SpecialValue.UNDEFINED;
            } else {
                Double d;
                Object initialValue = ((ConstantDefinition)def).resolveValueFrom(this.project, (NodeBase)((Object)node));
                if (initialValue != null && initialValue instanceof Double && ECMASupport.isNan(d = (Double)initialValue)) {
                    ret = SpecialValue.NAN;
                }
            }
        }
        return ret;
    }

    private void checkComparison(IExpressionNode leftNode, IExpressionNode rightNode) {
        SpecialValue leftValue = this.getSpecialValue(leftNode);
        SpecialValue rightValue = this.getSpecialValue(rightNode);
        if (leftValue == SpecialValue.NAN || rightValue == SpecialValue.NAN) {
            this.addProblem(new IllogicalComparionWithNaNProblem(leftNode));
        }
        ITypeDefinition left_type = leftNode.resolveType(this.project);
        ITypeDefinition right_type = rightNode.resolveType(this.project);
        if (left_type == null || right_type == null) {
            return;
        }
        ITypeDefinition anyType = this.project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
        if (rightValue == SpecialValue.UNDEFINED && !left_type.equals(anyType)) {
            this.addProblem(new IllogicalComparisonWithUndefinedProblem(leftNode));
        }
        if (leftValue == SpecialValue.UNDEFINED && !right_type.equals(anyType)) {
            this.addProblem(new IllogicalComparisonWithUndefinedProblem(rightNode));
        }
        if (left_type.equals(right_type)) {
            return;
        }
        boolean leftIsNumeric = SemanticUtils.isNumericType(left_type, this.project);
        boolean rightIsNumeric = SemanticUtils.isNumericType(right_type, this.project);
        boolean leftIsNull = SemanticUtils.isBuiltin(left_type, IASLanguageConstants.BuiltinType.NULL, this.project);
        boolean rightIsNull = SemanticUtils.isBuiltin(right_type, IASLanguageConstants.BuiltinType.NULL, this.project);
        if (left_type instanceof IInterfaceDefinition && !rightIsNumeric || right_type instanceof IInterfaceDefinition && !leftIsNumeric) {
            return;
        }
        boolean isBad = false;
        if (leftIsNumeric && rightIsNull || rightIsNumeric && leftIsNull) {
            isBad = true;
        }
        if (!isBad) {
            if (SemanticUtils.isValidTypeConversion(left_type, right_type, this.project, this.currentScope.getInInvisibleCompilationUnit())) {
                return;
            }
            if (SemanticUtils.isValidTypeConversion(right_type, left_type, this.project, this.currentScope.getInInvisibleCompilationUnit())) {
                return;
            }
        }
        this.addProblem(new ComparisonBetweenUnrelatedTypesProblem(leftNode, left_type.getBaseName(), right_type.getBaseName()));
    }

    public void checkCompoundAssignment(IASNode iNode, Binding lvalue, int opcode) {
        ICompoundAssignmentNode compoundNode = (ICompoundAssignmentNode)((Object)iNode);
        IBinaryOperatorNode binop = (IBinaryOperatorNode)iNode;
        this.checkLValue(iNode, lvalue);
        if (SemanticUtils.isUnprotectedAssignmentInConditional(iNode)) {
            this.addProblem(new AssignmentInConditionalProblem(binop.getLeftOperandNode()));
        }
        this.checkBinaryOperator(iNode, binop.getLeftOperandNode(), binop.getRightOperandNode(), opcode);
        if (lvalue.getDefinition() != null) {
            ITypeDefinition compoundType;
            ITypeDefinition lhsType = lvalue.getDefinition().resolveType(this.project);
            if (!SemanticUtils.isValidImplicitOpAssignment(lhsType, compoundType = compoundNode.resolveTypeOfRValue(this.project), opcode, this.project, this.currentScope.getInInvisibleCompilationUnit())) {
                this.checkImplicitConversion(binop.getRightOperandNode(), lhsType, null);
            } else if (opcode == 18 || opcode == 17) {
                this.checkImplicitConversion(binop.getRightOperandNode(), lhsType, null);
            }
        }
    }

    private void checkImplicitConversion(IASNode iNode, IDefinition actual_type, IDefinition expected_type, FunctionDefinition func) {
        if (!SemanticUtils.isValidTypeConversion(expected_type, actual_type, this.project, this.currentScope.getInInvisibleCompilationUnit())) {
            if (this.project.isValidTypeConversion(iNode, actual_type, expected_type, func)) {
                return;
            }
            if (!(expected_type instanceof ClassTraitsDefinition)) {
                if (this.utils.isInstanceOf(expected_type, actual_type)) {
                    this.addProblem(new ImplicitCoercionToSubtypeProblem(iNode, actual_type.getBaseName(), expected_type.getBaseName()));
                } else {
                    this.addProblem(new ImplicitCoercionToUnrelatedTypeProblem(iNode, actual_type.getBaseName(), expected_type.getBaseName()));
                }
            }
        }
    }

    public void checkBindableVariableDeclaration(IASNode iNode, IDefinition d) {
        assert (d != null);
        if (!(d.getParent() instanceof IClassDefinition)) {
            this.currentScope.addProblem(new LocalBindablePropertyProblem(iNode));
        }
    }

    public void checkConstantValue(IASNode iNode) {
        if (iNode instanceof IExpressionNode) {
            IDefinition definition = ((IExpressionNode)iNode).resolve(this.project);
            this.checkDeprecated(iNode, definition);
        }
    }

    public void checkDefaultSuperCall(IASNode iNode) {
        ParameterDefinition first_param;
        FunctionDefinition func;
        IFunctionDefinition ctor;
        IClassDefinition super_def;
        if (iNode == null) {
            return;
        }
        ClassNode enclosing_class = (ClassNode)iNode.getAncestorOfType(ClassNode.class);
        if (enclosing_class != null && (super_def = enclosing_class.getDefinition().resolveBaseClass(this.project)) != null && (ctor = super_def.getConstructor()) instanceof FunctionDefinition && (func = (FunctionDefinition)ctor).getParameters() != null && func.getParameters().length != 0 && !(first_param = func.getParameters()[0]).hasDefaultValue() && !first_param.isRest()) {
            if (enclosing_class.getDefinition().getConstructor().isImplicit()) {
                this.addProblem(new NoDefaultConstructorInBaseClassProblem(enclosing_class, super_def.getBaseName()));
            } else {
                this.addProblem(new NoDefaultConstructorInBaseClassProblem(iNode, super_def.getBaseName()));
            }
        }
    }

    public void checkDeleteExpr(IASNode iNode, Binding binding) {
        IDefinition def = binding.getDefinition();
        if (def != null) {
            if (!this.utils.hasDynamicBase(binding) && !SemanticUtils.isInWith(iNode)) {
                this.addProblem(new AttemptToDeleteFixedPropertyProblem(iNode, binding.getName()));
            }
        } else if (SemanticUtils.hasBaseNode(binding) && !this.utils.hasDynamicBase(binding)) {
            this.addProblem(new AccessUndefinedMemberProblem(this.roundUpUsualSuspects(binding, iNode), binding.getName().getBaseName(), this.utils.getTypeOfBase(binding.getNode())));
        } else {
            this.checkLValue(iNode, binding);
        }
    }

    public void checkExplicitSuperCall(IASNode iNode, Vector<? extends Object> args) {
        IFunctionDefinition ctor;
        LanguageIdentifierNode super_node = (LanguageIdentifierNode)((IFunctionCallNode)iNode).getNameNode();
        if (!SemanticUtils.isInConstructor(iNode)) {
            this.addProblem(new InvalidSuperStatementProblem(iNode));
        } else if (this.superState != SuperState.Initial) {
            this.addProblem(new ExtraneousSuperStatementProblem(iNode));
        } else {
            this.superState = SuperState.Armed;
        }
        ClassDefinition super_def = (ClassDefinition)super_node.resolveType(this.project);
        if (super_def != null && (ctor = super_def.getConstructor()) instanceof FunctionDefinition) {
            this.checkFormalsVsActuals(super_node, (FunctionDefinition)ctor, args);
        }
    }

    private void checkFormalsVsActuals(IASNode iNode, FunctionDefinition func, Vector<? extends Object> actuals) {
        if (func instanceof GetterDefinition || func instanceof SetterDefinition) {
            return;
        }
        ParameterDefinition[] formals = func.getParameters();
        if (formals == null) {
            return;
        }
        boolean last_is_rest = formals.length > 0 && formals[formals.length - 1].isRest();
        int required_count = 0;
        if (actuals.size() > formals.length && !last_is_rest) {
            if (this.project.isParameterCountMismatchAllowed(func, formals.length, actuals.size())) {
                return;
            }
            this.addProblem(new TooManyFunctionParametersProblem(iNode, formals.length));
        }
        for (int i = 0; i < formals.length && !formals[i].hasDefaultValue() && !formals[i].isRest(); ++i) {
            ++required_count;
        }
        if (actuals.size() < required_count) {
            this.addProblem(new TooFewFunctionParametersProblem(iNode, required_count));
        }
        ContainerNode actuals_container = null;
        if (iNode instanceof FunctionCallNode) {
            actuals_container = ((FunctionCallNode)iNode).getArgumentsNode();
        }
        if (actuals_container != null) {
            for (int i = 0; i < actuals_container.getChildCount() && i < formals.length; ++i) {
                if (formals[i].isRest()) continue;
                this.checkImplicitConversion(actuals_container.getChild(i), formals[i].resolveType(this.project), func);
            }
        }
    }

    public void checkFunctionBody(IASNode iNode) {
        FunctionNode func;
        FunctionDefinition def;
        if (!(!(iNode instanceof FunctionNode) || (def = (func = (FunctionNode)iNode).getDefinition()).hasModifier(ASModifier.NATIVE) || def.hasModifier(ASModifier.DYNAMIC) || func.isConstructor() || func.hasBody())) {
            this.addProblem(new FunctionWithoutBodyProblem(SemanticUtils.getFunctionProblemNode(func)));
        }
    }

    public void checkNativeMethod(IASNode iNode) {
        if (iNode instanceof FunctionNode && ((FunctionNode)iNode).hasBody()) {
            this.addProblem(new NativeMethodWithBodyProblem(iNode));
        }
    }

    public void checkFunctionCall(IASNode iNode, Binding method_binding, Vector<? extends Object> actuals) {
        IDefinition def;
        if (method_binding.getName() == null) {
            return;
        }
        if (method_binding.getName().isAttributeName()) {
            this.addProblem(new AttributesAreNotCallableProblem(this.roundUpUsualSuspects(method_binding, iNode)));
        }
        if ((def = method_binding.getDefinition()) == null && this.utils.definitionCanBeAnalyzed(method_binding)) {
            if (this.utils.isInaccessible(iNode, method_binding)) {
                if (!method_binding.getName().getBaseName().equals("toString")) {
                    this.addProblem(new InaccessibleMethodReferenceProblem(this.roundUpUsualSuspects(method_binding, iNode), method_binding.getName().getBaseName(), this.utils.getTypeOfStem(iNode)));
                }
            } else if (SemanticUtils.hasExplicitStem(iNode) && this.utils.hasUnderlyingType(iNode)) {
                this.addProblem(new StrictUndefinedMethodProblem(this.roundUpUsualSuspects(method_binding, iNode), method_binding.getName().getBaseName(), this.utils.getTypeOfStem(iNode)));
            } else {
                this.addProblem(new CallUndefinedMethodProblem(this.roundUpUsualSuspects(method_binding, iNode), method_binding.getName().getBaseName()));
            }
        } else if (def instanceof FunctionDefinition) {
            FunctionDefinition func = (FunctionDefinition)def;
            this.checkFormalsVsActuals(iNode, func, actuals);
        } else if (def instanceof VariableDefinition) {
            VariableDefinition varDef = (VariableDefinition)def;
            TypeDefinitionBase varType = varDef.resolveType(this.project);
            if (varType != null && (varType.equals(this.project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER)) || varType.equals(this.project.getBuiltinType(IASLanguageConstants.BuiltinType.BOOLEAN)) || varType.equals(this.project.getBuiltinType(IASLanguageConstants.BuiltinType.INT)) || varType.equals(this.project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT)) || varType.equals(this.project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING)))) {
                this.addProblem(new CallNonFunctionProblem(iNode, method_binding.getName().getBaseName()));
            }
        } else if (def == this.project.getBuiltinType(IASLanguageConstants.BuiltinType.ARRAY)) {
            IExpressionNode argument;
            ITypeDefinition argumentType;
            boolean downcast = false;
            if (actuals.size() == 1 && ((argumentType = (argument = ((IFunctionCallNode)iNode).getArgumentNodes()[0]).resolveType(this.project)) == null || argumentType.equals(this.project.getBuiltinType(IASLanguageConstants.BuiltinType.ARRAY)) || argumentType.equals(this.project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT)) || argumentType.equals(this.project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE)))) {
                downcast = true;
            }
            if (downcast) {
                this.addProblem(new ArrayDowncastProblem(iNode));
            } else {
                this.addProblem(new ArrayCastProblem(iNode));
            }
        } else if (def != null && !AmbiguousDefinition.isAmbiguous(def) && def.getQualifiedName().equals("Date")) {
            if (actuals.size() > 0) {
                this.addProblem(new DateCastProblem(iNode));
            }
        } else if (def instanceof ITypeDefinition) {
            switch (actuals.size()) {
                case 0: {
                    this.addProblem(new TooFewFunctionParametersProblem(iNode, 1));
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    this.addProblem(new TooManyFunctionParametersProblem(iNode, 1));
                }
            }
        }
        this.checkReference(method_binding);
    }

    public void checkFunctionDefinition(IFunctionNode iNode, FunctionDefinition def) {
        ParameterDefinition[] formals;
        SemanticUtils.checkReturnValueHasNoTypeDeclaration(this.currentScope, iNode, def);
        if (SemanticUtils.isInFunction(iNode) && iNode instanceof BaseDefinitionNode) {
            this.checkForNamespaceInFunction((BaseDefinitionNode)((Object)iNode), this.currentScope);
        }
        if ((formals = def.getParameters()) == null) {
            return;
        }
        boolean found_optional = false;
        for (int i = 0; i < formals.length; ++i) {
            if (formals[i].hasDefaultValue()) {
                found_optional = true;
                if (!(def instanceof ISetterDefinition)) continue;
                this.addProblem(new SetterCannotHaveOptionalProblem(formals[i].getNode()));
                continue;
            }
            if (formals[i].isRest()) {
                if (i == formals.length - 1) continue;
                this.addProblem(new RestParameterMustBeLastProblem(formals[i].getNode()));
                continue;
            }
            if (!found_optional) continue;
            this.addProblem(new RequiredParameterAfterOptionalProblem(formals[i].getNode()));
        }
        TypeDefinitionBase return_type = (TypeDefinitionBase)def.resolveReturnType(this.project);
        if (return_type != null && def instanceof ISetterDefinition && return_type != this.project.getBuiltinType(IASLanguageConstants.BuiltinType.VOID) && return_type != this.project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE)) {
            this.addProblem(new BadSetterReturnTypeProblem(iNode.getReturnTypeNode()));
        }
        if (def instanceof IAccessorDefinition) {
            IAccessorDefinition accessorDef = (IAccessorDefinition)((Object)def);
            ITypeDefinition thisType = accessorDef.resolveType(this.project);
            IAccessorDefinition other = null;
            other = accessorDef.resolveCorrespondingAccessor(this.project);
            if (other != null) {
                ITypeDefinition otherType = other.resolveType(this.project);
                ITypeDefinition anyType = this.project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
                if (otherType != thisType && otherType != anyType && thisType != anyType) {
                    this.addProblem(new AccessorTypesMustMatchProblem(this.getAccessorTypeNode(iNode)));
                }
            }
            if (def instanceof IGetterDefinition) {
                if (formals.length > 0) {
                    this.addProblem(new GetterCannotHaveParametersProblem(formals[0].getNode()));
                }
                if (SemanticUtils.isBuiltin(thisType, IASLanguageConstants.BuiltinType.VOID, this.project)) {
                    this.addProblem(new GetterMustNotBeVoidProblem(iNode.getReturnTypeNode()));
                }
            }
            if (def instanceof ISetterDefinition && formals.length != 1) {
                this.addProblem(new SetterMustHaveOneParameterProblem(iNode.getNameExpressionNode()));
            }
        }
        this.checkNamespaceOfDefinition(iNode, def, this.project);
    }

    private IASNode getAccessorTypeNode(IFunctionNode iNode) {
        IParameterNode[] params;
        IASNode result = iNode.getNameExpressionNode();
        if (iNode.isSetter()) {
            IExpressionNode returnType = iNode.getReturnTypeNode();
            if (returnType != null) {
                result = returnType;
            }
        } else if (iNode.isGetter() && (params = iNode.getParameterNodes()) != null && params.length > 0) {
            result = params[0];
        }
        return result;
    }

    public void checkSimpleName(IASNode iNode, Binding binding) {
        block4: {
            FunctionDefinition functionDef;
            block3: {
                if (!SemanticUtils.isThisKeyword(iNode)) break block3;
                LanguageIdentifierNode.Context context = ((LanguageIdentifierNode)iNode).getContext();
                if (context != LanguageIdentifierNode.Context.STATIC_CONTEXT && context != LanguageIdentifierNode.Context.PACKAGE_CONTEXT) break block4;
                this.addProblem(new ThisUsedInStaticFunctionProblem(iNode));
                break block4;
            }
            if (SemanticUtils.isArgumentsReference(binding) && (functionDef = SemanticUtils.getFunctionDefinition(iNode)) != null) {
                ParameterDefinition[] parameters;
                for (ParameterDefinition param : parameters = functionDef.getParameters()) {
                    if (!param.isRest()) continue;
                    this.addProblem(new RestParamAndArgumentsUsedTogetherProblem(iNode));
                    break;
                }
            }
        }
        if (binding.getDefinition() == null && this.isPackageReference(binding)) {
            this.addProblem(new PackageCannotBeUsedAsValueProblem(iNode, binding.getName().getBaseName()));
        }
    }

    private static IASLanguageConstants.BuiltinType getBuiltinTypeOfPooledValue(PooledValue value) {
        switch (value.getKind()) {
            case 3: {
                return IASLanguageConstants.BuiltinType.INT;
            }
            case 4: {
                return IASLanguageConstants.BuiltinType.UINT;
            }
            case 6: {
                return IASLanguageConstants.BuiltinType.NUMBER;
            }
            case 1: {
                return IASLanguageConstants.BuiltinType.STRING;
            }
            case 10: 
            case 11: {
                return IASLanguageConstants.BuiltinType.BOOLEAN;
            }
            case 0: {
                return IASLanguageConstants.BuiltinType.VOID;
            }
            case 12: {
                return IASLanguageConstants.BuiltinType.NULL;
            }
            case 5: 
            case 8: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return IASLanguageConstants.BuiltinType.NAMESPACE;
            }
        }
        assert (false) : "Unknown default value kind " + value.getKind();
        return IASLanguageConstants.BuiltinType.ANY_TYPE;
    }

    private IDefinition getTypeOfPooledValue(PooledValue value) {
        IASLanguageConstants.BuiltinType builtinType = MethodBodySemanticChecker.getBuiltinTypeOfPooledValue(value);
        return this.utils.getBuiltinType(builtinType);
    }

    private PooledValue checkInitialValue(ISourceLocation initial_value_location, IDefinition desired_type, PooledValue initial_value) {
        IDefinition value_type = this.getTypeOfPooledValue(initial_value);
        if (desired_type == null || desired_type.equals(value_type) || this.utils.isInstanceOf(value_type, desired_type)) {
            return initial_value;
        }
        if (this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.OBJECT) || this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.ANY_TYPE)) {
            return initial_value;
        }
        if (this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.VOID)) {
            return initial_value;
        }
        if (this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.ARRAY) || this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.XML) || this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.FUNCTION) || this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.CLASS)) {
            if (this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.NULL)) {
                return initial_value;
            }
            this.addProblem(new IncompatibleInitializerTypeProblem(initial_value_location, value_type.getBaseName(), desired_type.getBaseName(), "null"));
            return new PooledValue(ABCConstants.NULL_VALUE);
        }
        if (this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.STRING)) {
            assert (!this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.STRING));
            if (this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.NULL)) {
                return initial_value;
            }
            String initial_value_string = ECMASupport.toString(initial_value.getValue());
            String initial_value_quoted = "\"" + initial_value_string + "\"";
            this.addProblem(new IncompatibleInitializerTypeProblem(initial_value_location, value_type.getBaseName(), desired_type.getBaseName(), initial_value_quoted));
            return new PooledValue(initial_value_string);
        }
        if (this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.BOOLEAN)) {
            assert (!this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.BOOLEAN));
            boolean initial_value_boolean = ECMASupport.toBoolean(initial_value.getValue());
            this.addProblem(new IncompatibleInitializerTypeProblem(initial_value_location, value_type.getBaseName(), desired_type.getBaseName(), String.valueOf(initial_value_boolean)));
            return new PooledValue(initial_value_boolean);
        }
        if (this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.NUMBER)) {
            if (this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.INT) || this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.UINT) || this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.NUMBER)) {
                return initial_value;
            }
            Number initial_value_numeric = ECMASupport.toNumeric(initial_value.getValue());
            double initial_value_double = initial_value_numeric != null ? initial_value_numeric.doubleValue() : 0.0;
            this.addProblem(new IncompatibleInitializerTypeProblem(initial_value_location, value_type.getBaseName(), desired_type.getBaseName(), String.valueOf(initial_value_double)));
            return new PooledValue(initial_value_double);
        }
        if (this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.UINT)) {
            return this.checkInitialUIntValue(initial_value_location, desired_type, initial_value, value_type);
        }
        if (this.utils.isBuiltin(desired_type, IASLanguageConstants.BuiltinType.INT)) {
            return this.checkInitialIntValue(initial_value_location, desired_type, initial_value, value_type);
        }
        this.addProblem(new IncompatibleInitializerTypeProblem(initial_value_location, value_type.getBaseName(), desired_type.getBaseName(), "null"));
        return new PooledValue(ABCConstants.NULL_VALUE);
    }

    private PooledValue checkInitialIntValue(ISourceLocation initial_value_location, IDefinition desired_type, PooledValue initial_value, IDefinition value_type) {
        assert (!this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.INT));
        if (this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.UINT)) {
            long initial_value_long = initial_value.getLongValue();
            if (initial_value_long > Integer.MAX_VALUE) {
                return this.addIntOutOfRangeProblem(initial_value_location, desired_type, initial_value_long);
            }
            return initial_value;
        }
        if (this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.NUMBER)) {
            double initial_value_double = initial_value.getDoubleValue();
            double initial_value_rounded = ECMASupport.toInteger(initial_value_double);
            int initial_value_int = ECMASupport.toInt32(initial_value_double);
            if (initial_value_rounded != initial_value_double) {
                this.addProblem(new InitializerValueNotAnIntegerProblem(initial_value_location, desired_type.getBaseName(), String.valueOf(initial_value_double), String.valueOf(initial_value_int)));
                return new PooledValue(initial_value_int);
            }
            if (initial_value_rounded < -2.147483648E9 || initial_value_rounded > 2.147483647E9) {
                return this.addIntOutOfRangeProblem(initial_value_location, desired_type, initial_value_rounded);
            }
            return new PooledValue(initial_value_int);
        }
        Number initial_value_numeric = ECMASupport.toNumeric(initial_value.getValue());
        double initial_value_double = initial_value_numeric != null ? initial_value_numeric.doubleValue() : 0.0;
        int initial_value_int = ECMASupport.toInt32(initial_value_double);
        this.addProblem(new IncompatibleInitializerTypeProblem(initial_value_location, value_type.getBaseName(), desired_type.getBaseName(), String.valueOf(initial_value_int)));
        return new PooledValue(initial_value_int);
    }

    private PooledValue checkInitialUIntValue(ISourceLocation initial_value_location, IDefinition desired_type, PooledValue initial_value, IDefinition value_type) {
        assert (!this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.UINT));
        if (this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.INT)) {
            int initial_value_int = initial_value.getIntegerValue();
            if (initial_value_int < 0) {
                return this.addUIntOutOfRangeProblem(initial_value_location, desired_type, initial_value_int);
            }
            return initial_value;
        }
        if (this.utils.isBuiltin(value_type, IASLanguageConstants.BuiltinType.NUMBER)) {
            double initial_value_double = initial_value.getDoubleValue();
            double initial_value_int = ECMASupport.toInteger(initial_value_double);
            long initial_value_long = ECMASupport.toUInt32(initial_value_int);
            if (initial_value_double != initial_value_int) {
                this.addProblem(new InitializerValueNotAnIntegerProblem(initial_value_location, desired_type.getBaseName(), String.valueOf(initial_value_double), String.valueOf(initial_value_long)));
                return new PooledValue(initial_value_long);
            }
            if (initial_value_int < 0.0 || initial_value_int > 4.294967295E9) {
                return this.addUIntOutOfRangeProblem(initial_value_location, desired_type, initial_value_int);
            }
            return new PooledValue(initial_value_long);
        }
        Number initial_value_numeric = ECMASupport.toNumeric(initial_value.getValue());
        double initial_value_double = initial_value_numeric != null ? initial_value_numeric.doubleValue() : 0.0;
        long initial_value_long = ECMASupport.toUInt32(initial_value_double);
        this.addProblem(new IncompatibleInitializerTypeProblem(initial_value_location, value_type.getBaseName(), desired_type.getBaseName(), String.valueOf(initial_value_long)));
        return new PooledValue(initial_value_long);
    }

    private PooledValue addUIntOutOfRangeProblem(ISourceLocation initial_value_location, IDefinition required_type, double initial_value_int) {
        long initial_value_long = ECMASupport.toUInt32(initial_value_int);
        this.addProblem(new InitializerValueOutOfRangeProblem(initial_value_location, required_type.getBaseName(), String.valueOf((long)initial_value_int), "0", String.valueOf(0xFFFFFFFFL), String.valueOf(initial_value_long)));
        return new PooledValue(initial_value_long);
    }

    private PooledValue addIntOutOfRangeProblem(ISourceLocation initial_value_location, IDefinition required_type, double initial_value_double) {
        int initial_value_int = ECMASupport.toInt32(initial_value_double);
        this.addProblem(new InitializerValueOutOfRangeProblem(initial_value_location, required_type.getBaseName(), String.valueOf((long)initial_value_double), String.valueOf(Integer.MIN_VALUE), String.valueOf(Integer.MAX_VALUE), String.valueOf(initial_value_int)));
        return new PooledValue(initial_value_int);
    }

    public void checkGetProperty(Binding binding) {
        Name name = binding.getName();
        assert (name != null);
        if (this.utils.isWriteOnlyDefinition(binding.getDefinition())) {
            this.addProblem(new PropertyIsWriteOnlyProblem(binding.getNode(), name.getBaseName()));
        }
        switch (name.getKind()) {
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            default: {
                if (binding.getDefinition() == null && SemanticUtils.definitionCanBeAnalyzed(binding, this.project)) {
                    this.addProblem(this.accessUndefinedProperty(binding, binding.getNode()));
                }
                this.checkReference(binding);
            }
        }
    }

    public void checkReference(Binding b) {
        this.checkReference(b, false);
    }

    public void checkReference(Binding b, boolean forLValue) {
        IDefinition definition;
        if (b != null && (definition = b.getDefinition()) != null) {
            if (forLValue && definition instanceof IGetterDefinition || !forLValue && definition instanceof ISetterDefinition) {
                definition = ((IAccessorDefinition)definition).resolveCorrespondingAccessor(this.project);
            }
            IASNode node = b.getNode();
            this.checkAmbiguousReference(b);
            this.checkDeprecated(node, definition);
        }
    }

    private void checkAmbiguousReference(Binding b) {
        if (SemanticUtils.isAmbiguousReference(b)) {
            this.addProblem(new AmbiguousReferenceProblem(b.getNode(), b.getName().getBaseName()));
        }
    }

    private void checkDeprecated(IASNode site, IDefinition def) {
        if (def != null && def.isDeprecated() && !SemanticUtils.hasDeprecatedAncestor(site)) {
            ICompilerProblem problem = SemanticUtils.createDeprecationProblem(def, site);
            this.addProblem(problem);
        }
    }

    public PooledValue checkInitialValue(IVariableNode iNode, Binding type, PooledValue initial_value) {
        assert (initial_value != null) : "Caller's should generate a compiler problem when a default_value is missing and *not* call this method!";
        IExpressionNode assignedValueExpressionLocation = iNode.getAssignedValueNode();
        IDefinition target_type = type.getDefinition();
        return this.checkInitialValue(assignedValueExpressionLocation, target_type, initial_value);
    }

    private ICompilerProblem accessUndefinedProperty(Binding b, IASNode iNode) {
        String unknown_name = null;
        if (b.getName() != null) {
            unknown_name = b.getName().getBaseName();
        } else if (SemanticUtils.isThisKeyword(iNode)) {
            unknown_name = "this";
        } else {
            return null;
        }
        if (b.getNode() instanceof MemberAccessExpressionNode) {
            MemberAccessExpressionNode maex = (MemberAccessExpressionNode)b.getNode();
            if (maex.stemIsPackage() && maex.getLeftOperandNode() instanceof IdentifierNode) {
                return new AccessUndefinedPropertyInPackageProblem(iNode, unknown_name, ((IdentifierNode)maex.getLeftOperandNode()).getName());
            }
        } else {
            ICompilerProblem problem = this.isMissingMember(b.getNode());
            if (problem != null) {
                return problem;
            }
            if (this.utils.isInInstanceFunction(iNode) && this.utils.isInaccessible((ASScope)this.utils.getEnclosingFunctionDefinition(iNode).getContainingScope(), b)) {
                return new InaccessiblePropertyReferenceProblem(iNode, b.getName().getBaseName(), this.utils.getEnclosingClassName(iNode));
            }
        }
        while (iNode.getSourcePath().contains("compiler-jx") && iNode.getSourcePath().contains("config.as")) {
            iNode = iNode.getParent();
        }
        return new AccessUndefinedPropertyProblem(iNode, unknown_name);
    }

    public ICompilerProblem isMissingMember(IASNode iNode) {
        ITypeDefinition leftDef;
        MemberAccessExpressionNode mae;
        if (iNode instanceof IdentifierNode && iNode.getParent() instanceof MemberAccessExpressionNode && iNode == (mae = (MemberAccessExpressionNode)iNode.getParent()).getRightOperandNode() && !(leftDef = mae.getLeftOperandNode().resolveType(this.project)).isDynamic()) {
            return new AccessUndefinedMemberProblem(iNode, ((IdentifierNode)iNode).getName(), leftDef.getQualifiedName());
        }
        return null;
    }

    public void checkSuperAccess(IASNode iNode) {
        IDefinition def = this.utils.getDefinition(iNode);
        if (def == null && !this.utils.isInInstanceFunction(iNode)) {
            this.addProblem(new InvalidSuperExpressionProblem(iNode));
        }
        if (iNode instanceof IFunctionCallNode) {
            IExpressionNode nameNode = ((IFunctionCallNode)iNode).getNameNode();
            IExpressionNode site = ((IMemberAccessExpressionNode)nameNode).getRightOperandNode();
            def = ((IFunctionCallNode)iNode).resolveCalledExpression(this.project);
            this.checkDeprecated(site, def);
        }
        if (this.superState == SuperState.Initial) {
            this.superState = SuperState.Armed;
        }
    }

    private boolean isPackageReference(Binding b) {
        IASNode n = b.getNode();
        return n instanceof ExpressionNodeBase && ((ExpressionNodeBase)n).isPackageReference();
    }

    public void checkIncDec(IASNode iNode, boolean is_incr) {
        IExpressionNode operand = ((IUnaryOperatorNode)iNode).getOperandNode();
        this.checkImplicitConversion(operand, this.utils.numberType(), null);
        IDefinition def = this.utils.getDefinition(operand);
        if (this.utils.isReadOnlyDefinition(def)) {
            if (is_incr) {
                this.addProblem(new InvalidIncrementOperandProblem(iNode));
            } else {
                this.addProblem(new InvalidDecrementOperandProblem(iNode));
            }
        } else if (!(def instanceof SetterDefinition) && !(def instanceof GetterDefinition)) {
            if (def instanceof IFunctionDefinition || def instanceof ClassDefinition) {
                if (is_incr) {
                    this.addProblem(new InvalidIncrementOperandProblem(iNode));
                } else {
                    this.addProblem(new InvalidDecrementOperandProblem(iNode));
                }
            } else if (SemanticUtils.isConstDefinition(def)) {
                if (is_incr) {
                    this.addProblem(new InvalidIncrementOperandProblem(iNode));
                } else {
                    this.addProblem(new InvalidDecrementOperandProblem(iNode));
                }
            }
        }
    }

    public void checkIncDec(IASNode iNode, boolean is_incr, Binding binding) {
        this.checkIncDec(iNode, is_incr);
        if (binding.getName() != null) {
            this.checkGetProperty(binding);
        } else {
            this.addProblem(is_incr ? new IncrementMustBeReferenceProblem(iNode) : new DecrementMustBeReferenceProblem(iNode));
        }
    }

    public void checkLValue(IASNode iNode, Binding binding) {
        IDefinition def = binding.getDefinition();
        if (SemanticUtils.isThisKeyword(binding.getNode())) {
            this.addProblem(new AssignToNonReferenceValueProblem(binding.getNode()));
        } else if (def == null && !this.utils.hasDynamicBase(binding) && !SemanticUtils.isInWith(binding.getNode())) {
            this.addProblem(this.accessUndefinedProperty(binding, this.roundUpUsualSuspects(binding, iNode)));
        } else if (def instanceof IConstantDefinition) {
            this.addProblem(new AssignToConstProblem(iNode));
        } else if (this.utils.isReadOnlyDefinition(def)) {
            this.addProblem(new AssignToReadOnlyPropertyProblem(iNode, binding.getName().getBaseName()));
        } else if (!(def instanceof SetterDefinition) && !(def instanceof GetterDefinition)) {
            if (def instanceof IFunctionDefinition) {
                this.addProblem(new AssignToFunctionProblem(iNode, binding.getName().getBaseName()));
            } else if (def instanceof ClassDefinition) {
                this.addProblem(new IllegalAssignmentToClassProblem(this.roundUpUsualSuspects(binding, iNode), binding.getName().getBaseName()));
            }
        }
        this.checkReference(binding, true);
    }

    public void checkMemberAccess(IASNode iNode, Binding member, int opcode) {
        IASNode member_node = member.getNode();
        if (member_node == null) {
            return;
        }
        IDefinition def = this.utils.getDefinition(member_node);
        if (def == null && this.utils.definitionCanBeAnalyzed(member)) {
            if (member_node.getParent() instanceof NamespaceAccessExpressionNode) {
                return;
            }
            if (this.utils.isInaccessible(iNode, member)) {
                this.addProblem(new InaccessiblePropertyReferenceProblem(member_node, member.getName().getBaseName(), this.utils.getTypeOfStem(iNode)));
            } else {
                IMemberAccessExpressionNode maen;
                IExpressionNode right;
                SemanticProblem p = null;
                if (iNode instanceof IMemberAccessExpressionNode && (right = (maen = (IMemberAccessExpressionNode)iNode).getRightOperandNode()) instanceof IIdentifierNode && ((IIdentifierNode)right).getName().isEmpty()) {
                    p = new MissingPropertyNameProblem(right);
                }
                if (p == null) {
                    p = new AccessUndefinedMemberProblem(member_node, member.getName().getBaseName(), this.utils.getTypeOfStem(iNode));
                }
                this.addProblem(p);
            }
        } else if (this.utils.isWriteOnlyDefinition(member.getDefinition())) {
            this.addProblem(new PropertyIsWriteOnlyProblem(member_node, member.getName().getBaseName()));
        } else {
            this.checkReference(member);
        }
    }

    public void checkNewExpr(IASNode call_node) {
        ExpressionNodeBase name = ((FunctionCallNode)call_node).getNameNode();
        if (name instanceof MemberAccessExpressionNode) {
            MemberAccessExpressionNode func_name = (MemberAccessExpressionNode)name;
            IDefinition def = func_name.resolve(this.project);
            if (def instanceof InterfaceDefinition) {
                this.addProblem(new InterfaceCannotBeInstantiatedProblem(call_node));
            } else if (!(def instanceof ClassDefinition) && !(def instanceof GetterDefinition) && def instanceof FunctionDefinition) {
                FunctionDefinition func_def = (FunctionDefinition)def;
                switch (func_def.getFunctionClassification()) {
                    case CLASS_MEMBER: 
                    case INTERFACE_MEMBER: {
                        this.addProblem(new MethodCannotBeConstructorProblem(call_node));
                    }
                }
            }
        }
    }

    public void checkNewExpr(IASNode iNode, Binding class_binding, Vector<? extends Object> args) {
        IDefinition def = class_binding.getDefinition();
        if (!class_binding.isLocal()) {
            FunctionDefinition func_def;
            IFunctionDefinition.FunctionClassification func_type;
            if (def == null && this.utils.definitionCanBeAnalyzed(class_binding) && !class_binding.getName().isTypeName()) {
                this.addProblem(new CallUndefinedMethodProblem(this.roundUpUsualSuspects(class_binding, iNode), class_binding.getName().getBaseName()));
            } else if (def instanceof InterfaceDefinition) {
                this.addProblem(new InterfaceCannotBeInstantiatedProblem(this.roundUpUsualSuspects(class_binding, iNode)));
            } else if (def instanceof ClassDefinition) {
                ClassDefinition class_def = (ClassDefinition)def;
                IFunctionDefinition ctor = class_def.getConstructor();
                if (ctor instanceof FunctionDefinition) {
                    FunctionDefinition func = (FunctionDefinition)ctor;
                    this.checkFormalsVsActuals(iNode, func, args);
                }
            } else if (!(def instanceof GetterDefinition) && def instanceof FunctionDefinition && ((func_type = (func_def = (FunctionDefinition)def).getFunctionClassification()).equals((Object)IFunctionDefinition.FunctionClassification.CLASS_MEMBER) || func_type.equals((Object)IFunctionDefinition.FunctionClassification.INTERFACE_MEMBER))) {
                this.addProblem(new MethodCannotBeConstructorProblem(this.roundUpUsualSuspects(class_binding, iNode)));
            }
        }
        this.checkReference(class_binding);
    }

    public void checkReturnValue(IASNode iNode) {
        block13: {
            FunctionDefinition func_def = SemanticUtils.getFunctionDefinition(iNode);
            if (func_def != null) {
                try {
                    IExpressionNode returnExpression = ((IReturnNode)iNode).getReturnValueNode();
                    ITypeDefinition return_type = func_def.resolveReturnType(this.project);
                    if (ClassDefinition.getVoidClassDefinition().equals(return_type)) {
                        ITypeDefinition value_type = ((ExpressionNodeBase)returnExpression).resolveType(this.project);
                        if (value_type != null && !value_type.equals(ClassDefinition.getVoidClassDefinition())) {
                            this.addProblem(new ReturnValueMustBeUndefinedProblem(returnExpression));
                        }
                        break block13;
                    }
                    if (func_def.isConstructor()) {
                        this.addProblem(new ReturnValueInConstructorProblem(returnExpression));
                        break block13;
                    }
                    this.checkImplicitConversion(returnExpression, return_type, null);
                }
                catch (Exception exception) {}
            } else if (this.isInPackageDefinition(iNode)) {
                this.addProblem(new ReturnCannotBeUsedInPackageProblem(iNode));
            } else if (this.isInClassDefinition(iNode)) {
                this.addProblem(new ReturnCannotBeUsedInStaticProblem(iNode));
            } else if (iNode.getAncestorOfType(MXMLDocumentNode.class) == null) {
                this.addProblem(new ReturnCannotBeUsedInGlobalProblem(iNode));
            }
        }
        if (this.superState == SuperState.Initial) {
            this.superState = SuperState.Armed;
        }
    }

    public void checkReturnVoid(IASNode iNode) {
        if (SemanticUtils.isInFunction(iNode)) {
            if (SemanticUtils.functionMustReturnValue(iNode, this.project)) {
                this.addProblem(new ReturnMustReturnValueProblem(iNode));
            }
        } else if (this.isInClassDefinition(iNode)) {
            this.addProblem(new ReturnCannotBeUsedInStaticProblem(iNode));
        } else if (this.isInPackageDefinition(iNode)) {
            this.addProblem(new ReturnCannotBeUsedInPackageProblem(iNode));
        } else if (iNode.getAncestorOfType(MXMLDocumentNode.class) == null) {
            this.addProblem(new ReturnCannotBeUsedInGlobalProblem(iNode));
        }
        if (this.superState == SuperState.Initial) {
            this.superState = SuperState.Armed;
        }
    }

    public void checkControlFlow(IASNode iNode, MethodInfo mi, MethodBodyInfo mbi) {
        InstructionList il = mbi.getInstructionList();
        if (il.size() > 0 && il.lastElement() == ABCGeneratingReducer.synthesizedReturnVoid && SemanticUtils.functionMustReturnValue(iNode, this.project)) {
            for (IBasicBlock b : mbi.getCfg().blocksInControlFlowOrder()) {
                if (b.size() <= 0 || b.get(b.size() - 1) != ABCGeneratingReducer.synthesizedReturnVoid) continue;
                this.addProblem(new ReturnMustReturnValueProblem(iNode));
                break;
            }
        }
    }

    public void checkThrow(IASNode iNode) {
        if (this.superState == SuperState.Initial) {
            this.superState = SuperState.Armed;
        }
    }

    public void checkImportDirective(IImportNode importNode) {
        IExpressionNode site = importNode.getImportNameNode();
        if (!SemanticUtils.isValidImport(importNode, this.project, this.currentScope.getInInvisibleCompilationUnit())) {
            String importName = importNode.getImportName();
            if (importNode.isWildcardImport()) {
                this.addProblem(new UnknownWildcardImportProblem(site, importName));
            } else {
                this.addProblem(new UnknownImportProblem(site, importName));
            }
        }
        if (!importNode.isWildcardImport()) {
            IDefinition importedDefinition = importNode.resolveImport(this.project);
            this.checkDeprecated(site, importedDefinition);
        }
    }

    public void checkUseNamespaceDirective(IASNode iNode, Binding ns_name) {
        if (ns_name.getDefinition() == null && ns_name.getName() != null) {
            String fullNamespaceName = null;
            IASNode n = ns_name.getNode();
            fullNamespaceName = n instanceof IIdentifierNode ? ((IIdentifierNode)n).getName() : ns_name.getName().getBaseName();
            this.addProblem(new UnknownNamespaceProblem(this.roundUpUsualSuspects(ns_name, iNode), fullNamespaceName));
        }
        this.checkReference(ns_name);
    }

    public void checkUnaryOperator(IASNode iNode, int opcode) {
        switch (opcode) {
            case 117: 
            case 144: 
            case 151: {
                this.checkImplicitConversion(((IUnaryOperatorNode)iNode).getOperandNode(), this.utils.numberType(), null);
            }
        }
    }

    private boolean isInClassDefinition(IASNode iNode) {
        return iNode.getAncestorOfType(ClassNode.class) != null;
    }

    private boolean isInPackageDefinition(IASNode iNode) {
        return iNode.getAncestorOfType(PackageNode.class) != null;
    }

    public void checkForDuplicateModifiers(BaseDefinitionNode bdn) {
        int modifierNodeCount;
        ModifiersContainerNode mcn = bdn.getModifiersContainer();
        ModifiersSet modifierSet = bdn.getModifiers();
        if (mcn != null && modifierSet != null && (modifierNodeCount = mcn.getChildCount()) > modifierSet.getAllModifiers().length) {
            ModifiersSet tempSet = new ModifiersSet();
            for (int i = 0; i < modifierNodeCount; ++i) {
                IASNode node = mcn.getChild(i);
                if (!(node instanceof ModifierNode)) continue;
                ModifierNode modNode = (ModifierNode)node;
                if (tempSet.hasModifier(modNode.getModifier())) {
                    this.currentScope.addProblem(new DuplicateAttributeProblem(modNode, modNode.getModifierString()));
                }
                tempSet.addModifier(modNode);
            }
        }
    }

    private void checkForNamespaceInFunction(BaseDefinitionNode node, LexicalScope scope) {
        assert (SemanticUtils.isInFunction(node));
        DefinitionBase def = node.getDefinition();
        INamespaceReference nsRef = def.getNamespaceReference();
        if (!(nsRef instanceof INamespaceDefinition.IInternalNamespaceDefinition) && !(nsRef instanceof INamespaceDefinition.IFilePrivateNamespaceDefinition)) {
            IASNode site = node.getNamespaceNode();
            if (site == null) {
                site = node;
            }
            boolean isAccessor = nsRef instanceof INamespaceDefinition.ILanguageNamespaceDefinition;
            this.currentScope.addProblem(new NamespaceOverrideInsideFunctionProblem(site, isAccessor));
        }
    }

    public void checkVariableDeclaration(IASNode iNode) {
        VariableNode var = (VariableNode)iNode;
        ModifiersSet modifiersSet = var.getModifiers();
        boolean isInFunction = SemanticUtils.isInFunction(iNode);
        if (isInFunction) {
            this.checkForNamespaceInFunction(var, this.currentScope);
        }
        if (isInFunction && modifiersSet != null) {
            IExpressionNode site = var.getNameExpressionNode();
            for (ASModifier modifier : modifiersSet.getAllModifiers()) {
                if (modifier == ASModifier.NATIVE) {
                    this.currentScope.addProblem(new NativeVariableProblem(site));
                    continue;
                }
                if (modifier == ASModifier.DYNAMIC) {
                    this.currentScope.addProblem(new DynamicNotOnClassProblem(site));
                    continue;
                }
                if (modifier == ASModifier.FINAL) {
                    this.currentScope.addProblem(new FinalOutsideClassProblem(site));
                    continue;
                }
                if (modifier == ASModifier.OVERRIDE) {
                    this.currentScope.addProblem(new InvalidOverrideProblem(site));
                    continue;
                }
                if (modifier == ASModifier.VIRTUAL) {
                    this.currentScope.addProblem(new VirtualOutsideClassProblem(site));
                    continue;
                }
                if (modifier != ASModifier.STATIC) continue;
                this.currentScope.addProblem(new StaticOutsideClassProblem(site));
            }
        }
        IDefinition def = this.utils.getDefinition(var);
        this.checkVariableForConflictingDefinitions(iNode, (VariableDefinition)def);
        this.checkNamespaceOfDefinition(var, def, this.project);
        String type = var.getTypeName();
        if (type.isEmpty() && var.getStart() != var.getEnd()) {
            IASNode location = var;
            IExpressionNode nameExpression = var.getNameExpressionNode();
            if (nameExpression != null) {
                location = nameExpression;
            }
            this.currentScope.addProblem(new VariableHasNoTypeDeclarationProblem(location, var.getShortName()));
        }
        ExpressionNodeBase rightNode = var.getAssignedValueNode();
        if (var.isConst() && rightNode == null) {
            this.addProblem(new ConstNotInitializedProblem(var, var.getName()));
        }
        if (rightNode != null) {
            this.checkAssignmentValue(def, rightNode);
        }
        if (SemanticUtils.isNestedClassProperty(iNode, (VariableDefinition)def)) {
            this.addProblem(new BURMDiagnosticNotAllowedHereProblem(iNode));
        }
    }

    public void checkTypeName(Binding typename) {
        IDefinition typeDef;
        if (typename.getNode() != null && typename.getName() != null && !SemanticUtils.isType(typeDef = this.utils.getDefinition(typename.getNode()))) {
            Name name;
            for (name = typename.getName(); name != null && name.isTypeName() && name.getTypeNameParameter() != null; name = name.getTypeNameParameter()) {
            }
            if (name != null) {
                if (!name.isTypeName()) {
                    this.addTypeProblem(typename.getNode(), typeDef, name.getBaseName(), false);
                } else {
                    this.addTypeProblem(typename.getNode(), typeDef, name.toString(), false);
                }
            }
        }
        this.checkReference(typename);
    }

    public void checkClassField(VariableNode var) {
        this.checkVariableDeclaration(var);
        ExpressionNodeBase typeNode = var.getTypeNode();
        IDefinition typeDef = this.utils.getDefinition(typeNode);
        if (!SemanticUtils.isType(typeDef)) {
            IASNode problematicType = this.utils.getPotentiallyParameterizedType(typeNode);
            String typeDesc = problematicType instanceof IdentifierNode ? ((IdentifierNode)problematicType).getName() : var.getTypeName();
            this.addTypeProblem(problematicType, typeDef, typeDesc, true);
        }
    }

    public void addTypeProblem(IASNode typeNode, IDefinition typeDef, String typeDesc, boolean reportAmbiguousReference) {
        if (AmbiguousDefinition.isAmbiguous(typeDef)) {
            if (reportAmbiguousReference) {
                this.addProblem(new AmbiguousReferenceProblem(typeNode, typeDesc));
            }
        } else {
            this.addProblem(new UnknownTypeProblem(typeNode, typeDesc));
        }
    }

    public void checkQualifier(IASNode iNode) {
        IDefinition qualifier = this.utils.getDefinition(iNode);
        if (qualifier == NamespaceDefinition.getCodeModelImplicitDefinitionNamespace()) {
            INamespaceDecorationNode nsNode = (INamespaceDecorationNode)iNode;
            String nsString = nsNode.getName();
            if (nsString == "public") {
                this.addProblem(new InvalidPublicNamespaceProblem(nsNode));
            } else if (nsString == "protected") {
                this.addProblem(new InvalidProtectedNamespaceProblem(nsNode));
            } else if (nsString == "private") {
                this.addProblem(new InvalidPrivateNamespaceProblem(nsNode));
            }
        }
        this.checkDeprecated(iNode, qualifier);
    }

    public void checkNamespaceDeclaration(IASNode iNode, Binding ns_name) {
        ExpressionNodeBase namespaceInitialValueNode;
        NamespaceNode nsNode = (NamespaceNode)iNode;
        IDefinition def = this.utils.getDefinition(nsNode);
        this.checkNamespaceOfDefinition(nsNode, def, this.project);
        SemanticUtils.checkScopedToDefaultNamespaceProblem(this.currentScope, nsNode, def, null);
        if (SemanticUtils.isInFunction(iNode) && iNode instanceof BaseDefinitionNode) {
            this.checkForNamespaceInFunction((BaseDefinitionNode)iNode, this.currentScope);
        }
        if ((namespaceInitialValueNode = nsNode.getNamespaceURINode()) != null) {
            IDefinition namespaceInitialvalueDefinition = namespaceInitialValueNode.resolve(this.project);
            this.checkDeprecated(namespaceInitialValueNode, namespaceInitialvalueDefinition);
        }
    }

    public void checkNamespaceOfDefinition(IASNode iNode, IDefinition def, ICompilerProject project) {
        INamespaceReference nsRef = def.getNamespaceReference();
        if (!(nsRef.isLanguageNamespace() || def.getParent() instanceof IClassDefinition || SemanticUtils.isInFunction(iNode))) {
            this.addProblem(new InvalidNamespaceProblem(iNode instanceof BaseDefinitionNode ? ((BaseDefinitionNode)iNode).getNamespaceNode() : iNode));
        }
        if (nsRef == NamespaceDefinition.getCodeModelImplicitDefinitionNamespace() && !this.isConstructor(def)) {
            INamespaceDecorationNode nsNode;
            BaseDefinitionNode bdn;
            BaseDefinitionNode baseDefinitionNode = bdn = iNode instanceof BaseDefinitionNode ? (BaseDefinitionNode)iNode : null;
            if (bdn != null && (nsNode = bdn.getNamespaceNode()) != null) {
                String nsString = nsNode.getName();
                if (nsString == "public") {
                    this.addProblem(new InvalidPublicNamespaceAttrProblem(nsNode));
                } else if (nsString == "protected") {
                    this.addProblem(new InvalidProtectedNamespaceAttrProblem(nsNode));
                } else if (nsString == "private") {
                    this.addProblem(new InvalidPrivateNamespaceAttrProblem(nsNode));
                }
            }
        }
        IASNode nsNode = iNode instanceof BaseDefinitionNode ? ((BaseDefinitionNode)iNode).getNamespaceNode() : iNode;
        INamespaceDefinition nsDef = nsRef.resolveNamespaceReference(project);
        if (nsRef.resolveNamespaceReference(project) == null) {
            this.addProblem(new UnresolvedNamespaceProblem(nsNode));
        }
        this.checkDeprecated(nsNode, nsDef);
    }

    private boolean isConstructor(IDefinition d) {
        return d instanceof IFunctionDefinition && ((IFunctionDefinition)d).isConstructor();
    }

    public void checkVectorLiteral(IASNode iNode, Binding type_param) {
        IDefinition type_def = type_param.getDefinition();
        ContainerNode contentsNode = ((VectorLiteralNode)iNode).getContentsNode();
        if (type_def != null) {
            boolean isNumericTypeOrBoolean = SemanticUtils.isNumericTypeOrBoolean(type_def, this.project);
            String typeName = type_def.getBaseName();
            boolean isInt = SemanticUtils.isBuiltin(type_def, IASLanguageConstants.BuiltinType.INT, this.project);
            boolean isUint = SemanticUtils.isBuiltin(type_def, IASLanguageConstants.BuiltinType.UINT, this.project);
            for (int i = 0; i < contentsNode.getChildCount(); ++i) {
                IASNode literal_element = contentsNode.getChild(i);
                if (isNumericTypeOrBoolean) {
                    ITypeDefinition elementType;
                    boolean elementIsNull;
                    if (literal_element instanceof NumericLiteralNode) {
                        INumericLiteralNode.INumericValue numeric = ((NumericLiteralNode)literal_element).getNumericValue();
                        if (isInt && numeric.toNumber() != (double)numeric.toInt32() || isUint && numeric.toNumber() != (double)numeric.toUint32()) {
                            this.addProblem(new LossyConversionProblem(literal_element, typeName));
                        }
                    }
                    if (literal_element instanceof IExpressionNode && (elementIsNull = SemanticUtils.isBuiltin(elementType = ((IExpressionNode)literal_element).resolveType(this.project), IASLanguageConstants.BuiltinType.NULL, this.project))) {
                        this.addProblem(new NullUsedWhereOtherExpectedProblem(literal_element, typeName));
                    }
                }
                this.checkImplicitConversion(literal_element, type_def, null);
            }
        }
    }

    private IASNode roundUpUsualSuspects(Binding offender, IASNode bystander) {
        if (offender.getNode() != null) {
            return offender.getNode();
        }
        return bystander;
    }

    public void checkRestParameter(IASNode iNode, Binding param_type) {
        IDefinition type = param_type.getDefinition();
        if (!this.utils.isBuiltin(type, IASLanguageConstants.BuiltinType.ARRAY) && !this.utils.isBuiltin(type, IASLanguageConstants.BuiltinType.ANY_TYPE)) {
            this.addProblem(new InvalidRestParameterDeclarationProblem(((ParameterNode)iNode).getTypeNode()));
        }
    }

    public boolean checkFunctionForConflictingDefinitions(IASNode iNode, FunctionDefinition funcDef) {
        ASScope cs;
        boolean foundConflict = false;
        switch (SemanticUtils.getMultiDefinitionType(funcDef, this.project)) {
            case AMBIGUOUS: {
                String namespaceName = this.getNamespaceStringFromDef(funcDef);
                this.addProblem(new ConflictingNameInNamespaceProblem(iNode, funcDef.getBaseName(), namespaceName));
                foundConflict = true;
                break;
            }
            case NONE: {
                break;
            }
            case MULTIPLE: {
                this.addProblem(new DuplicateFunctionDefinitionProblem(iNode, funcDef.getBaseName()));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (funcDef instanceof IAccessorDefinition && (cs = (ASScope)funcDef.getContainingScope()).isPackageName(funcDef.getBaseName())) {
            IFunctionNode funcNode = (IFunctionNode)iNode;
            IExpressionNode funcNameNode = funcNode.getNameExpressionNode();
            this.addProblem(new DefinitionShadowedByPackageNameProblem(funcNameNode));
        }
        return foundConflict;
    }

    public void checkInterfaceFunctionForConflictingDefinitions(IASNode iNode, FunctionDefinition funcDef) {
        this.checkFunctionForConflictingDefinitions(iNode, funcDef);
        List<IFunctionDefinition> conflicts = funcDef.resolveOverridenInterfaceFunctions(this.project);
        if (conflicts.size() > 0) {
            for (IFunctionDefinition overriden : conflicts) {
                if (overriden instanceof SetterDefinition && funcDef instanceof GetterDefinition || overriden instanceof GetterDefinition && funcDef instanceof SetterDefinition) continue;
                this.addProblem(new InterfaceMethodOverrideProblem(iNode, funcDef.getBaseName(), overriden.getParent().getBaseName()));
            }
        }
    }

    public void checkVariableForConflictingDefinitions(IASNode iNode, VariableDefinition varDef) {
        ASScope cs;
        SemanticUtils.MultiDefinitionType ambiguity = SemanticUtils.getMultiDefinitionType(varDef, this.project);
        if (ambiguity != SemanticUtils.MultiDefinitionType.NONE) {
            String varName = varDef.getBaseName();
            SemanticProblem problem = null;
            if (ambiguity == SemanticUtils.MultiDefinitionType.AMBIGUOUS) {
                problem = new ConflictingNameInNamespaceProblem(iNode, varName, this.getNamespaceStringFromDef(varDef));
            } else {
                IVariableNode varNode = (IVariableNode)iNode;
                IExpressionNode varNameNode = varNode.getNameExpressionNode();
                if (ambiguity == SemanticUtils.MultiDefinitionType.MULTIPLE) {
                    problem = new DuplicateVariableDefinitionProblem(varNameNode, varName);
                } else if (ambiguity == SemanticUtils.MultiDefinitionType.SHADOWS_PARAM) {
                    problem = new VariableDefinitionDuplicatesParameterProblem(varNameNode, varName);
                }
            }
            assert (problem != null);
            if (problem != null) {
                this.addProblem(problem);
            }
        }
        if (!varDef.isStatic() && SemanticUtils.hasBaseClassDefinition(iNode, this.project)) {
            this.addProblem(new ConflictingInheritedNameInNamespaceProblem(iNode, varDef.getBaseName(), this.getNamespaceStringFromDef(varDef)));
        }
        if ((cs = (ASScope)varDef.getContainingScope()).isPackageName(varDef.getBaseName())) {
            IVariableNode varNode = (IVariableNode)iNode;
            IExpressionNode varNameNode = varNode.getNameExpressionNode();
            this.addProblem(new DefinitionShadowedByPackageNameProblem(varNameNode));
        }
    }

    private String getNamespaceStringFromDef(IDefinition funcDef) {
        String namespaceName = null;
        INamespaceDefinition n = funcDef.resolveNamespace(this.project);
        if (n != null) {
            namespaceName = n.getBaseName();
        }
        return namespaceName;
    }

    public void enterConstructor() {
        assert (this.superState == SuperState.Invalid) : String.format("Unexpected super() tracking state %s", new Object[]{this.superState});
        this.superState = SuperState.Initial;
    }

    public void leaveConstructor() {
        assert (this.superState != SuperState.Invalid) : String.format("Unexpected super() tracking state %s", new Object[]{this.superState});
        this.superState = SuperState.Invalid;
    }

    public boolean canGetterBeInlined(AccessorDefinition accessor) {
        if (accessor instanceof SetterDefinition) {
            accessor = accessor.resolveCorrespondingAccessor(this.currentScope.getProject());
        }
        if (accessor == null) {
            return false;
        }
        return this.canFunctionBeInlined(accessor);
    }

    public boolean canSetterBeInlined(AccessorDefinition accessor) {
        if (accessor instanceof GetterDefinition) {
            accessor = accessor.resolveCorrespondingAccessor(this.currentScope.getProject());
        }
        if (accessor == null) {
            return false;
        }
        return this.canFunctionBeInlined(accessor);
    }

    public boolean canFunctionBeInlined(FunctionDefinition function) {
        if (!this.currentScope.getProject().isInliningEnabled()) {
            return false;
        }
        boolean reportInlineProblems = function.isInline();
        if (this.currentScope.insideInlineFunction()) {
            if (reportInlineProblems) {
                this.currentScope.addProblem(new InlineNestedInliningNotSupportedProblem(function.getBaseName()));
            }
            return false;
        }
        FunctionNode functionNode = (FunctionNode)function.getFunctionNode();
        if (functionNode == null) {
            if (reportInlineProblems) {
                this.currentScope.addProblem(new InlineNoSourceProblem(function.getBaseName()));
            }
            return false;
        }
        if (!function.inlineFunction()) {
            if (reportInlineProblems) {
                this.currentScope.addProblem(new InlineFunctionNotFinalStaticOrGlobalProblem(functionNode, function.getBaseName()));
            }
            return false;
        }
        functionNode.parseFunctionBody(new ArrayList<ICompilerProblem>());
        ScopedBlockNode functionBody = functionNode.getScopedNode();
        if (this.functionBodyHasNonInlineableNodes(functionBody, reportInlineProblems, function.getBaseName(), new AtomicInteger())) {
            functionNode.discardFunctionBody();
            return false;
        }
        return true;
    }

    public boolean functionBodyHasNonInlineableNodes(IASNode n, boolean reportInlineProblems, String functionName, AtomicInteger exprCount) {
        if (n == null) {
            return false;
        }
        if (n instanceof ExpressionNodeBase) {
            exprCount.getAndIncrement();
            if (exprCount.get() > 50) {
                if (reportInlineProblems) {
                    this.currentScope.addProblem(new InlineFunctionTooLargeProblem(functionName, exprCount.get(), 50));
                }
                return true;
            }
        }
        switch (n.getNodeID()) {
            case AnonymousFunctionID: 
            case CatchID: 
            case FinallyID: 
            case FunctionID: 
            case FunctionObjectID: 
            case TryID: 
            case WithID: {
                if (reportInlineProblems) {
                    this.currentScope.addProblem(new InlineUnsupportedNodeProblem(n, functionName));
                }
                return true;
            }
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            if (!this.functionBodyHasNonInlineableNodes(n.getChild(i), reportInlineProblems, functionName, exprCount)) continue;
            return true;
        }
        return false;
    }

    public boolean functionBodyHasNonInlineableInstructions(InstructionList insns, boolean reportInlineProblems, String functionName) {
        if (insns.isEmpty()) {
            return true;
        }
        for (Instruction insn : insns.getInstructions()) {
            switch (insn.getOpcode()) {
                case 28: 
                case 29: 
                case 48: 
                case 64: 
                case 71: 
                case 72: 
                case 87: 
                case 88: 
                case 90: 
                case 93: 
                case 94: 
                case 96: 
                case 101: 
                case 103: {
                    if (reportInlineProblems) {
                        this.currentScope.addProblem(new InlineUnsupportedInstructionProblem(functionName));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SpecialValue {
        NONE,
        NAN,
        UNDEFINED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SuperState {
        Invalid,
        Initial,
        Armed;

    }
}

