/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.scopes.IDefinitionStore;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionStore2;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionStore8;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionStoreBase;
import org.apache.royale.compiler.scopes.IDefinitionSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmallDefinitionStore4
extends SmallDefinitionStoreBase {
    IDefinitionSet definitionSet0;
    IDefinitionSet definitionSet1;
    IDefinitionSet definitionSet2;
    IDefinitionSet definitionSet3;

    public SmallDefinitionStore4() {
    }

    public SmallDefinitionStore4(SmallDefinitionStore2 other) {
        this.definitionSet0 = other.definitionSet0;
        this.definitionSet1 = other.definitionSet1;
    }

    @Override
    public int getCapacity() {
        return 4;
    }

    @Override
    public IDefinitionStore createLargerStore() {
        return new SmallDefinitionStore8(this);
    }

    @Override
    public IDefinitionSet getDefinitionSetByName(String baseName) {
        assert (baseName != null) : "The baseName of a definition must be non-null";
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet0))) {
            return this.definitionSet0;
        }
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet1))) {
            return this.definitionSet1;
        }
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet2))) {
            return this.definitionSet2;
        }
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet3))) {
            return this.definitionSet3;
        }
        return null;
    }

    @Override
    public void putDefinitionSetByName(String baseName, IDefinitionSet set) {
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet0))) {
            this.definitionSet0 = set;
        }
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet1))) {
            this.definitionSet1 = set;
        }
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet2))) {
            this.definitionSet2 = set;
        }
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet3))) {
            this.definitionSet3 = set;
        }
    }

    @Override
    public Collection<String> getAllNames() {
        int n = this.getCapacity();
        ArrayList<String> list = new ArrayList<String>(n);
        SmallDefinitionStore4.addBaseNameToList(list, this.definitionSet0);
        SmallDefinitionStore4.addBaseNameToList(list, this.definitionSet1);
        SmallDefinitionStore4.addBaseNameToList(list, this.definitionSet2);
        SmallDefinitionStore4.addBaseNameToList(list, this.definitionSet3);
        return list;
    }

    @Override
    public Collection<IDefinitionSet> getAllDefinitionSets() {
        int n = this.getCapacity();
        ArrayList<IDefinitionSet> list = new ArrayList<IDefinitionSet>(n);
        SmallDefinitionStore4.addDefinitionSetToList(list, this.definitionSet0);
        SmallDefinitionStore4.addDefinitionSetToList(list, this.definitionSet1);
        SmallDefinitionStore4.addDefinitionSetToList(list, this.definitionSet2);
        SmallDefinitionStore4.addDefinitionSetToList(list, this.definitionSet3);
        return list;
    }

    @Override
    public Collection<IDefinition> getAllDefinitions() {
        int n = this.getCapacity();
        ArrayList<IDefinition> list = new ArrayList<IDefinition>(n);
        SmallDefinitionStore4.addDefinitionsToList(list, this.definitionSet0);
        SmallDefinitionStore4.addDefinitionsToList(list, this.definitionSet1);
        SmallDefinitionStore4.addDefinitionsToList(list, this.definitionSet2);
        SmallDefinitionStore4.addDefinitionsToList(list, this.definitionSet3);
        return list;
    }

    @Override
    protected int findIndexForBaseName(String baseName) {
        assert (baseName != null) : "The baseName of a definition must be non-null";
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet0))) {
            return 0;
        }
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet1))) {
            return 1;
        }
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet2))) {
            return 2;
        }
        if (baseName.equals(SmallDefinitionStore4.getBaseName(this.definitionSet3))) {
            return 3;
        }
        return -1;
    }

    @Override
    protected int findAvailableIndex() {
        if (this.definitionSet0 == null) {
            return 0;
        }
        if (this.definitionSet1 == null) {
            return 1;
        }
        if (this.definitionSet2 == null) {
            return 2;
        }
        if (this.definitionSet3 == null) {
            return 3;
        }
        return -1;
    }

    @Override
    protected IDefinitionSet getDefinitionSet(int i) {
        assert (i >= 0 && i < this.getCapacity()) : "The index must be within the capacity of the store";
        switch (i) {
            case 0: {
                return this.definitionSet0;
            }
            case 1: {
                return this.definitionSet1;
            }
            case 2: {
                return this.definitionSet2;
            }
            case 3: {
                return this.definitionSet3;
            }
        }
        return null;
    }

    @Override
    protected void setDefinitionSet(int i, IDefinitionSet definitionSet) {
        assert (i >= 0 && i < this.getCapacity()) : "The index must be within the capacity of the store";
        switch (i) {
            case 0: {
                this.definitionSet0 = definitionSet;
                break;
            }
            case 1: {
                this.definitionSet1 = definitionSet;
                break;
            }
            case 2: {
                this.definitionSet2 = definitionSet;
                break;
            }
            case 3: {
                this.definitionSet3 = definitionSet;
            }
        }
    }
}

