/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.CDATANode;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.internal.fxg.dom.GraphicContentNode;
import org.apache.royale.compiler.internal.fxg.dom.ITextNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TextHelper;
import org.apache.royale.compiler.internal.fxg.dom.text.AbstractCharacterTextNode;
import org.apache.royale.compiler.internal.fxg.dom.text.BRNode;
import org.apache.royale.compiler.internal.fxg.dom.text.ParagraphNode;
import org.apache.royale.compiler.internal.fxg.dom.text.SpanNode;
import org.apache.royale.compiler.internal.fxg.dom.types.Kerning;
import org.apache.royale.compiler.internal.fxg.dom.types.LineBreak;
import org.apache.royale.compiler.internal.fxg.dom.types.WhiteSpaceCollapse;
import org.apache.royale.compiler.problems.FXGContentNotContiguousProblem;
import org.apache.royale.compiler.problems.FXGInvalidNodeAttributeProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextGraphicNode
extends GraphicContentNode
implements ITextNode {
    public double width = 0.0;
    public double height = 0.0;
    public double paddingLeft = 0.0;
    public double paddingRight = 0.0;
    public double paddingBottom = 0.0;
    public double paddingTop = 0.0;
    public String fontFamily = "Times New Roman";
    public double fontSize = 12.0;
    public String fontStyle = "normal";
    public String fontWeight = "normal";
    public double lineHeight = 120.0;
    public String textDecoration = "none";
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.PRESERVE;
    public LineBreak lineBreak = LineBreak.TOFIT;
    public boolean lineThrough = false;
    public double tracking = 0.0;
    public Kerning kerning = Kerning.AUTO;
    public double textAlpha = 1.0;
    public int color = -16777216;
    public String textAlign = "left";
    public String textAlignLast = "left";
    public double textIndent = 0.0;
    public double marginLeft = 0.0;
    public double marginRight = 0.0;
    public double marginTop = 0.0;
    public double marginBottom = 0.0;
    public String direction = "ltr";
    public String blockProgression = "tb";
    private boolean contiguous = false;
    protected Map<String, String> textAttributes;
    protected List<ITextNode> content;

    @Override
    public Map<String, String> getTextAttributes() {
        return this.textAttributes;
    }

    @Override
    public List<ITextNode> getTextChildren() {
        return this.content;
    }

    public HashMap<String, ITextNode> getTextProperties() {
        return null;
    }

    @Override
    public void addTextProperty(String propertyName, ITextNode node, Collection<ICompilerProblem> problems) {
        this.addChild(node, problems);
    }

    protected void rememberAttribute(String name, String value) {
        if (this.textAttributes == null) {
            this.textAttributes = new HashMap<String, String>(4);
        }
        this.textAttributes.put(name, value);
    }

    public void addContentChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof ParagraphNode || child instanceof BRNode || child instanceof SpanNode || child instanceof CDATANode) {
            if (this.content == null) {
                this.content = new ArrayList<ITextNode>();
                this.contiguous = true;
            }
            if (!this.contiguous) {
                problems.add(new FXGContentNotContiguousProblem(child.getDocumentPath(), child.getStartLine(), child.getStartColumn(), this.getNodeName()));
                return;
            }
            this.content.add((ITextNode)child);
        }
    }

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        children.addAll(super.getChildren());
        if (this.content != null) {
            children.addAll(this.content);
        }
        return children;
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof CDATANode) {
            if (TextHelper.ignorableWhitespace(((CDATANode)child).content)) {
                return;
            }
            problems.add(new FXGContentNotContiguousProblem(child.getDocumentPath(), child.getStartLine(), child.getStartColumn(), this.getNodeName()));
            return;
        }
        super.addChild(child, problems);
        this.contiguous = false;
    }

    @Override
    public String getNodeName() {
        return "TextGraphic";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name, this.width, problems);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name, this.height, problems);
        } else if ("paddingLeft".equals(name)) {
            this.paddingLeft = DOMParserHelper.parseDouble(this, value, name, this.paddingLeft, problems);
        } else if ("paddingRight".equals(name)) {
            this.paddingRight = DOMParserHelper.parseDouble(this, value, name, this.paddingRight, problems);
        } else if ("paddingBottom".equals(name)) {
            this.paddingBottom = DOMParserHelper.parseDouble(this, value, name, this.paddingBottom, problems);
        } else if ("paddingTop".equals(name)) {
            this.paddingTop = DOMParserHelper.parseDouble(this, value, name, this.paddingTop, problems);
        } else if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = DOMParserHelper.parseDouble(this, value, name, this.fontSize, problems);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = value;
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = value;
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = DOMParserHelper.parsePercent(this, value, name, this.lineHeight, problems);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = value;
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = AbstractCharacterTextNode.getWhiteSpaceCollapse(this, value, problems);
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = AbstractCharacterTextNode.getLineBreak(this, value, problems);
        } else if ("tracking".equals(name)) {
            this.tracking = DOMParserHelper.parsePercent(this, value, name, this.tracking, problems);
        } else if ("kerning".equals(name)) {
            this.kerning = AbstractCharacterTextNode.getKerning(this, value, problems);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.textAlpha, problems);
        } else if ("color".equals(name)) {
            this.color = DOMParserHelper.parseRGB(this, value, name, this.color, problems);
        } else if ("textAlign".equals(name)) {
            this.textAlign = value;
        } else if ("textAlignLast".equals(name)) {
            this.textAlignLast = value;
        } else if ("textIndent".equals(name)) {
            this.textIndent = DOMParserHelper.parseDouble(this, value, name, this.textIndent, problems);
        } else if ("marginLeft".equals(name)) {
            this.marginLeft = DOMParserHelper.parseDouble(this, value, name, this.marginLeft, problems);
        } else if ("marginRight".equals(name)) {
            this.marginRight = DOMParserHelper.parseDouble(this, value, name, this.marginRight, problems);
        } else if ("marginTop".equals(name)) {
            this.marginTop = DOMParserHelper.parseDouble(this, value, name, this.marginTop, problems);
        } else if ("marginBottom".equals(name)) {
            this.marginBottom = DOMParserHelper.parseDouble(this, value, name, this.marginBottom, problems);
        } else if ("direction".equals(name)) {
            this.direction = value;
        } else if ("blockProgression".equals(name)) {
            this.blockProgression = value;
        } else if ("x".equals(name)) {
            this.x = DOMParserHelper.parseDouble(this, value, name, this.x, problems);
            this.translateSet = true;
        } else if ("y".equals(name)) {
            this.y = DOMParserHelper.parseDouble(this, value, name, this.y, problems);
            this.translateSet = true;
        } else if ("rotation".equals(name)) {
            this.rotation = DOMParserHelper.parseDouble(this, value, name, this.rotation, problems);
            this.rotationSet = true;
        } else if ("scaleX".equals(name)) {
            this.scaleX = DOMParserHelper.parseDouble(this, value, name, this.scaleX, problems);
            this.scaleSet = true;
        } else if ("scaleY".equals(name)) {
            this.scaleY = DOMParserHelper.parseDouble(this, value, name, this.scaleY, problems);
            this.scaleSet = true;
        } else if ("alpha".equals(name)) {
            this.alpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.alpha, problems);
            this.alphaSet = true;
        } else if ("blendMode".equals(name)) {
            this.blendMode = this.parseBlendMode(value, this.blendMode, problems);
        } else if ("maskType".equals(name)) {
            this.maskType = DOMParserHelper.parseMaskType(this, value, this.maskType, problems);
            this.maskTypeSet = true;
        } else if ("visible".equals(name)) {
            this.visible = DOMParserHelper.parseBoolean(this, value, name, this.visible, problems);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = DOMParserHelper.parseBoolean(this, value, name, this.lineThrough, problems);
        } else if (!"id".equals(name)) {
            problems.add(new FXGInvalidNodeAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), name, this.getNodeName()));
            return;
        }
        this.rememberAttribute(name, value);
    }
}

