/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom;

import java.util.Collection;
import java.util.List;
import org.apache.royale.compiler.internal.fxg.dom.AbstractShapeNode;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.swf.types.LineStyle;
import org.apache.royale.swf.types.Rect;
import org.apache.royale.swf.types.ShapeRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipseNode
extends AbstractShapeNode {
    public double width = 0.0;
    public double height = 0.0;

    @Override
    public String getNodeName() {
        return "Ellipse";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name, this.width, problems);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name, this.height, problems);
        } else {
            super.setAttribute(name, value, problems);
        }
    }

    @Override
    public Rect getBounds(List<ShapeRecord> records, LineStyle ls) {
        int x1 = 0;
        int y1 = 0;
        int x2 = (int)(this.width * 20.0);
        int y2 = (int)(this.height * 20.0);
        if (ls != null) {
            int width = 20;
            if (width < ls.getWidth()) {
                width = ls.getWidth();
            }
            int stroke = (int)Math.rint((double)width / 2.0);
            x1 -= stroke;
            y1 -= stroke;
            x2 += stroke;
            y2 += stroke;
        }
        return new Rect(x1, x2, y1, y2);
    }
}

