/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.filespecs;

import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.utils.FilenameNormalization;

public class StringFileSpecification
implements IFileSpecification {
    private final String content;
    private final String name;
    private final long lastModified;

    public StringFileSpecification(String name, String content) {
        this(name, content, 0L);
    }

    public StringFileSpecification(String name, String content, long lastModified) {
        this.name = FilenameNormalization.normalize(name);
        this.content = content;
        this.lastModified = lastModified;
    }

    public StringFileSpecification(String content) {
        this("", content, 0L);
    }

    public String getPath() {
        return this.name;
    }

    public Reader createReader() throws FileNotFoundException {
        return new StringReader(this.content);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isOpenDocument() {
        return false;
    }
}

