/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IGetterDefinition;
import org.apache.royale.compiler.definitions.IInterfaceDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.IScopedDefinition;
import org.apache.royale.compiler.definitions.ISetterDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinitionBase;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.ParameterDefinition;
import org.apache.royale.compiler.internal.definitions.ScopedDefinitionBase;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.problems.ConflictingDefinitionProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionDefinition
extends ScopedDefinitionBase
implements IFunctionDefinition {
    private static final ParameterDefinition[] NO_PARAMETERS = new ParameterDefinition[0];
    private ParameterDefinition[] parameters = NO_PARAMETERS;
    private IReference returnTypeReference;
    private boolean copiedMetaData = false;

    public FunctionDefinition(String name) {
        super(name);
    }

    @Override
    public void setNode(IDefinitionNode node) {
        IFunctionNode functionNode;
        super.setNode(node);
        if (this.getNameStart() == -1 && node instanceof IFunctionNode && (functionNode = (IFunctionNode)node).getFunctionClassification() == IFunctionDefinition.FunctionClassification.LOCAL) {
            IContainerNode parametersNode = functionNode.getParametersContainerNode();
            int synthesizedNameOffset = parametersNode.getStart();
            if (synthesizedNameOffset > 0) {
                --synthesizedNameOffset;
            }
            this.setNameLocation(synthesizedNameOffset, synthesizedNameOffset);
        }
    }

    @Override
    public IFunctionDefinition.FunctionClassification getFunctionClassification() {
        IDefinition parent = this.getParent();
        if (parent instanceof IFunctionDefinition) {
            return IFunctionDefinition.FunctionClassification.LOCAL;
        }
        if (parent instanceof IClassDefinition) {
            return IFunctionDefinition.FunctionClassification.CLASS_MEMBER;
        }
        if (parent instanceof IInterfaceDefinition) {
            return IFunctionDefinition.FunctionClassification.INTERFACE_MEMBER;
        }
        if (parent instanceof IPackageDefinition) {
            return IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER;
        }
        if (parent == null) {
            if (this.inPackageNamespace()) {
                return IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER;
            }
            return IFunctionDefinition.FunctionClassification.FILE_MEMBER;
        }
        assert (false);
        return null;
    }

    public ParameterDefinition[] getParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasRequiredParameters() {
        for (ParameterDefinition parameter : this.parameters) {
            if (parameter.hasDefaultValue() || parameter.isRest()) continue;
            return true;
        }
        return false;
    }

    public void setParameters(ParameterDefinition[] value) {
        assert (value != null) : "setParameters() wants an empty array, not null";
        for (ParameterDefinition p : this.parameters = value) {
            p.setContainingScope(this.getContainedScope());
        }
    }

    @Override
    public String getReturnTypeAsDisplayString() {
        return this.returnTypeReference != null ? this.returnTypeReference.getDisplayString() : "";
    }

    public void setReturnTypeReference(IReference returnTypeReference) {
        this.returnTypeReference = returnTypeReference;
    }

    @Override
    public IReference getReturnTypeReference() {
        return this.returnTypeReference;
    }

    @Override
    public ITypeDefinition resolveReturnType(ICompilerProject project) {
        if (this.isConstructor()) {
            IDefinition typeDef = this.getParent();
            if (typeDef instanceof ITypeDefinition) {
                return (ITypeDefinition)typeDef;
            }
            return null;
        }
        DependencyType dt = DependencyType.SIGNATURE;
        return this.resolveType(this.returnTypeReference, project, dt);
    }

    @Override
    public boolean isConstructor() {
        return (this.flags & 2) != 0;
    }

    public void setAsConstructor(ClassDefinition classDef) {
        this.flags = (short)(this.flags | 2);
        classDef.setConstructor(this);
    }

    @Override
    public boolean isCastFunction() {
        return (this.flags & 1) != 0;
    }

    public void setCastFunction() {
        this.flags = (short)(this.flags | 1);
    }

    @Override
    public boolean inlineFunction() {
        if (!this.isInline()) {
            return false;
        }
        return this.canFunctionBeInlined();
    }

    @Override
    public final boolean isInline() {
        IMetaTag inlineMetaData = this.getMetaTagByName("Inline");
        return inlineMetaData != null;
    }

    protected final boolean canFunctionBeInlined() {
        if (!(this.isFinal() || this.isStatic() || this.isTopLevelDefinition())) {
            return false;
        }
        IScopedDefinition containingDef = this.getContainingScope().getDefinition();
        return !(containingDef instanceof InterfaceDefinition);
    }

    @Override
    public boolean overridesAncestor(ICompilerProject project) {
        return this.resolveOverriddenFunction(project) != null;
    }

    @Override
    public FunctionDefinition resolveOverriddenFunction(ICompilerProject project) {
        if (this.getFunctionClassification() != IFunctionDefinition.FunctionClassification.CLASS_MEMBER) {
            return null;
        }
        ClassDefinition cls = (ClassDefinition)this.getParent();
        ClassDefinition base = (ClassDefinition)cls.resolveBaseClass(project);
        if (base != null) {
            IDefinition baseFunc;
            INamespaceDefinition namespace = this.resolveNamespace(project);
            if (namespace == null) {
                return null;
            }
            INamespaceDefinition protectedNS = cls.getProtectedNamespaceReference().resolveNamespaceReference(project);
            if (namespace.equals(protectedNS)) {
                namespace = base.getProtectedNamespaceReference().resolveNamespaceReference(project);
            }
            if ((baseFunc = base.getContainedScope().getQualifiedPropertyFromDef(project, (IDefinition)base, this.getBaseName(), namespace, false)) instanceof FunctionDefinition) {
                return (FunctionDefinition)baseFunc;
            }
            IDefinition anyDef = base.getContainedScope().getPropertyFromDef(project, (IDefinition)base, this.getBaseName(), new PrivatePredicate(!project.getAllowPrivateNameConflicts()), false);
            if (anyDef != null) {
                project.getProblems().add(new ConflictingDefinitionProblem(this.getFunctionNode(), this.getBaseName(), anyDef.getParent().getQualifiedName()));
            }
        }
        return null;
    }

    @Override
    public boolean isImplementation(ICompilerProject project) {
        return this.resolveImplementedFunction(project) != null;
    }

    public List<IFunctionDefinition> resolveOverridenInterfaceFunctions(ICompilerProject project) {
        if (this.getFunctionClassification() != IFunctionDefinition.FunctionClassification.INTERFACE_MEMBER) {
            return Collections.emptyList();
        }
        InterfaceDefinition interf = (InterfaceDefinition)this.getParent();
        List<IDefinition> funcs = this.getContainingASScope().getPropertiesByNameForMemberAccess((CompilerProject)project, this.getBaseName(), interf.getInterfaceNamespaceSet(project, InterfaceDefinition.InterfaceNamespaceSetOptions.DONT_INCLUDE_THIS));
        if (funcs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IFunctionDefinition> conflicts = new ArrayList<IFunctionDefinition>(funcs.size());
        for (IDefinition d : funcs) {
            if (!(d instanceof IFunctionDefinition)) continue;
            conflicts.add((IFunctionDefinition)d);
        }
        return conflicts;
    }

    @Override
    public IFunctionDefinition resolveImplementedFunction(ICompilerProject project) {
        if (this.getFunctionClassification() != IFunctionDefinition.FunctionClassification.CLASS_MEMBER) {
            return null;
        }
        ClassDefinitionBase cls = (ClassDefinitionBase)this.getParent();
        Iterator<IInterfaceDefinition> iter = cls.interfaceIterator(project);
        while (iter.hasNext()) {
            IInterfaceDefinition intf = iter.next();
            FunctionDefinition f = this.findMatchingMethod(intf, project);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    private FunctionDefinition findMatchingMethod(ITypeDefinition type, ICompilerProject project) {
        String baseName = this.getBaseName();
        boolean isInterface = type instanceof IInterfaceDefinition;
        IASScope typeScope = type.getContainedScope();
        IDefinitionSet definitionSet = typeScope.getLocalDefinitionSetByName(baseName);
        int n = definitionSet != null ? definitionSet.getSize() : 0;
        for (int i = 0; i < n; ++i) {
            FunctionDefinition f;
            IDefinition member = definitionSet.getDefinition(i);
            if (!(member instanceof FunctionDefinition) || !this.hasSameNameAndSignature(f = (FunctionDefinition)member, isInterface, project)) continue;
            return f;
        }
        return null;
    }

    private boolean hasSameNameAndSignature(IFunctionDefinition other, boolean otherIsInterface, ICompilerProject project) {
        String name2;
        String name1 = this.getBaseName();
        if (!name1.equals(name2 = other.getBaseName())) {
            return false;
        }
        if (!otherIsInterface) {
            INamespaceReference nsRef2;
            INamespaceReference nsRef1 = this.getNamespaceReference();
            if (!nsRef1.equals(nsRef2 = other.getNamespaceReference())) {
                return false;
            }
        } else {
            assert (this.getFunctionClassification() == IFunctionDefinition.FunctionClassification.CLASS_MEMBER);
            if (!NamespaceDefinition.getPublicNamespaceDefinition().equals(this.getNamespaceReference())) {
                return false;
            }
        }
        return this.hasCompatibleSignature(other, project);
    }

    public boolean hasCompatibleSignature(IFunctionDefinition other, ICompilerProject project) {
        int n2;
        ITypeDefinition returnType2;
        ITypeDefinition returnType1;
        if (!this.copiedMetaData && other.isImplementation(project)) {
            IMetaTag tag;
            this.copiedMetaData = true;
            IMetaTag myTag = this.getMetaTagByName("SWFOverride");
            if (myTag == null && (tag = other.getMetaTagByName("SWFOverride")) != null) {
                this.addMetaTag(tag);
            }
        }
        if (!project.isCompatibleOverrideReturnType(this, returnType1 = this.resolveReturnType(project), returnType2 = other.resolveReturnType(project))) {
            return false;
        }
        ParameterDefinition[] params1 = this.getParameters();
        IParameterDefinition[] params2 = other.getParameters();
        int n1 = params1 != null ? params1.length : 0;
        int n = n2 = params2 != null ? params2.length : 0;
        if (n1 != n2) {
            return false;
        }
        for (int i = 0; i < n1; ++i) {
            boolean hasDefault2;
            boolean rest2;
            ITypeDefinition type2;
            ParameterDefinition param1 = params1[i];
            IParameterDefinition param2 = params2[i];
            ITypeDefinition type1 = param1.resolveType(project);
            if (type1 != (type2 = param2.resolveType(project)) && !project.isCompatibleOverrideParameterType(this, type1, type2, i)) {
                return false;
            }
            boolean rest1 = param1.isRest();
            if (rest1 != (rest2 = param2.isRest())) {
                return false;
            }
            boolean hasDefault1 = param1.hasDefaultValue();
            if (hasDefault1 == (hasDefault2 = param2.hasDefaultValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public IFunctionNode getFunctionNode() {
        IDefinitionNode node = this.getNode();
        if (node instanceof IFunctionNode) {
            return (IFunctionNode)node;
        }
        return null;
    }

    @Override
    public boolean isTopLevelDefinition() {
        if (this.isConstructor()) {
            return ((DefinitionBase)this.getParent()).isTopLevelDefinition();
        }
        return super.isTopLevelDefinition();
    }

    @Override
    public boolean matches(DefinitionBase definition) {
        boolean match = super.matches(definition);
        if (!match) {
            return false;
        }
        IFunctionDefinition functionDefinition = (IFunctionDefinition)((Object)definition);
        IFunctionDefinition.FunctionClassification classification = functionDefinition.getFunctionClassification();
        if (classification != this.getFunctionClassification()) {
            return false;
        }
        if (!(classification != IFunctionDefinition.FunctionClassification.LOCAL && classification != IFunctionDefinition.FunctionClassification.FILE_MEMBER && classification != IFunctionDefinition.FunctionClassification.CLASS_MEMBER && classification != IFunctionDefinition.FunctionClassification.INTERFACE_MEMBER || functionDefinition.getNameStart() == this.getNameStart() && functionDefinition.getNameEnd() == functionDefinition.getNameEnd())) {
            return false;
        }
        if (functionDefinition instanceof ISetterDefinition && !(this instanceof ISetterDefinition)) {
            return false;
        }
        if (functionDefinition instanceof IGetterDefinition && !(this instanceof IGetterDefinition)) {
            return false;
        }
        if (functionDefinition.isConstructor() && !this.isConstructor()) {
            return false;
        }
        return functionDefinition.getParameters().length == this.getParameters().length;
    }

    @Override
    protected void buildInnerString(StringBuilder sb) {
        sb.append(this.getNamespaceReferenceAsString());
        sb.append(' ');
        if (this.isStatic()) {
            sb.append("static");
            sb.append(' ');
        }
        sb.append("function");
        sb.append(' ');
        sb.append(this.getBaseName());
        sb.append('(');
        ParameterDefinition[] params = this.getParameters();
        int n = params != null ? params.length : 0;
        for (int i = 0; i < n; ++i) {
            sb.append(((Object)params[i]).toString());
            if (i >= n - 1) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append(')');
        String returnType = this.getReturnTypeAsDisplayString();
        if (!returnType.isEmpty()) {
            sb.append(':');
            sb.append(returnType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivatePredicate
    implements Predicate<IDefinition> {
        private boolean findPrivates;

        public PrivatePredicate(boolean b) {
            this.findPrivates = b;
        }

        public boolean apply(IDefinition definition) {
            if (!definition.isPrivate()) {
                return true;
            }
            return this.findPrivates;
        }
    }
}

