/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import java.util.StringTokenizer;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSPropertyValue;

public class CSSRgbaColorPropertyValue
extends CSSPropertyValue {
    private final Token token;
    private final long colorInt;
    private final String rawRgb;

    protected CSSRgbaColorPropertyValue(String rawRgb, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.PROPERTY_VALUE);
        this.token = tree.token;
        this.rawRgb = rawRgb;
        this.colorInt = CSSRgbaColorPropertyValue.getIntValue(this.rawRgb);
    }

    protected static long getIntValue(String rgb) {
        rgb = rgb.substring(5, rgb.length() - 1);
        StringTokenizer st = new StringTokenizer(rgb, ",");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreElements()) {
            int digit;
            String t = (String)st.nextElement();
            if ((t = t.trim()).contains("%")) {
                t = t.replaceAll("%", "");
                digit = Float.valueOf(t).intValue() * 255 / 100;
                sb.append(Character.forDigit(digit >> 4 & 0xF, 16));
                sb.append(Character.forDigit(digit & 0xF, 16));
                continue;
            }
            if (st.hasMoreElements()) {
                digit = Float.valueOf(t).intValue();
                sb.append(Character.forDigit(digit >> 4 & 0xF, 16));
                sb.append(Character.forDigit(digit & 0xF, 16));
                continue;
            }
            Float alpha = Float.valueOf(t);
            alpha = Float.valueOf(alpha.floatValue() * 255.0f);
            digit = alpha.intValue();
            sb.insert(0, Character.forDigit(digit >> 4 & 0xF, 16));
            sb.insert(1, Character.forDigit(digit & 0xF, 16));
        }
        return Long.parseLong(sb.substring(0, 8), 16);
    }

    public long getColorAsLong() {
        return this.colorInt;
    }

    public String getRawRgb() {
        return this.rawRgb;
    }

    public String toString() {
        return this.token.getText();
    }
}

