/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.caches;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.caches.CacheStoreKeyBase;
import org.apache.royale.compiler.internal.caches.ConcurrentCacheStoreBase;
import org.apache.royale.compiler.internal.mxml.MXMLData;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXMLDataCache
extends ConcurrentCacheStoreBase<MXMLData> {
    public static MXMLDataCacheKey createKey(IFileSpecification fileSpec) {
        return new MXMLDataCacheKey(fileSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MXMLData createEntryValue(CacheStoreKeyBase key) {
        MXMLData mXMLData;
        IFileSpecification fileSpec = ((MXMLDataCacheKey)key).fileSpec;
        MXMLTokenizer tokenizer = new MXMLTokenizer(fileSpec);
        try {
            List<MXMLToken> tokens = tokenizer.parseTokens(fileSpec.createReader());
            MXMLData mxmlData = new MXMLData(tokens, tokenizer.getPrefixMap(), fileSpec);
            if (tokenizer.hasTokenizationProblems()) {
                mxmlData.getProblems().addAll(tokenizer.getTokenizationProblems());
            }
            mXMLData = mxmlData;
            Object var8_9 = null;
        }
        catch (FileNotFoundException e) {
            MXMLData mXMLData2;
            try {
                e.printStackTrace();
                mXMLData2 = null;
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                IOUtils.closeQuietly((Closeable)tokenizer);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)tokenizer);
            return mXMLData2;
        }
        IOUtils.closeQuietly((Closeable)tokenizer);
        return mXMLData;
    }

    private static class MXMLDataCacheKey
    extends CacheStoreKeyBase {
        private IFileSpecification fileSpec;

        public MXMLDataCacheKey(IFileSpecification fileSpec) {
            assert (fileSpec != null);
            this.fileSpec = fileSpec;
        }

        public String generateKey() {
            return String.valueOf(this.fileSpec.isOpenDocument()) + ":" + this.fileSpec.getPath();
        }
    }
}

