/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.jx.BinaryOperatorEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.GetterNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceAccessExpressionNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.utils.ASNodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberAccessEmitter
extends JSSubEmitter
implements ISubEmitter<IMemberAccessExpressionNode> {
    public MemberAccessEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IMemberAccessExpressionNode node) {
        IASNode parentNode;
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        IExpressionNode leftNode = node.getLeftOperandNode();
        IExpressionNode rightNode = node.getRightOperandNode();
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        if (fjs.isDateProperty((IExpressionNode)node, false)) {
            this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
            String rightName = ((IIdentifierNode)rightNode).getName();
            BinaryOperatorEmitter.DatePropertiesGetters propGetter = BinaryOperatorEmitter.DatePropertiesGetters.valueOf(rightName.toUpperCase());
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(propGetter.getFunctionName());
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            return;
        }
        IDefinition def = node.resolve(this.getProject());
        if (def == null) {
            IASNode parentNode2 = node.getParent();
            boolean isXML = false;
            boolean isProxy = false;
            if (leftNode instanceof MemberAccessExpressionNode) {
                isXML = fjs.isLeftNodeXMLish((IExpressionNode)((MemberAccessExpressionNode)leftNode));
            } else if (leftNode instanceof IExpressionNode) {
                isXML = fjs.isXML(leftNode);
            }
            if (leftNode instanceof MemberAccessExpressionNode) {
                isProxy = fjs.isProxy((IExpressionNode)((MemberAccessExpressionNode)leftNode));
            } else if (leftNode instanceof IExpressionNode) {
                isProxy = fjs.isProxy(leftNode);
            }
            if (isXML) {
                boolean child;
                boolean descendant = node.getOperator() == IOperatorNode.OperatorType.DESCENDANT_ACCESS;
                boolean bl = child = node.getOperator() == IOperatorNode.OperatorType.MEMBER_ACCESS && !(parentNode2 instanceof FunctionCallNode) && rightNode.getNodeID() != ASTNodeID.Op_AtID && (rightNode.getNodeID() != ASTNodeID.ArrayIndexExpressionID || ((DynamicAccessNode)rightNode).getLeftOperandNode().getNodeID() != ASTNodeID.Op_AtID);
                if (descendant || child) {
                    String s;
                    int dot;
                    this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                    if (descendant) {
                        this.write(".descendants('");
                    }
                    if (child) {
                        this.write(".child('");
                    }
                    if ((dot = (s = fjs.stringifyNode((IASNode)rightNode)).indexOf(46)) != -1) {
                        String name = s.substring(0, dot);
                        String afterDot = s.substring(dot);
                        this.write(name);
                        this.write("')");
                        this.write(afterDot);
                    } else {
                        this.write(s);
                        this.write("')");
                    }
                    return;
                }
            } else if (isProxy) {
                boolean child;
                boolean bl = child = node.getOperator() == IOperatorNode.OperatorType.MEMBER_ACCESS && !(parentNode2 instanceof FunctionCallNode) && rightNode.getNodeID() != ASTNodeID.Op_AtID;
                if (child) {
                    String s;
                    int dot;
                    this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                    if (child) {
                        this.write(".getProperty('");
                    }
                    if ((dot = (s = fjs.stringifyNode((IASNode)rightNode)).indexOf(46)) != -1) {
                        String name = s.substring(0, dot);
                        String afterDot = s.substring(dot);
                        this.write(name);
                        this.write("')");
                        this.write(afterDot);
                    } else {
                        this.write(s);
                        this.write("')");
                    }
                    return;
                }
            } else if (rightNode instanceof NamespaceAccessExpressionNode) {
                NamespaceAccessExpressionNode naen = (NamespaceAccessExpressionNode)rightNode;
                IDefinition d = naen.getLeftOperandNode().resolve(this.getProject());
                IdentifierNode r = (IdentifierNode)naen.getRightOperandNode();
                this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                this.write(ASEmitterTokens.SQUARE_OPEN);
                this.write(ASEmitterTokens.NEW);
                this.write(ASEmitterTokens.SPACE);
                this.write("QName");
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(fjs.formatQualifiedName(d.getQualifiedName()));
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(r.getName());
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.write(ASEmitterTokens.SQUARE_CLOSE);
                return;
            }
        } else if (def.getParent() != null && def.getParent().getQualifiedName().equals("Array")) {
            if (def.getBaseName().equals("removeAt")) {
                this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                this.write(".splice");
                return;
            }
            if (def.getBaseName().equals("insertAt")) {
                this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                this.write(".splice");
                return;
            }
        } else if (rightNode instanceof NamespaceAccessExpressionNode) {
            NamespaceAccessExpressionNode naen = (NamespaceAccessExpressionNode)rightNode;
            IDefinition d = naen.getLeftOperandNode().resolve(this.getProject());
            IdentifierNode r = (IdentifierNode)naen.getRightOperandNode();
            this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
            if (!d.getBaseName().equals(ASEmitterTokens.PRIVATE.getToken())) {
                this.write(ASEmitterTokens.SQUARE_OPEN);
                this.write(ASEmitterTokens.NEW);
                this.write(ASEmitterTokens.SPACE);
                this.write("QName");
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(fjs.formatQualifiedName(d.getQualifiedName()));
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(r.getName());
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.write(ASEmitterTokens.SQUARE_CLOSE);
            } else {
                this.write(node.getOperator().getOperatorText());
                this.write(r.getName());
            }
            return;
        }
        boolean isCustomNamespace = false;
        if (def instanceof FunctionDefinition && node.getOperator() == IOperatorNode.OperatorType.MEMBER_ACCESS) {
            isCustomNamespace = fjs.isCustomNamespace((FunctionDefinition)def);
        }
        boolean isStatic = false;
        if (def != null && def.isStatic()) {
            isStatic = true;
        }
        boolean needClosure = false;
        if (def instanceof FunctionDefinition && !(def instanceof AccessorDefinition) && !def.getBaseName().equals("constructor") && (parentNode = node.getParent()) != null) {
            ASTNodeID parentNodeId = parentNode.getNodeID();
            needClosure = !isStatic && parentNodeId != ASTNodeID.FunctionCallID && parentNodeId != ASTNodeID.MemberAccessExpressionID && parentNodeId != ASTNodeID.ArrayIndexExpressionID;
        }
        boolean continueWalk = true;
        if (!isStatic) {
            if (needClosure) {
                this.getEmitter().emitClosureStart();
            }
            continueWalk = this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
        }
        if (continueWalk) {
            IIdentifierNode identifierNode;
            boolean emitDynamicAccess = false;
            boolean dynamicAccessUnknownMembers = false;
            ICompilerProject project = this.getProject();
            if (project instanceof RoyaleJSProject) {
                RoyaleJSProject fjsProject = (RoyaleJSProject)project;
                if (fjsProject.config != null) {
                    dynamicAccessUnknownMembers = fjsProject.config.getJsDynamicAccessUnknownMembers();
                }
            }
            if (dynamicAccessUnknownMembers && rightNode instanceof IIdentifierNode) {
                identifierNode = (IIdentifierNode)node.getRightOperandNode();
                IDefinition resolvedDefinition = identifierNode.resolve(this.getProject());
                boolean bl = emitDynamicAccess = resolvedDefinition == null;
            }
            if (emitDynamicAccess) {
                identifierNode = (IIdentifierNode)node.getRightOperandNode();
                this.startMapping((ISourceLocation)node, (ISourceLocation)rightNode);
                this.write(ASEmitterTokens.SQUARE_OPEN);
                this.write(ASEmitterTokens.DOUBLE_QUOTE);
                this.write(identifierNode.getName());
                this.write(ASEmitterTokens.DOUBLE_QUOTE);
                this.write(ASEmitterTokens.SQUARE_CLOSE);
                this.endMapping((ISourceLocation)node);
            } else {
                if (!isStatic && !isCustomNamespace) {
                    this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
                    this.write(node.getOperator().getOperatorText());
                    this.endMapping((ISourceLocation)node);
                }
                this.getWalker().walk((IASNode)node.getRightOperandNode());
            }
        }
        if (needClosure) {
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            if (leftNode.getNodeID() == ASTNodeID.SuperID) {
                this.write(ASEmitterTokens.THIS);
            } else {
                this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
            }
            this.getEmitter().emitClosureEnd((IASNode)node, def);
        }
        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    private boolean writeLeftSide(IMemberAccessExpressionNode node, IASNode leftNode, IASNode rightNode) {
        if (!(leftNode instanceof ILanguageIdentifierNode) || ((ILanguageIdentifierNode)leftNode).getKind() != ILanguageIdentifierNode.LanguageIdentifierKind.THIS) {
            IDefinition rightDef = null;
            if (rightNode instanceof IIdentifierNode) {
                rightDef = ((IIdentifierNode)rightNode).resolve(this.getProject());
            }
            if (leftNode.getNodeID() != ASTNodeID.SuperID) {
                this.getWalker().walk((IASNode)node.getLeftOperandNode());
            } else {
                if (leftNode.getNodeID() == ASTNodeID.SuperID && (rightNode.getNodeID() == ASTNodeID.GetterID || rightDef != null && rightDef instanceof AccessorDefinition)) {
                    this.write(this.getEmitter().formatQualifiedName(this.getEmitter().getModel().getCurrentClass().getQualifiedName()));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSGoogEmitterTokens.SUPERCLASS);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSRoyaleEmitterTokens.GETTER_PREFIX);
                    if (rightDef != null) {
                        this.write(rightDef.getBaseName());
                    } else {
                        this.write(((GetterNode)rightNode).getName());
                    }
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSEmitterTokens.APPLY);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(ASEmitterTokens.THIS);
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    return false;
                }
                if (leftNode.getNodeID() == ASTNodeID.SuperID && rightDef != null && rightDef instanceof FunctionDefinition) {
                    this.write(this.getEmitter().formatQualifiedName(this.getEmitter().getModel().getCurrentClass().getQualifiedName()));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSGoogEmitterTokens.SUPERCLASS);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(rightDef.getBaseName());
                    return false;
                }
            }
        } else {
            this.startMapping((ISourceLocation)leftNode);
            this.write(ASEmitterTokens.THIS);
            this.endMapping((ISourceLocation)leftNode);
        }
        return true;
    }
}

