/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicAccessEmitter
extends JSSubEmitter
implements ISubEmitter<IDynamicAccessNode> {
    public DynamicAccessEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IDynamicAccessNode node) {
        JSRoyaleEmitter fjs;
        IExpressionNode leftOperandNode = node.getLeftOperandNode();
        this.getWalker().walk((IASNode)leftOperandNode);
        if (leftOperandNode.getNodeID() == ASTNodeID.Op_AtID) {
            return;
        }
        IExpressionNode rightOperandNode = node.getRightOperandNode();
        IJSEmitter ijs = this.getEmitter();
        JSRoyaleEmitter jSRoyaleEmitter = fjs = ijs instanceof JSRoyaleEmitter ? (JSRoyaleEmitter)ijs : null;
        if (fjs != null) {
            ITypeDefinition type;
            boolean isXML = false;
            if (leftOperandNode instanceof MemberAccessExpressionNode) {
                isXML = fjs.isLeftNodeXMLish((IExpressionNode)((MemberAccessExpressionNode)leftOperandNode));
            } else if (leftOperandNode instanceof IExpressionNode) {
                isXML = fjs.isXML(leftOperandNode);
            }
            if (isXML && (type = rightOperandNode.resolveType(this.getProject())).isInstanceOf("String", this.getProject())) {
                String field = fjs.stringifyNode((IASNode)rightOperandNode);
                if (field.startsWith("\"@")) {
                    field = field.replace("@", "");
                    this.write(".attribute(" + field + ")");
                } else {
                    this.write(".child(" + field + ")");
                }
                return;
            }
        }
        this.startMapping((ISourceLocation)node, (ISourceLocation)leftOperandNode);
        this.write(ASEmitterTokens.SQUARE_OPEN);
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk((IASNode)rightOperandNode);
        this.startMapping((ISourceLocation)node, (ISourceLocation)rightOperandNode);
        this.write(ASEmitterTokens.SQUARE_CLOSE);
        this.endMapping((ISourceLocation)node);
    }
}

