/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.amd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.internal.definitions.ClassTraitsDefinition;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.tree.as.IVariableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempTools {
    public static void fillStaticStatements(IClassNode node, List<IASNode> list, boolean excludeFields) {
        int len = node.getScopedNode().getChildCount();
        for (int i = 0; i < len; ++i) {
            IASNode child = node.getScopedNode().getChild(i);
            if (child instanceof IExpressionNode) {
                list.add(child);
                continue;
            }
            if (!(child instanceof IDefinitionNode) || excludeFields || !((IDefinitionNode)child).hasModifier(ASModifier.STATIC) || !(child instanceof IVariableNode)) continue;
            list.add(child);
        }
    }

    public static void fillInstanceMembers(IDefinitionNode[] members, List<IDefinitionNode> list) {
        for (IDefinitionNode node : members) {
            if (node instanceof IFunctionNode && ((IFunctionNode)node).isConstructor() || node.hasModifier(ASModifier.STATIC)) continue;
            list.add(node);
        }
    }

    public static void fillStaticMembers(IDefinitionNode[] members, List<IDefinitionNode> list, boolean excludeFields, boolean excludeFunctions) {
        for (IDefinitionNode node : members) {
            if (!node.hasModifier(ASModifier.STATIC)) continue;
            if (!excludeFields && node instanceof IVariableNode) {
                list.add(node);
                continue;
            }
            if (excludeFunctions || !(node instanceof IFunctionNode)) continue;
            list.add(node);
        }
    }

    public static List<IVariableDefinition> getFields(IClassDefinition definition, boolean excludePrivate) {
        ArrayList<IVariableDefinition> result = new ArrayList<IVariableDefinition>();
        Collection definitions = definition.getContainedScope().getAllLocalDefinitions();
        for (IDefinition member : definitions) {
            if (member.isImplicit() || !(member instanceof IVariableDefinition)) continue;
            IVariableDefinition vnode = (IVariableDefinition)member;
            if (!member.isStatic() && (member.isPublic() || member.isProtected())) {
                result.add(vnode);
            }
            if (excludePrivate || !member.isPrivate()) continue;
            result.add(vnode);
        }
        return result;
    }

    public static boolean isVariableAParameter(IVariableDefinition node, IParameterDefinition[] parameters) {
        for (IParameterDefinition parameter : parameters) {
            if (!node.getBaseName().equals(parameter.getBaseName())) continue;
            return true;
        }
        return false;
    }

    public static Map<Integer, IParameterNode> getDefaults(IParameterNode[] nodes) {
        HashMap<Integer, IParameterNode> result = new HashMap<Integer, IParameterNode>();
        int i = 0;
        boolean hasDefaults = false;
        for (IParameterNode node : nodes) {
            if (node.hasDefaultValue()) {
                hasDefaults = true;
                result.put(i, node);
            } else {
                result.put(i, null);
            }
            ++i;
        }
        if (!hasDefaults) {
            return null;
        }
        return result;
    }

    public static boolean injectThisArgument(FunctionCallNode node, boolean allowMembers) {
        IMemberAccessExpressionNode mnode;
        if (node.isSuperExpression() && !node.isNewExpression()) {
            return true;
        }
        ExpressionNodeBase base = node.getNameNode();
        if (base.getNodeID() == ASTNodeID.IdentifierID) {
            return false;
        }
        return allowMembers && base instanceof IMemberAccessExpressionNode && (mnode = (IMemberAccessExpressionNode)base).getLeftOperandNode().getNodeID() == ASTNodeID.SuperID;
    }

    public static String toInitialValue(IVariableDefinition field, ICompilerProject project) {
        Object value = field.resolveInitialValue(project);
        if (value != null) {
            return value.toString();
        }
        IReference reference = field.getTypeReference();
        if (reference == null) {
            return "undefined";
        }
        if (reference.getName().equals("int") || reference.getName().equals("uint") || reference.getName().equals("Number")) {
            return "0";
        }
        return "null";
    }

    public static boolean isBinding(IIdentifierNode node, ICompilerProject project) {
        IDefinition resolve = node.resolve(project);
        if (resolve != null && resolve.isPrivate() && !TempTools.isField(resolve)) {
            IVariableNode vparent;
            IExpressionNode rightSide = TempTools.getNode((IASNode)node, true, project);
            IBinaryOperatorNode parent = (IBinaryOperatorNode)node.getAncestorOfType(IBinaryOperatorNode.class);
            if (TempTools.isThisLeftOf(node)) {
                parent = (IBinaryOperatorNode)parent.getAncestorOfType(IBinaryOperatorNode.class);
            }
            if ((vparent = (IVariableNode)node.getAncestorOfType(IVariableNode.class)) != null) {
                IExpressionNode indentFromThis = TempTools.getIndentFromThis(node);
                if (vparent.getAssignedValueNode() == node || ((IBinaryOperatorNode)vparent.getAssignedValueNode()).getRightOperandNode() == indentFromThis) {
                    return true;
                }
            }
            if (rightSide == node && parent != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isField(IDefinition node) {
        return !(node instanceof IFunctionDefinition);
    }

    public static boolean isValidThis(IIdentifierNode node, ICompilerProject project) {
        IFunctionDefinition function;
        IVariableDefinition variable;
        IDefinition definition;
        if (node.getParent() instanceof IMemberAccessExpressionNode) {
            IMemberAccessExpressionNode mnode = (IMemberAccessExpressionNode)node.getParent();
            if (mnode.getLeftOperandNode().getNodeID() == ASTNodeID.SuperID) {
                return false;
            }
            IExpressionNode indentFromThis = TempTools.getIndentFromThis(node);
            if (node == indentFromThis) {
                return true;
            }
            ExpressionNodeBase enode = (ExpressionNodeBase)node;
            ExpressionNodeBase baseExpression = enode.getBaseExpression();
            if (indentFromThis == null && baseExpression != null && baseExpression != node) {
                return false;
            }
            ITypeDefinition type = mnode.getLeftOperandNode().resolveType(project);
            if (type instanceof ClassTraitsDefinition && mnode.getLeftOperandNode() == node) {
                return false;
            }
            if (indentFromThis == null) {
                // empty if block
            }
        }
        if ((definition = node.resolve(project)) == null) {
            return false;
        }
        if (definition instanceof IParameterDefinition) {
            return false;
        }
        if (definition.getParent() instanceof IMemberAccessExpressionNode) {
            return false;
        }
        if (!(definition.getParent() instanceof IClassDefinition)) {
            return false;
        }
        if (definition instanceof IVariableDefinition && (variable = (IVariableDefinition)definition).isStatic()) {
            return false;
        }
        return !(definition instanceof IFunctionDefinition) || !(function = (IFunctionDefinition)definition).isStatic();
    }

    private static boolean isThisLeftOf(IIdentifierNode node) {
        IMemberAccessExpressionNode parent;
        return node.getParent() instanceof IMemberAccessExpressionNode && (parent = (IMemberAccessExpressionNode)node.getParent()).getLeftOperandNode() instanceof ILanguageIdentifierNode && ((ILanguageIdentifierNode)parent.getLeftOperandNode()).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.THIS;
    }

    public static IExpressionNode getNode(IASNode iNode, Boolean toRight, ICompilerProject project) {
        try {
            IASNode node = iNode;
            while (node != null) {
                if (node instanceof IBinaryOperatorNode && !(node instanceof MemberAccessExpressionNode)) {
                    if (toRight.booleanValue()) {
                        node = ((IBinaryOperatorNode)node).getRightOperandNode();
                        continue;
                    }
                    node = ((IBinaryOperatorNode)node).getLeftOperandNode();
                    continue;
                }
                if (node instanceof IFunctionCallNode) {
                    node = ((IFunctionCallNode)node).getNameNode();
                    continue;
                }
                if (node instanceof IDynamicAccessNode) {
                    node = ((IDynamicAccessNode)node).getLeftOperandNode();
                    continue;
                }
                if (node instanceof IUnaryOperatorNode) {
                    node = ((IUnaryOperatorNode)node).getOperandNode();
                    continue;
                }
                if (node instanceof IForLoopNode) {
                    node = ((IForLoopNode)node).getChild(0).getChild(0);
                    continue;
                }
                if (node instanceof IVariableNode) {
                    if (toRight.booleanValue()) {
                        node = ((IVariableNode)node).getAssignedValueNode();
                        continue;
                    }
                    node = ((IVariableNode)node).getVariableTypeNode();
                    continue;
                }
                if (node instanceof IExpressionNode) {
                    return (IExpressionNode)node;
                }
                node = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static IExpressionNode getIndentFromThis(IIdentifierNode node) {
        IMemberAccessExpressionNode parent;
        if (node.getParent() instanceof IMemberAccessExpressionNode && (parent = (IMemberAccessExpressionNode)node.getParent()).getLeftOperandNode() instanceof ILanguageIdentifierNode && ((ILanguageIdentifierNode)parent.getLeftOperandNode()).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.THIS) {
            return parent.getRightOperandNode();
        }
        return null;
    }

    public static String toPackageName(String name) {
        if (!name.contains(".")) {
            return name;
        }
        String stem = name.substring(0, name.lastIndexOf("."));
        return stem;
    }

    public static String toBaseName(String name) {
        if (!name.contains(".")) {
            return name;
        }
        String basename = name.substring(name.lastIndexOf(".") + 1);
        return basename;
    }
}

