/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js;

import org.apache.royale.compiler.codegen.IDocEmitter;
import org.apache.royale.compiler.codegen.IEmitter;
import org.apache.royale.compiler.codegen.IEmitterTokens;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSDocEmitterTokens;
import org.apache.royale.compiler.tree.as.IASNode;

public class JSDocEmitter
implements IDocEmitter,
IEmitter {
    private int currentIndent = 0;
    protected IEmitter emitter;
    private StringBuilder builder;
    private boolean bufferWrite;

    protected StringBuilder getBuilder() {
        return this.builder;
    }

    public boolean isBufferWrite() {
        return this.bufferWrite;
    }

    public void setBufferWrite(boolean value) {
        this.bufferWrite = value;
    }

    public String flushBuffer() {
        this.setBufferWrite(false);
        String result = this.builder.toString();
        this.builder.setLength(0);
        return result;
    }

    public JSDocEmitter(IJSEmitter emitter) {
        this.emitter = emitter;
        this.builder = new StringBuilder();
    }

    public void indentPush() {
        ++this.currentIndent;
    }

    public void indentPop() {
        --this.currentIndent;
    }

    public void write(IEmitterTokens value) {
        this.write(value.getToken());
    }

    public void write(String value) {
        if (!this.bufferWrite) {
            this.emitter.write(value);
        } else {
            this.builder.append(value);
        }
    }

    public void writeNewline() {
        this.write(ASEmitterTokens.NEW_LINE);
    }

    public void writeNewline(String value) {
        this.write(value);
        this.writeNewline();
    }

    public void writeNewline(IEmitterTokens value) {
        this.writeNewline(value.getToken());
    }

    public void writeNewline(String value, boolean pushIndent) {
        if (pushIndent) {
            this.indentPush();
        } else {
            this.indentPop();
        }
        this.write(value);
        this.writeNewline();
    }

    public void writeNewline(IEmitterTokens value, boolean pushIndent) {
        this.writeNewline(value.getToken(), pushIndent);
    }

    public void writeToken(IEmitterTokens value) {
        this.writeToken(value.getToken());
    }

    public void writeToken(String value) {
        this.write(value);
        this.write(ASEmitterTokens.SPACE);
    }

    public void writeBlockClose() {
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    public void writeBlockOpen() {
        this.write(ASEmitterTokens.BLOCK_OPEN);
    }

    public void begin() {
        this.writeNewline(JSDocEmitterTokens.JSDOC_OPEN);
    }

    public void end() {
        this.write(ASEmitterTokens.SPACE);
        this.writeNewline(JSDocEmitterTokens.JSDOC_CLOSE);
    }

    public String stringifyNode(IASNode node) {
        return null;
    }
}

