////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package org.apache.royale.net.remoting.messages 
{
    import org.apache.royale.net.utils.IDataOutput;
    import org.apache.royale.net.utils.IExternalizable;

    [RemoteClass(alias="DSA")]
    /**
     * A special serialization wrapper for AsyncMessages. This wrapper is used to
     * enable the externalizable form of an AsyncMessage for serialization. The
     * wrapper must be applied just before the message is serialized as it does not
     * proxy any information to the wrapped message.
     * 
     * @private
     */
    public class AsyncMessageExt extends AsyncMessage implements IExternalizable
    {
        //--------------------------------------------------------------------------
        //
        // Constructor
        // 
        //--------------------------------------------------------------------------

        public function AsyncMessageExt(message:AsyncMessage=null)
        {
            super();
            _message = message;
        }

        override public function writeExternal(output:IDataOutput):void
        {
            if (_message != null)
                _message.writeExternal(output);
            else
                super.writeExternal(output);
        }

        /**
         *  The unique id for the message.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion BlazeDS 4
         *  @productversion LCDS 3 
         */
        override public function get messageId():String
        {
            /* If we are wrapping another message, use its messageId */
            if (_message != null)
                return _message.messageId;

            return super.messageId;
        }

        private var _message:AsyncMessage;
    }

}
