/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.filespecs.IBinaryFileSpecification;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.abc.ABCScopeBuilder;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.scopes.ASFileScopeProvider;
import org.apache.royale.compiler.internal.units.CompilationUnitBase;
import org.apache.royale.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.royale.compiler.internal.units.requests.ABCFileScopeRequestResult;
import org.apache.royale.compiler.internal.units.requests.SyntaxTreeRequestResult;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem2;
import org.apache.royale.compiler.problems.InvalidABCByteCodeProblem;
import org.apache.royale.compiler.problems.NoScopesInABCCompilationUnitProblem;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IABCBytesRequestResult;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.royale.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.royale.compiler.units.requests.ISyntaxTreeRequestResult;
import org.apache.royale.swf.SWFFrame;
import org.apache.royale.swf.tags.DoABCTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABCCompilationUnit
extends CompilationUnitBase {
    private static final String SUB_SYSTEM = "ABCCompilationUnit";

    public ABCCompilationUnit(CompilerProject project, String path) {
        super(project, path, DefinitionPriority.BasePriority.LIBRARY_PATH, false);
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.ABC_UNIT;
    }

    public ICompilationUnit.Operation[] notifyDependencyOperationResultsInvalid(ICompilationUnit dependency, ICompilationUnit.Operation[] invalidatedOperations) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        SyntaxTreeRequestResult syntaxTreeRequestResult;
        this.startProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        try {
            List<ICompilerProblem> noProblems = Collections.emptyList();
            syntaxTreeRequestResult = new SyntaxTreeRequestResult(this.getRootFileSpecification().getLastModified(), noProblems);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
            throw throwable;
        }
        this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        return syntaxTreeRequestResult;
    }

    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        this.getProject().clearScopeCacheForCompilationUnit(this);
        HashSet<ICompilerProblem> problems = new HashSet<ICompilerProblem>();
        byte[] abcData = this.getABCBytes(problems);
        List<IASScope> scopeList = null;
        try {
            String path = this.getAbsoluteFilename();
            ABCScopeBuilder abcScopeBuilder = new ABCScopeBuilder(this.getProject().getWorkspace(), abcData, path, ASFileScopeProvider.getInstance());
            scopeList = abcScopeBuilder.build();
            if (scopeList.isEmpty()) {
                NoScopesInABCCompilationUnitProblem problem = new NoScopesInABCCompilationUnitProblem(path);
                problems.add(problem);
            }
        }
        catch (Exception e) {
            InvalidABCByteCodeProblem problem = new InvalidABCByteCodeProblem(this.getRootFileSpecification().getPath());
            problems.add(problem);
        }
        ABCFileScopeRequestResult result = new ABCFileScopeRequestResult((Collection<ICompilerProblem>)problems, (Collection<IASScope>)scopeList);
        this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        return result;
    }

    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        ABCBytesRequestResult result = new ABCBytesRequestResult();
        this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        return result;
    }

    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        ISWFTagsRequestResult result = new ISWFTagsRequestResult(){

            public boolean addToFrame(SWFFrame frame) {
                return true;
            }

            public ICompilerProblem[] getProblems() {
                return IABCBytesRequestResult.ZEROPROBLEMS;
            }

            public String getDoABCTagName() {
                return "";
            }

            public DoABCTag getDoABCTag() {
                return null;
            }
        };
        this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        return result;
    }

    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        IOutgoingDependenciesRequestResult result = new IOutgoingDependenciesRequestResult(){

            public ICompilerProblem[] getProblems() {
                return IABCBytesRequestResult.ZEROPROBLEMS;
            }
        };
        this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getABCBytes(Collection<ICompilerProblem> problems) {
        IFileSpecification rootSource = this.getRootFileSpecification();
        byte[] abcData = null;
        if (rootSource instanceof IBinaryFileSpecification) {
            IBinaryFileSpecification abcFileSpec = (IBinaryFileSpecification)rootSource;
            InputStream abcStream = null;
            abcStream = abcFileSpec.createInputStream();
            abcData = IOUtils.toByteArray((InputStream)abcStream);
            assert (abcData != null) : "No ABC byte code.";
            Object var9_7 = null;
            if (abcStream == null) return abcData;
            try {
                abcStream.close();
                return abcData;
            }
            catch (IOException e2) {
                InternalCompilerProblem2 problem2 = new InternalCompilerProblem2(rootSource.getPath(), e2, SUB_SYSTEM);
                problems.add(problem2);
            }
            return abcData;
            {
                catch (Exception e) {
                    InternalCompilerProblem2 problem = new InternalCompilerProblem2(rootSource.getPath(), e, SUB_SYSTEM);
                    problems.add(problem);
                    Object var9_8 = null;
                    if (abcStream == null) return abcData;
                    try {
                        abcStream.close();
                        return abcData;
                    }
                    catch (IOException e2) {
                        InternalCompilerProblem2 problem2 = new InternalCompilerProblem2(rootSource.getPath(), e2, SUB_SYSTEM);
                        problems.add(problem2);
                    }
                    return abcData;
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (abcStream == null) throw throwable;
                try {
                    abcStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    InternalCompilerProblem2 problem2 = new InternalCompilerProblem2(rootSource.getPath(), e2, SUB_SYSTEM);
                    problems.add(problem2);
                }
                throw throwable;
            }
        }
        InvalidABCByteCodeProblem problem = new InvalidABCByteCodeProblem(rootSource.getPath());
        problems.add(problem);
        return abcData;
    }
}

