/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.IMetaInfo;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.mxml.StateDefinition;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IStateDefinition;
import org.apache.royale.compiler.problems.MXMLSemanticProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStateNode;

class MXMLStateNode
extends MXMLInstanceNode
implements IMXMLStateNode {
    private IStateDefinition stateDefinition;
    private String[] stateGroups;
    private String basedOn;

    MXMLStateNode(NodeBase parent) {
        super(parent);
    }

    public String getStateName() {
        return this.stateDefinition.getBaseName();
    }

    public int getNameStart() {
        return this.stateDefinition.getNameStart();
    }

    public int getNameEnd() {
        return this.stateDefinition.getNameEnd();
    }

    public int getNameAbsoluteStart() {
        return this.stateDefinition.getNode() != null ? this.stateDefinition.getNode().getNameAbsoluteStart() : this.getNameStart();
    }

    public int getNameAbsoluteEnd() {
        return this.stateDefinition.getNode() != null ? this.stateDefinition.getNode().getNameAbsoluteEnd() : this.getNameEnd();
    }

    public String getNamespace() {
        return "public";
    }

    public IExpressionNode getNameExpressionNode() {
        return null;
    }

    public String[] getStateGroups() {
        return this.stateGroups != null ? this.stateGroups : new String[]{};
    }

    public String getBasedOn() {
        return this.basedOn;
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLStateID;
    }

    public IMetaTagsNode getMetaTags() {
        return null;
    }

    public IMetaInfo[] getMetaInfos() {
        return new IMetaInfo[0];
    }

    public IDefinition getDefinition() {
        return this.stateDefinition;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getShortName() {
        return this.getStateName();
    }

    public boolean hasModifier(ASModifier modifier) {
        return this.stateDefinition.hasModifier(modifier);
    }

    public boolean hasNamespace(String namespace) {
        return namespace.equals("public");
    }

    public boolean isImplicit() {
        return this.stateDefinition.isImplicit();
    }

    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        String value = attribute.getRawValue();
        if (attribute.isSpecialAttribute("name")) {
            this.stateDefinition = new StateDefinition(this, this.getASScope(), value, attribute.getValueStart(), attribute.getValueEnd());
        } else if (attribute.isSpecialAttribute("stateGroups")) {
            this.stateGroups = attribute.getMXMLDialect().splitAndTrim(value);
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    protected String[] processIncludeInOrExcludeFromAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        MXMLSemanticProblem problem = new MXMLSemanticProblem(attribute);
        builder.addProblem(problem);
        return null;
    }

    protected String processItemCreationPolicyAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        MXMLSemanticProblem problem = new MXMLSemanticProblem(attribute);
        builder.addProblem(problem);
        return null;
    }

    protected String processItemDestructionPolicyAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        MXMLSemanticProblem problem = new MXMLSemanticProblem(attribute);
        builder.addProblem(problem);
        return null;
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        ((MXMLClassDefinitionNode)this.getClassDefinitionNode()).addStateNode(this);
    }

    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getStateName());
        sb.append('\"');
        return true;
    }
}

