/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.MXMLEmptyAttributeProblem;
import org.apache.royale.compiler.problems.MXMLIncludeInAndExcludeFromProblem;
import org.apache.royale.compiler.problems.MXMLRequiredAttributeProblem;
import org.apache.royale.compiler.problems.MXMLSemanticProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLReparentNode;

class MXMLReparentNode
extends MXMLNodeBase
implements IMXMLReparentNode {
    private String target;
    private String[] includeIn;
    private String[] excludeFrom;

    MXMLReparentNode(NodeBase parent) {
        super(parent);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLReparentID;
    }

    public String getName() {
        return "Reparent";
    }

    public String[] getIncludeIn() {
        return this.includeIn;
    }

    public String[] getExcludeFrom() {
        return this.excludeFrom;
    }

    public String getTarget() {
        return this.target;
    }

    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("target")) {
            this.target = this.processTargetAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("includeIn")) {
            this.includeIn = this.processIncludeInOrExcludeFromAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("excludeFrom")) {
            this.excludeFrom = this.processIncludeInOrExcludeFromAttribute(builder, attribute);
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    private String processTargetAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        String value = attribute.getRawValue();
        value = mxmlDialect.trim(value);
        return value;
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLSemanticProblem problem;
        if (this.target == null) {
            problem = new MXMLRequiredAttributeProblem(tag, "target");
            builder.addProblem(problem);
        } else if (this.target.isEmpty()) {
            problem = new MXMLEmptyAttributeProblem(tag.getTagAttributeData("target"));
            builder.addProblem(problem);
        }
        if (this.includeIn != null && this.excludeFrom != null) {
            problem = new MXMLIncludeInAndExcludeFromProblem(tag);
            builder.addProblem(problem);
            this.includeIn = null;
            this.excludeFrom = null;
        }
        super.initializationComplete(builder, tag, info);
    }
}

