/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.MXMLEmptyAttributeProblem;
import org.apache.royale.compiler.problems.MXMLInvalidDefinitionNameProblem;
import org.apache.royale.compiler.problems.MXMLRequiredAttributeProblem;
import org.apache.royale.compiler.problems.MXMLSemanticProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDefinitionNode;

class MXMLDefinitionNode
extends MXMLNodeBase
implements IMXMLDefinitionNode {
    private String definitionName;
    private MXMLClassDefinitionNode containedClassDefinitionNode;

    MXMLDefinitionNode(NodeBase parent) {
        super(parent);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLDefinitionID;
    }

    public String getName() {
        return "Definition";
    }

    public int getChildCount() {
        return this.containedClassDefinitionNode != null ? 1 : 0;
    }

    public IASNode getChild(int i) {
        return i == 0 ? this.containedClassDefinitionNode : null;
    }

    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("name")) {
            String rawValue;
            if (this.definitionName == null && (rawValue = attribute.getRawValue()) != null) {
                this.definitionName = attribute.getMXMLDialect().trim(rawValue);
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        boolean handled = false;
        if (this.containedClassDefinitionNode == null) {
            IClassDefinition tagDefinition;
            MXMLSemanticProblem problem;
            this.containedClassDefinitionNode = new MXMLClassDefinitionNode(this);
            handled = true;
            RoyaleProject project = builder.getProject();
            IDefinition tagDef = builder.getFileScope().resolveTagToDefinition(childTag);
            if (tagDef == null) {
                problem = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem);
            }
            if (!(tagDef instanceof IClassDefinition)) {
                problem = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem);
            }
            if ((tagDefinition = (IClassDefinition)tagDef).isFinal()) {
                MXMLSemanticProblem problem2 = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem2);
            }
            MXMLFileScope fileScope = builder.getFileScope();
            ClassDefinition definitionTagClass = fileScope.getClassDefinitionForDefinitionTag(tag);
            assert (tagDefinition == definitionTagClass.resolveBaseClass(project));
            this.containedClassDefinitionNode.setClassReference(project, tagDefinition);
            this.containedClassDefinitionNode.setClassDefinition(definitionTagClass);
            this.containedClassDefinitionNode.initializeFromTag(builder, childTag);
            int nameStart = definitionTagClass.getNameStart();
            int nameEnd = definitionTagClass.getNameEnd();
            definitionTagClass.setNode(this.containedClassDefinitionNode);
            definitionTagClass.setNameLocation(nameStart, nameEnd);
        }
        if (!handled) {
            super.processChildTag(builder, tag, childTag, info);
        }
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (this.definitionName == null) {
            MXMLRequiredAttributeProblem problem = new MXMLRequiredAttributeProblem(tag, "name");
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        } else if (this.definitionName.isEmpty()) {
            MXMLEmptyAttributeProblem problem = new MXMLEmptyAttributeProblem(tag.getTagAttributeData("name"));
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        } else if (!MXMLDefinitionNode.isValidXMLTagName(this.definitionName)) {
            MXMLInvalidDefinitionNameProblem problem = new MXMLInvalidDefinitionNameProblem(tag.getTagAttributeData("name"), this.definitionName);
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        }
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public IMXMLClassDefinitionNode getContainedClassDefinitionNode() {
        return this.containedClassDefinitionNode;
    }

    public IClassDefinition getContainedClassDefinition() {
        return this.containedClassDefinitionNode != null ? this.containedClassDefinitionNode.getClassDefinition() : null;
    }
}

