/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as.metadata;

import java.util.Comparator;
import java.util.List;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.definitions.metadata.MetaTag;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.TreeNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagValue;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.utils.CheapArray;

public abstract class MetaTagNode
extends TreeNode
implements IMetaTagNode {
    private static final IMetaTagAttribute[] EMPTY_ARRAY = new IMetaTagAttribute[0];
    static final String NAME = "name";
    static final String VALUE = "value";
    static final String ATTR_PAIR = "AttrPair";
    private static MetaTagValue[] emptyAttrArray = new MetaTagValue[0];
    protected String tagName;
    private Object metaAttrs;

    public MetaTagNode(String name) {
        if (name != null) {
            this.tagName = name;
        }
        this.metaAttrs = CheapArray.create(4);
    }

    public MetaTagNode(MetaTagNode other) {
        this.metaAttrs = other.metaAttrs;
        this.tagName = other.tagName;
    }

    public void addToMap(String name, String value) {
        if (!(this.metaAttrs instanceof List)) {
            this.metaAttrs = CheapArray.create(2);
        }
        if (name == null || name.equals(IMetaTagNode.SINGLE_VALUE)) {
            CheapArray.add(new MetaTagValue(value), this.metaAttrs);
        } else {
            CheapArray.add(new MetaTagValue(name, value), this.metaAttrs);
        }
    }

    protected void optimizeChildren(Object newChildren) {
        this.metaAttrs = CheapArray.optimize(this.metaAttrs, emptyAttrArray);
        super.optimizeChildren(newChildren);
    }

    protected int getInitialChildCount() {
        return 0;
    }

    public IDefinitionNode getDecoratedDefinitionNode() {
        IASNode parent = this.getParent();
        if (parent instanceof MetaTagsNode) {
            return ((MetaTagsNode)parent).getDecoratedDefinition();
        }
        return null;
    }

    public String getValue(String key) {
        IMetaTagAttribute attribute = this.getAttribute(key);
        if (attribute != null) {
            return attribute.getValue();
        }
        return "";
    }

    public IMetaTagAttribute getAttribute(String key) {
        int size = CheapArray.size(this.metaAttrs);
        for (int i = 0; i < size; ++i) {
            Object object = CheapArray.get(i, this.metaAttrs);
            if (!(object instanceof IMetaTagAttribute)) continue;
            if (key == SINGLE_VALUE && !((IMetaTagAttribute)object).hasKey()) {
                return (IMetaTagAttribute)object;
            }
            String tagKey = ((IMetaTagAttribute)object).getKey();
            if (tagKey == null || tagKey.compareTo(key) != 0) continue;
            return (IMetaTagAttribute)object;
        }
        return null;
    }

    public String getAttributeValue(String key) {
        IMetaTagAttribute attribute = this.getAttribute(key);
        return attribute != null ? attribute.getValue() : null;
    }

    public IMetaTagAttribute[] getAllAttributes() {
        return (IMetaTagAttribute[])CheapArray.toArray(this.metaAttrs, EMPTY_ARRAY);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetaTagNode) {
            if (this.getAbsoluteStart() != ((MetaTagNode)obj).getAbsoluteStart()) {
                return false;
            }
            if (this.getAbsoluteEnd() != ((MetaTagNode)obj).getAbsoluteEnd()) {
                return false;
            }
            return obj.toString().compareTo(this.toString()) == 0;
        }
        return super.equals(obj);
    }

    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('[');
        sb.append(this.getTagName());
        sb.append('(');
        int size = CheapArray.size(this.metaAttrs);
        for (int i = 0; i < size; ++i) {
            String key = ((IMetaTagAttribute)CheapArray.get(i, this.metaAttrs)).getKey();
            String value = ((IMetaTagAttribute)CheapArray.get(i, this.metaAttrs)).getValue();
            if (key == null) {
                sb.append('\"');
                sb.append(value);
                sb.append('\"');
                continue;
            }
            sb.append(key);
            sb.append('=');
            sb.append('\"');
            sb.append(value);
            sb.append('\"');
            if (i + 1 >= size) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append(')');
        sb.append(']');
        return true;
    }

    public String getTagName() {
        return this.tagName;
    }

    protected boolean equals(IdentifierNode left, IdentifierNode right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        if (left.getName().compareTo(right.getName()) != 0) {
            return false;
        }
        if (left.getAbsoluteStart() != right.getAbsoluteStart()) {
            return false;
        }
        return left.getAbsoluteEnd() == right.getAbsoluteEnd();
    }

    public String getDefaultValue(String name, String defaultValue) {
        return this.getValue(defaultValue);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MetaTagID;
    }

    public IMetaTag buildMetaTag(IFileSpecification containingFileSpec, IDefinition definition) {
        String name = this.getTagName();
        MetaTag metaTag = new MetaTag(definition, name, this.getAllAttributes());
        metaTag.setLocation(containingFileSpec, this.getAbsoluteStart(), this.getAbsoluteEnd(), this.getLine(), this.getColumn());
        return metaTag;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MetaComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof MetaTagNode && o2 instanceof MetaTagNode) {
                return ((MetaTagNode)o1).toString().compareTo(((MetaTagNode)o2).toString());
            }
            if (o1 instanceof MetaTagValue && o2 instanceof MetaTagValue) {
                return ((MetaTagValue)o1).toString().compareTo(((MetaTagValue)o2).toString());
            }
            return 0;
        }
    }
}

