/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as.metadata;

import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.metadata.BaseDefinitionMetaTagNode;
import org.apache.royale.compiler.tree.as.ICommonClassNode;
import org.apache.royale.compiler.tree.metadata.IEffectTagNode;
import org.apache.royale.compiler.workspaces.IWorkspace;

public final class EffectTagNode
extends BaseDefinitionMetaTagNode
implements IEffectTagNode {
    private IdentifierNode eventName;

    public EffectTagNode() {
        super("Effect");
    }

    public void setEvent(IdentifierNode event) {
        if (this.eventName == null) {
            this.eventName = event;
            if (this.eventName != null) {
                this.eventName.setParent(this);
                this.addToMap("event", this.getEventName());
            }
        }
    }

    public String getEventName() {
        return this.eventName != null ? this.eventName.getName() : "";
    }

    public IdentifierNode getEventNode() {
        return this.eventName;
    }

    protected void setChildren(boolean fillInOffsets) {
        this.addChildInOrder(this.nameNode, fillInOffsets);
        this.addChildInOrder(this.eventName, fillInOffsets);
    }

    protected int getInitialChildCount() {
        return 2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EffectTagNode) {
            if (!this.equals(((EffectTagNode)obj).nameNode, this.nameNode)) {
                return false;
            }
            if (!this.equals(((EffectTagNode)obj).eventName, this.eventName)) {
                return false;
            }
        } else {
            return false;
        }
        return super.equals(obj);
    }

    public IDefinition getDefinition() {
        ICommonClassNode decoratedClassNode = (ICommonClassNode)this.getAncestorOfType(ICommonClassNode.class);
        if (decoratedClassNode == null) {
            return null;
        }
        IWorkspace workspace = this.getWorkspace();
        IClassDefinition decoratedClassDefinition = decoratedClassNode.getDefinition();
        assert (decoratedClassDefinition != null);
        return decoratedClassDefinition.getEffectDefinition(workspace, this.getName());
    }
}

