/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as.metadata;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.royale.compiler.asdoc.IASDocComment;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.IMetaInfo;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDocumentableDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDefinitionMetaTagNode
extends MetaTagNode
implements IDefinitionNode,
IDocumentableDefinitionNode {
    protected IdentifierNode nameNode;
    private IASDocComment asDocComment;

    public BaseDefinitionMetaTagNode(MetaTagNode other) {
        super(other);
    }

    public BaseDefinitionMetaTagNode(String name) {
        super(name);
    }

    public void setName(IdentifierNode name) {
        if (name != null) {
            this.nameNode = name;
            this.nameNode.setParent(this);
        }
        this.addToMap("name", this.getName());
    }

    @Override
    public String getName() {
        if (this.nameNode != null) {
            return this.nameNode.getName();
        }
        return "";
    }

    @Override
    public IExpressionNode getNameExpressionNode() {
        return this.nameNode;
    }

    public IdentifierNode getNameNode() {
        return this.nameNode;
    }

    @Override
    public int getNameEnd() {
        if (this.nameNode != null) {
            return this.nameNode.getEnd();
        }
        return -1;
    }

    @Override
    public int getNameStart() {
        if (this.nameNode != null) {
            return this.nameNode.getStart();
        }
        return -1;
    }

    @Override
    public int getNameAbsoluteStart() {
        if (this.nameNode != null) {
            return this.nameNode.getAbsoluteStart();
        }
        return -1;
    }

    @Override
    public int getNameAbsoluteEnd() {
        if (this.nameNode != null) {
            return this.nameNode.getAbsoluteEnd();
        }
        return -1;
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public String getQualifiedName() {
        String parentQualifiedName = this.getParentQualifiedName();
        if (parentQualifiedName != null && parentQualifiedName.length() > 0) {
            return parentQualifiedName + "." + this.getShortName();
        }
        if (this.getPackageName() != null && this.getPackageName().length() > 0) {
            return this.getPackageName() + "." + this.getShortName();
        }
        return this.getShortName();
    }

    public boolean matches(BaseDefinitionMetaTagNode node) {
        if (node == null) {
            return false;
        }
        if (node.getClass() != this.getClass()) {
            return false;
        }
        if (node == this) {
            return true;
        }
        if (node.getQualifiedName().compareTo(this.getQualifiedName()) != 0) {
            return false;
        }
        String packageName = node.getPackageName();
        String packageName2 = this.getPackageName();
        if (packageName == null && packageName2 != null) {
            return false;
        }
        if (packageName != null && packageName2 != null && packageName.compareTo(packageName2) != 0) {
            return false;
        }
        return node.getContainingFilePath().compareTo(this.getContainingFilePath()) == 0;
    }

    public String getParentQualifiedName() {
        IDefinitionNode decNode;
        IASNode parent = this.getParent();
        if (parent instanceof MetaTagsNode && (decNode = ((MetaTagsNode)parent).getDecoratedDefinition()) != null) {
            return decNode.getQualifiedName();
        }
        return null;
    }

    @Override
    public boolean hasModifier(ASModifier modifier) {
        return false;
    }

    @Override
    public boolean hasNamespace(String namespace) {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public IMetaTagsNode getMetaTags() {
        return null;
    }

    @Override
    public IMetaInfo[] getMetaInfos() {
        return new IMetaInfo[0];
    }

    @Override
    public String getNamespace() {
        return null;
    }

    public INamespaceNode resolveNamespace() {
        return null;
    }

    public void setASDocComment(IASDocComment ref) {
        this.asDocComment = ref;
    }

    @Override
    public boolean hasExplicitComment() {
        return this.asDocComment != null;
    }

    @Override
    public IASDocComment getASDocComment() {
        return this.asDocComment;
    }
}

