/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.ParameterDefinition;
import org.apache.royale.compiler.internal.definitions.SyntheticBindableGetterDefinition;
import org.apache.royale.compiler.internal.definitions.SyntheticBindableSetterDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.FunctionScope;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.ITypedNode;

public abstract class BaseTypedDefinitionNode
extends BaseDefinitionNode
implements ITypedNode {
    protected int typeOperatorStart;
    protected ExpressionNodeBase typeNode;

    protected void init(ExpressionNodeBase nameNode) {
        super.init(nameNode);
        this.typeOperatorStart = -1;
        this.typeNode = null;
    }

    public ExpressionNodeBase getTypeNode() {
        return this.typeNode;
    }

    public boolean hasTypeOperator() {
        return this.typeOperatorStart != -1;
    }

    public int getTypeOperatorStart() {
        return this.typeOperatorStart;
    }

    public int getTypeOperatorEnd() {
        return this.typeOperatorStart + 1;
    }

    public boolean hasExplicitType() {
        if (this.typeNode instanceof IdentifierNode) {
            return !((IdentifierNode)this.typeNode).isImplicit();
        }
        return this.typeNode != null;
    }

    public String getTypeName() {
        return this.hasExplicitType() ? ((IIdentifierNode)((Object)this.typeNode)).getName() : "";
    }

    public boolean isVoidType() {
        return this.typeNode instanceof ILanguageIdentifierNode && ((ILanguageIdentifierNode)((Object)this.typeNode)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.VOID;
    }

    public boolean isAnyType() {
        return this.typeNode instanceof ILanguageIdentifierNode && ((ILanguageIdentifierNode)((Object)this.typeNode)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.ANY_TYPE;
    }

    public void setType(IASToken typeOperator, ExpressionNodeBase variableType) {
        if (typeOperator != null) {
            this.typeOperatorStart = typeOperator.getStart();
        }
        this.typeNode = variableType;
    }

    protected void fillinDefinition(DefinitionBase definition) {
        definition.setNode(this);
        this.fillInNamespaceAndModifiers(definition);
        this.fillInMetadata(definition);
        IReference typeRef = this.hasExplicitType() ? this.typeNode.computeTypeReference() : null;
        definition.setTypeReference(typeRef);
    }

    public DefinitionBase buildBindableGetter(String definitionName) {
        SyntheticBindableGetterDefinition getter = new SyntheticBindableGetterDefinition(definitionName);
        this.fillinDefinition(getter);
        IReference typeRef = getter.getTypeReference();
        getter.setReturnTypeReference(typeRef);
        return getter;
    }

    public DefinitionBase buildBindableSetter(String definitionName, ASScope containingScope, IReference typeRef) {
        SyntheticBindableSetterDefinition setter = new SyntheticBindableSetterDefinition(definitionName);
        this.fillinDefinition(setter);
        ParameterDefinition param = new ParameterDefinition("");
        param.setTypeReference(typeRef);
        setter.setParameters(new ParameterDefinition[]{param});
        setter.setTypeReference(typeRef);
        FunctionScope setterContainedScope = new FunctionScope(containingScope);
        setter.setContainedScope(setterContainedScope);
        setterContainedScope.addDefinition(param);
        setter.setReturnTypeReference(ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.VOID));
        return setter;
    }

    DefinitionBase[] buildBindableDefinitions(ASScope containingScope) {
        DefinitionBase[] definitions;
        String definitionName = this.nameNode.computeSimpleReference();
        definitions = new DefinitionBase[]{this.buildBindableGetter(definitionName), this.buildBindableSetter(definitionName, containingScope, definitions[0].getTypeReference())};
        return definitions;
    }
}

