/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import java.io.IOException;
import java.io.Reader;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.as.RawASTokenizer;
import org.apache.royale.compiler.parsing.IASBalancingScanner;
import org.apache.royale.utils.NonLockingStringReader;

public class ASBalancingScanner
implements IASBalancingScanner {
    private int countBraces(Reader input) throws IOException {
        ASToken token;
        RawASTokenizer tokenizer = new RawASTokenizer(input);
        int counter = 0;
        do {
            if ((token = tokenizer.nextToken()) == null) continue;
            switch (token.getType()) {
                case 20: {
                    --counter;
                    break;
                }
                case 19: {
                    ++counter;
                    break;
                }
            }
        } while (token != null);
        return counter;
    }

    public boolean areBracesBalanced(Reader input) {
        int braceCount = 0;
        try {
            braceCount = this.countBraces(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return braceCount == 0;
    }

    public boolean areBracesBalanced(String range) {
        return this.areBracesBalanced(new NonLockingStringReader(range));
    }

    public boolean areBracesBalancedOrOverbalanced(Reader input) {
        int braceCount = 0;
        try {
            braceCount = this.countBraces(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return braceCount <= 0;
    }

    public boolean areBracesBalancedOrOverbalanced(String range) {
        return this.areBracesBalancedOrOverbalanced(new NonLockingStringReader(range));
    }
}

