/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.AbstractFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.DefinitionNode;
import org.apache.royale.compiler.problems.FXGMissingAttributeProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryNode
extends AbstractFXGNode {
    public HashMap<String, DefinitionNode> definitions;

    public DefinitionNode getDefinition(String name) {
        if (this.definitions != null) {
            return this.definitions.get(name);
        }
        return null;
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof DefinitionNode) {
            if (this.definitions == null) {
                this.definitions = new HashMap();
            }
            DefinitionNode node = (DefinitionNode)child;
            if (node.name == null) {
                problems.add(new FXGMissingAttributeProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn(), "name", child.getNodeName()));
                return;
            }
            this.definitions.put(node.name, node);
        } else {
            super.addChild(child, problems);
        }
    }

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        children.addAll(super.getChildren());
        if (this.definitions != null) {
            children.addAll(this.definitions.values());
        }
        return children;
    }

    @Override
    public String getNodeName() {
        return "Library";
    }
}

