/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.internal.definitions.MemberedDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.tree.as.IPackageNode;

public class PackageDefinition
extends MemberedDefinition
implements IPackageDefinition {
    private static final String STAR = "*";
    private static final String DOT_STAR = ".*";
    private IPackageDefinition.PackageKind packageKind = IPackageDefinition.PackageKind.CONCRETE;

    public static String getQualifiedPackageNameFromNamespaceURI(String uri) {
        String packageName = null;
        if (uri.equals(STAR)) {
            packageName = "";
        } else if (uri.endsWith(DOT_STAR)) {
            packageName = uri.substring(0, uri.length() - DOT_STAR.length());
        }
        return packageName;
    }

    public PackageDefinition(String packageName) {
        super(packageName);
        this.setNamespaceReference(NamespaceDefinition.getCodeModelImplicitDefinitionNamespace());
    }

    public IPackageDefinition.PackageKind getPackageKind() {
        return this.packageKind;
    }

    public void setVirtual() {
        this.packageKind = IPackageDefinition.PackageKind.VIRTUAL;
    }

    protected String toStorageName(String name) {
        return name;
    }

    public String getBaseName() {
        return this.getStorageName();
    }

    public String getQualifiedName() {
        return this.getStorageName();
    }

    public IPackageNode getNode() {
        return (IPackageNode)super.getNode();
    }

    protected void buildInnerString(StringBuilder sb) {
        String name = this.getQualifiedName();
        sb.append("package");
        sb.append(' ');
        sb.append(name.length() > 0 ? name : "\"\"");
    }
}

