/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IAppliedVectorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IEffectDefinition;
import org.apache.royale.compiler.definitions.IEventDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IStyleDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.definitions.ClassDefinitionBase;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.GetterDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.ParameterDefinition;
import org.apache.royale.compiler.internal.definitions.ScopedDefinitionBase;
import org.apache.royale.compiler.internal.definitions.SetterDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.definitions.VectorInformation;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.FunctionScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.TypedExpressionNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.workspaces.IWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppliedVectorDefinition
extends ClassDefinitionBase
implements IAppliedVectorDefinition {
    private static final Name VECTOR_NAME;
    private ICompilerProject project;
    private IClassDefinition baseClass;
    private ITypeDefinition elementType;

    private static String getName(ITypeDefinition elementType, boolean useFullyQualifiedNotation) {
        StringBuilder builder = new StringBuilder();
        builder.append("Vector");
        builder.append(".<");
        if (useFullyQualifiedNotation) {
            builder.append(elementType.getQualifiedName());
        } else {
            builder.append(elementType.getBaseName());
        }
        builder.append(">");
        return builder.toString();
    }

    private static ParameterDefinition copyParameter(ICompilerProject project, ParameterDefinition orig, VectorInformation.ArgumentInfo info) {
        ParameterDefinition newParam = new ParameterDefinition(info != null ? info.getName() : orig.getBaseName());
        newParam.setNamespaceReference(orig.getNamespaceReference());
        newParam.setTypeReference(orig.getTypeReference());
        if (orig.isRest()) {
            newParam.setRest();
        }
        if (orig.hasDefaultValue()) {
            newParam.setDefaultValue(orig.resolveDefaultValue(project));
        }
        return newParam;
    }

    public AppliedVectorDefinition(ICompilerProject project, IClassDefinition baseClass, ITypeDefinition elementType) {
        super(AppliedVectorDefinition.getName(elementType, false));
        this.project = project;
        this.baseClass = baseClass;
        this.elementType = elementType;
        this.setContainedScope(new TypeScope(null, this));
        this.setModifier(ASModifier.FINAL);
        this.setImplicit();
        this.setNamespaceReference(NamespaceDefinition.getPublicNamespaceDefinition());
    }

    @Override
    protected String toStorageName(String name) {
        return name;
    }

    @Override
    public IReference getBaseClassReference() {
        return null;
    }

    @Override
    protected TypeDefinitionBase resolveType(String typeName, ICompilerProject project, DependencyType dt) {
        return AppliedVectorDefinition.resolveType((DefinitionBase)((Object)this.baseClass), typeName, project, dt);
    }

    @Override
    public final String getQualifiedName() {
        return AppliedVectorDefinition.getName(this.elementType, true);
    }

    @Override
    public final String getBaseName() {
        return AppliedVectorDefinition.getName(this.elementType, false);
    }

    @Override
    public final String getPackageName() {
        return "";
    }

    @Override
    public boolean isImplicit() {
        return true;
    }

    @Override
    public IClassDefinition[] resolveAncestry(ICompilerProject project) {
        return new IClassDefinition[]{this.baseClass};
    }

    public String getBaseClassName() {
        return this.baseClass.getBaseName();
    }

    @Override
    public IClassDefinition.ClassClassification getClassClassification() {
        return IClassDefinition.ClassClassification.PARAMETERIZED_CLASS_INSTANCE;
    }

    @Override
    public String[] getImplementedInterfacesAsDisplayStrings() {
        return new String[0];
    }

    @Override
    public IReference[] getImplementedInterfaceReferences() {
        return new IReference[0];
    }

    public IExpressionNode[] getImplementedInterfaceNodes() {
        return new IExpressionNode[0];
    }

    @Override
    public IMetaTag[] getMetaTagsByName(String name) {
        return new IMetaTag[0];
    }

    @Override
    public ITypeDefinition resolveElementType(ICompilerProject project) {
        return this.elementType;
    }

    public ExpressionNodeBase toExpression() {
        if (this.elementType instanceof AppliedVectorDefinition) {
            return new TypedExpressionNode(new IdentifierNode("Vector"), ((AppliedVectorDefinition)this.elementType).toExpression());
        }
        return new IdentifierNode(this.elementType.getBaseName());
    }

    public TypedExpressionNode toTypedExpression() {
        if (this.elementType instanceof AppliedVectorDefinition) {
            return new TypedExpressionNode(new IdentifierNode("Vector"), ((AppliedVectorDefinition)this.elementType).toTypedExpression());
        }
        return new TypedExpressionNode(new IdentifierNode("Vector"), new IdentifierNode(this.elementType.getBaseName()));
    }

    @Override
    public String getBaseClassAsDisplayString() {
        return this.baseClass.getQualifiedName();
    }

    @Override
    public IClassDefinition resolveBaseClass(ICompilerProject project) {
        return this.baseClass;
    }

    public String getDefaultPropertyName() {
        return null;
    }

    @Override
    public INamespaceDefinition getProtectedNamespaceReference() {
        return null;
    }

    @Override
    public INamespaceDefinition getStaticProtectedNamespaceReference() {
        return null;
    }

    @Override
    public IEventDefinition getEventDefinition(IWorkspace w, String name) {
        return null;
    }

    @Override
    public IEventDefinition[] getEventDefinitions(IWorkspace w) {
        return new IEventDefinition[0];
    }

    @Override
    public IEventDefinition[] findEventDefinitions(ICompilerProject project) {
        return new IEventDefinition[0];
    }

    @Override
    public IStyleDefinition getStyleDefinition(IWorkspace w, String name) {
        return null;
    }

    @Override
    public IStyleDefinition[] getStyleDefinitions(IWorkspace w) {
        return new IStyleDefinition[0];
    }

    @Override
    public IStyleDefinition[] findStyleDefinitions(ICompilerProject project) {
        return new IStyleDefinition[0];
    }

    @Override
    public IEffectDefinition getEffectDefinition(IWorkspace w, String name) {
        return null;
    }

    @Override
    public IEffectDefinition[] getEffectDefinitions(IWorkspace w) {
        return new IEffectDefinition[0];
    }

    @Override
    public IEffectDefinition[] findEffectDefinitions(ICompilerProject project) {
        return new IEffectDefinition[0];
    }

    @Override
    public String[] getSkinStates(Collection<ICompilerProblem> problems) {
        return new String[0];
    }

    @Override
    public String[] findSkinStates(ICompilerProject project, Collection<ICompilerProblem> problems) {
        return this.getSkinStates(problems);
    }

    @Override
    public IMetaTag[] getSkinParts(Collection<ICompilerProblem> problems) {
        return new IMetaTag[0];
    }

    @Override
    public IMetaTag[] findSkinParts(ICompilerProject project, Collection<ICompilerProblem> problems) {
        return this.getSkinParts(problems);
    }

    @Override
    public Set<String> getStateNames() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> findStateNames(ICompilerProject project) {
        return this.getStateNames();
    }

    @Override
    public Name getMName(ICompilerProject project) {
        Name typeName = ((DefinitionBase)((Object)this.elementType)).getMName(project);
        return new Name(VECTOR_NAME, typeName);
    }

    public void adjustVectorMethods(ICompilerProject project) {
        VectorInformation vecInfo = VectorInformation.getInformation();
        ASScope scope = this.getContainedScope();
        IASScope baseClassScope = this.baseClass.getContainedScope();
        for (IDefinition defaultDef : baseClassScope.getAllLocalDefinitions()) {
            ParameterDefinition[] params;
            FunctionDefinition newDef;
            String name = defaultDef.getBaseName();
            VectorInformation.FunctionInfo info = vecInfo.getFunctionInfo(name);
            if (!(defaultDef instanceof FunctionDefinition)) continue;
            FunctionDefinition defaultFunc = (FunctionDefinition)defaultDef;
            if (defaultDef instanceof GetterDefinition) {
                newDef = new GetterDefinition(name);
                newDef.setReturnTypeReference(defaultFunc.getReturnTypeReference());
                newDef.setTypeReference(defaultFunc.getTypeReference());
            } else if (defaultDef instanceof SetterDefinition) {
                newDef = new SetterDefinition(name);
                newDef.setReturnTypeReference(defaultFunc.getReturnTypeReference());
                newDef.setTypeReference(defaultFunc.getTypeReference());
            } else {
                newDef = new FunctionDefinition(name);
                newDef.setReturnTypeReference(defaultFunc.getReturnTypeReference());
            }
            FunctionScope newScope = new FunctionScope(scope);
            newDef.setContainedScope(newScope);
            newDef.setNamespaceReference(defaultDef.getNamespaceReference());
            if (info != null) {
                if (info.returnIsTypeOfCollection()) {
                    newDef.setReturnTypeReference(ReferenceFactory.resolvedReference(this.elementType));
                } else if (info.returnIsVector()) {
                    newDef.setReturnTypeReference(ReferenceFactory.resolvedReference(this));
                }
            }
            if ((params = defaultFunc.getParameters()) != null) {
                VectorInformation.ArgumentInfo[] args = info != null ? info.getArgumentInfo() : null;
                ParameterDefinition[] newParams = new ParameterDefinition[params.length];
                int l = params.length;
                for (int i = 0; i < l; ++i) {
                    if (args != null && i < args.length) {
                        newParams[i] = AppliedVectorDefinition.copyParameter(project, params[i], args[i]);
                        if (args[i].returnIsVector()) {
                            newParams[i].setTypeReference(ReferenceFactory.resolvedReference(this));
                        } else if (args[i].returnIsTypeOfCollection()) {
                            newParams[i].setTypeReference(ReferenceFactory.resolvedReference(this.elementType));
                        }
                    } else {
                        newParams[i] = AppliedVectorDefinition.copyParameter(project, params[i], null);
                    }
                    newScope.addDefinition(newParams[i]);
                }
                newDef.setParameters(newParams);
            }
            scope.addDefinition(newDef);
        }
    }

    public ICompilerProject getProject() {
        return this.project;
    }

    @Override
    public String getDefaultPropertyName(ICompilerProject project) {
        return null;
    }

    private static AppliedVectorDefinition toVectorNodeOrContainingVectorNode(IDefinition def) {
        assert (def != null);
        if (def instanceof AppliedVectorDefinition) {
            return (AppliedVectorDefinition)def;
        }
        ASScope containingScope = (ASScope)def.getContainingScope();
        if (containingScope == null) {
            return null;
        }
        ScopedDefinitionBase containingDefinition = containingScope.getDefinition();
        if (containingDefinition instanceof AppliedVectorDefinition) {
            return (AppliedVectorDefinition)containingDefinition;
        }
        ClassDefinitionBase containingClassDefiniton = containingScope.getContainingClass();
        if (containingClassDefiniton instanceof AppliedVectorDefinition) {
            return (AppliedVectorDefinition)containingClassDefiniton;
        }
        return null;
    }

    public static ICompilerProject getProjectIfVectorInsantiation(IDefinition def) {
        AppliedVectorDefinition vectorNode = AppliedVectorDefinition.toVectorNodeOrContainingVectorNode(def);
        if (vectorNode != null) {
            return vectorNode.getProject();
        }
        return null;
    }

    public static boolean isVectorScope(ASScope scope) {
        return scope.getDefinition() instanceof AppliedVectorDefinition || scope.getContainingClass() instanceof AppliedVectorDefinition;
    }

    @Override
    public IFunctionDefinition getConstructor() {
        assert (false) : "This should never get called.";
        return null;
    }

    @Override
    public IClassDefinition resolveHostComponent(ICompilerProject project) {
        return null;
    }

    public static boolean vectorInstanceOfCheck(ITypeDefinition base, ITypeDefinition derived) {
        if (!(base instanceof AppliedVectorDefinition)) {
            return false;
        }
        AppliedVectorDefinition vectorInstance = (AppliedVectorDefinition)base;
        if (vectorInstance.baseClass != derived) {
            return false;
        }
        assert (((INamespaceDefinition)((Object)vectorInstance.baseClass.getNamespaceReference())).getURI().equals("__AS3__.vec"));
        return !"Vector$object".equals(derived.getBaseName());
    }

    @Override
    public boolean isInProject(ICompilerProject project) {
        return project == this.project;
    }

    public static IClassDefinition lookupVectorImplClass(ICompilerProject project, String baseName) {
        INamespaceDefinition.ILanguageNamespaceDefinition vectorImplPackage = ((CompilerProject)project).getWorkspace().getPackageNamespaceDefinitionCache().get("__AS3__.vec", true);
        IResolvedQualifiersReference vectorReference = ReferenceFactory.resolvedQualifierQualifiedReference(project.getWorkspace(), vectorImplPackage, baseName);
        IDefinition vectorIDefinition = vectorReference.resolve(project);
        assert (vectorIDefinition instanceof IClassDefinition) : "Unable to find: " + vectorReference.getDisplayString();
        return (IClassDefinition)vectorIDefinition;
    }

    public void updateBaseClass(String changedVectorImplClass) {
        String baseClassBaseName = this.baseClass.getBaseName();
        if (baseClassBaseName.equals(changedVectorImplClass)) {
            this.baseClass = AppliedVectorDefinition.lookupVectorImplClass(this.project, baseClassBaseName);
        }
    }

    static {
        Nsset nsSet = new Nsset(new Namespace(22, "__AS3__.vec"));
        VECTOR_NAME = new Name(7, nsSet, "Vector");
    }
}

