/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import com.google.common.collect.ImmutableMap;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSPropertyValue;

public class CSSColorPropertyValue
extends CSSPropertyValue {
    protected static final ImmutableMap<String, Integer> COLOR_MAP = new ImmutableMap.Builder().put((Object)"black", (Object)0).put((Object)"navy", (Object)128).put((Object)"darkblue", (Object)139).put((Object)"mediumblue", (Object)205).put((Object)"blue", (Object)255).put((Object)"darkgreen", (Object)25600).put((Object)"green", (Object)32768).put((Object)"teal", (Object)32896).put((Object)"darkcyan", (Object)35723).put((Object)"deepskyblue", (Object)49151).put((Object)"darkturquoise", (Object)52945).put((Object)"mediumspringgreen", (Object)64154).put((Object)"lime", (Object)65280).put((Object)"springgreen", (Object)65407).put((Object)"aqua", (Object)65535).put((Object)"cyan", (Object)65535).put((Object)"midnightblue", (Object)1644912).put((Object)"dodgerblue", (Object)2003199).put((Object)"lightseagreen", (Object)2142890).put((Object)"forestgreen", (Object)0x228B22).put((Object)"seagreen", (Object)3050327).put((Object)"darkslategray", (Object)0x2F4F4F).put((Object)"darkslategrey", (Object)0x2F4F4F).put((Object)"limegreen", (Object)3329330).put((Object)"mediumseagreen", (Object)3978097).put((Object)"turquoise", (Object)4251856).put((Object)"royalblue", (Object)4286945).put((Object)"steelblue", (Object)4620980).put((Object)"darkslateblue", (Object)4734347).put((Object)"mediumturquoise", (Object)4772300).put((Object)"indigo ", (Object)4915330).put((Object)"darkolivegreen", (Object)5597999).put((Object)"cadetblue", (Object)6266528).put((Object)"cornflowerblue", (Object)6591981).put((Object)"mediumaquamarine", (Object)6737322).put((Object)"dimgray", (Object)0x696969).put((Object)"dimgrey", (Object)0x696969).put((Object)"slateblue", (Object)6970061).put((Object)"olivedrab", (Object)7048739).put((Object)"slategray", (Object)7372944).put((Object)"slategrey", (Object)7372944).put((Object)"lightslategray", (Object)0x778899).put((Object)"lightslategrey", (Object)0x778899).put((Object)"mediumslateblue", (Object)8087790).put((Object)"lawngreen", (Object)8190976).put((Object)"chartreuse", (Object)0x7FFF00).put((Object)"aquamarine", (Object)8388564).put((Object)"maroon", (Object)0x800000).put((Object)"purple", (Object)0x800080).put((Object)"olive", (Object)0x808000).put((Object)"gray", (Object)0x808080).put((Object)"grey", (Object)0x808080).put((Object)"skyblue", (Object)8900331).put((Object)"lightskyblue", (Object)8900346).put((Object)"blueviolet", (Object)9055202).put((Object)"darkred", (Object)0x8B0000).put((Object)"darkmagenta", (Object)0x8B008B).put((Object)"saddlebrown", (Object)9127187).put((Object)"darkseagreen", (Object)9419919).put((Object)"lightgreen", (Object)0x90EE90).put((Object)"mediumpurple", (Object)9662680).put((Object)"darkviolet", (Object)9699539).put((Object)"palegreen", (Object)10025880).put((Object)"darkorchid", (Object)10040012).put((Object)"yellowgreen", (Object)10145074).put((Object)"sienna", (Object)10506797).put((Object)"brown", (Object)0xA52A2A).put((Object)"darkgray", (Object)0xA9A9A9).put((Object)"darkgrey", (Object)0xA9A9A9).put((Object)"lightblue", (Object)11393254).put((Object)"greenyellow", (Object)11403055).put((Object)"paleturquoise", (Object)0xAFEEEE).put((Object)"lightsteelblue", (Object)11584734).put((Object)"powderblue", (Object)11591910).put((Object)"firebrick", (Object)0xB22222).put((Object)"darkgoldenrod", (Object)12092939).put((Object)"mediumorchid", (Object)12211667).put((Object)"rosybrown", (Object)12357519).put((Object)"darkkhaki", (Object)12433259).put((Object)"silver", (Object)0xC0C0C0).put((Object)"mediumvioletred", (Object)13047173).put((Object)"indianred ", (Object)0xCD5C5C).put((Object)"peru", (Object)13468991).put((Object)"chocolate", (Object)13789470).put((Object)"tan", (Object)13808780).put((Object)"lightgray", (Object)0xD3D3D3).put((Object)"lightgrey", (Object)0xD3D3D3).put((Object)"palevioletred", (Object)14184595).put((Object)"thistle", (Object)14204888).put((Object)"orchid", (Object)14315734).put((Object)"goldenrod", (Object)14329120).put((Object)"crimson", (Object)14423100).put((Object)"gainsboro", (Object)0xDCDCDC).put((Object)"plum", (Object)0xDDA0DD).put((Object)"burlywood", (Object)14596231).put((Object)"lightcyan", (Object)0xE0FFFF).put((Object)"lavender", (Object)15132410).put((Object)"darksalmon", (Object)15308410).put((Object)"violet", (Object)0xEE82EE).put((Object)"palegoldenrod", (Object)0xEEE8AA).put((Object)"lightcoral", (Object)0xF08080).put((Object)"khaki", (Object)15787660).put((Object)"aliceblue", (Object)0xF0F8FF).put((Object)"honeydew", (Object)0xF0FFF0).put((Object)"azure", (Object)0xF0FFFF).put((Object)"sandybrown", (Object)16032864).put((Object)"wheat", (Object)16113331).put((Object)"beige", (Object)16119260).put((Object)"whitesmoke", (Object)0xF5F5F5).put((Object)"mintcream", (Object)0xF5FFFA).put((Object)"ghostwhite", (Object)0xF8F8FF).put((Object)"salmon", (Object)16416882).put((Object)"antiquewhite", (Object)16444375).put((Object)"linen", (Object)16445670).put((Object)"lightgoldenrodyellow", (Object)16448210).put((Object)"oldlace", (Object)16643558).put((Object)"red", (Object)0xFF0000).put((Object)"fuchsia", (Object)0xFF00FF).put((Object)"magenta", (Object)0xFF00FF).put((Object)"deeppink", (Object)16716947).put((Object)"orangered", (Object)16729344).put((Object)"tomato", (Object)16737095).put((Object)"hotpink", (Object)16738740).put((Object)"coral", (Object)16744272).put((Object)"darkorange", (Object)16747520).put((Object)"lightsalmon", (Object)16752762).put((Object)"orange", (Object)16753920).put((Object)"lightpink", (Object)16758465).put((Object)"pink", (Object)16761035).put((Object)"gold", (Object)16766720).put((Object)"peachpuff", (Object)16767673).put((Object)"navajowhite", (Object)16768685).put((Object)"moccasin", (Object)16770229).put((Object)"bisque", (Object)16770244).put((Object)"mistyrose", (Object)16770273).put((Object)"blanchedalmond", (Object)16772045).put((Object)"papayawhip", (Object)16773077).put((Object)"lavenderblush", (Object)0xFFF0F5).put((Object)"seashell", (Object)0xFFF5EE).put((Object)"cornsilk", (Object)16775388).put((Object)"lemonchiffon", (Object)16775885).put((Object)"floralwhite", (Object)0xFFFAF0).put((Object)"snow", (Object)0xFFFAFA).put((Object)"yellow", (Object)0xFFFF00).put((Object)"lightyellow", (Object)0xFFFFE0).put((Object)"ivory", (Object)0xFFFFF0).put((Object)"white", (Object)0xFFFFFF).build();
    private final Token token;
    private final int colorInt;

    protected CSSColorPropertyValue(CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.PROPERTY_VALUE);
        String tokenText = tree.token.getText();
        assert (tokenText.startsWith("#")) : "Invalid color:" + tokenText;
        this.token = tree.token;
        if (tokenText.length() == 4) {
            StringBuilder six = new StringBuilder();
            six.append("#");
            six.append(tokenText.charAt(1));
            six.append(tokenText.charAt(1));
            six.append(tokenText.charAt(2));
            six.append(tokenText.charAt(2));
            six.append(tokenText.charAt(3));
            six.append(tokenText.charAt(3));
            tokenText = six.toString();
        }
        this.colorInt = Integer.parseInt(tokenText.substring(1), 16);
    }

    protected CSSColorPropertyValue(int colorInt, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.PROPERTY_VALUE);
        this.token = tree.token;
        this.colorInt = colorInt;
    }

    public int getColorAsInt() {
        return this.colorInt;
    }

    public String getText() {
        return this.token.getText();
    }

    public String toString() {
        return this.token.getText();
    }
}

