/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.fxg.flex;

import java.util.Collection;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.fxg.flex.FlexGraphicNode;
import org.apache.royale.compiler.internal.fxg.dom.GraphicContext;
import org.apache.royale.compiler.internal.fxg.dom.TextGraphicNode;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexTextGraphicNode
extends TextGraphicNode {
    private static final String FXG_TRACKING_RIGHT_PROPERTY = "trackingRight";
    private static final String FXG_PARAGRAPH_START_INDENT_PROPERTY = "paragraphStartIndent";
    private static final String FXG_PARAGRAPH_SPACE_BEFORE_PROPERTY = "paragraphSpaceBefore";
    private static final String FXG_PARAGRAPH_END_INDENT_PROPERTY = "paragraphEndIndent";
    private static final String FXG_PARAGRAPH_SPACE_AFT_PROPERTY = "paragraphSpaceAft";
    private static final String DEFAULT_FXG_FONT_FAMILY = "Times New Roman";

    public FlexTextGraphicNode() {
        this.setAttribute("fontFamily", DEFAULT_FXG_FONT_FAMILY, null);
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        super.setAttribute(name, value, problems);
        String newName = FlexTextGraphicNode.translateAttribute(name);
        if (!name.equals(newName)) {
            if (this.textAttributes != null) {
                this.textAttributes.remove(name);
            }
            this.rememberAttribute(newName, value);
        }
    }

    @Override
    public void setDocumentNode(IFXGNode root) {
        super.setDocumentNode(root);
        if (root instanceof FlexGraphicNode) {
            ((FlexGraphicNode)root).hasText = true;
        }
    }

    @Override
    public GraphicContext createGraphicContext() {
        GraphicContext graphicContext = new GraphicContext();
        if (this.colorTransform != null) {
            graphicContext.colorTransform = this.colorTransform;
        }
        if (this.filters != null) {
            graphicContext.addFilters(this.filters);
        }
        if (this.maskTypeSet) {
            graphicContext.maskType = this.maskType;
        }
        return graphicContext;
    }

    static String translateAttribute(String name) {
        if ("tracking".equals(name)) {
            name = FXG_TRACKING_RIGHT_PROPERTY;
        } else if ("marginLeft".equals(name)) {
            name = FXG_PARAGRAPH_START_INDENT_PROPERTY;
        } else if ("marginTop".equals(name)) {
            name = FXG_PARAGRAPH_SPACE_BEFORE_PROPERTY;
        } else if ("marginRight".equals(name)) {
            name = FXG_PARAGRAPH_END_INDENT_PROPERTY;
        } else if ("marginBottom".equals(name)) {
            name = FXG_PARAGRAPH_SPACE_AFT_PROPERTY;
        }
        return name;
    }
}

