/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.asdoc;

import antlr.Token;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.royale.compiler.asdoc.IASDocComment;
import org.apache.royale.compiler.asdoc.IASDocTag;
import org.apache.royale.compiler.internal.parsing.as.ASDocToken;
import org.apache.royale.compiler.internal.parsing.as.ASDocTokenizer;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.tree.as.IDocumentableDefinitionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASDocComment
implements IASDocComment {
    private ASToken token;
    private IDocumentableDefinitionNode node;
    private String description;
    Map<String, List<IASDocTag>> tags = new TreeMap<String, List<IASDocTag>>();

    public ASDocComment(ASToken token, IDocumentableDefinitionNode node) {
        this.token = token;
        this.node = node;
    }

    public ASDocComment(Token token) {
        this.token = (ASToken)token;
    }

    @Override
    public void compile() {
        if (this.token == null) {
            return;
        }
        String data = this.token.getText();
        ASDocTokenizer tokenizer = new ASDocTokenizer(false);
        tokenizer.setReader(new StringReader(data));
        ASDocToken tok = tokenizer.next();
        boolean foundDescription = false;
        ASDocTag pendingTag = null;
        try {
            while (tok != null) {
                if (!foundDescription && tok.getType() == 10) {
                    this.description = tok.getText();
                } else if (tok.getType() == 9) {
                    if (pendingTag != null) {
                        this.addTag(pendingTag);
                    }
                    pendingTag = new ASDocTag(tok.getText().substring(1));
                } else if (tok.getType() == 10 && pendingTag != null) {
                    pendingTag.setDescription(tok.getText());
                    this.addTag(pendingTag);
                    pendingTag = null;
                }
                foundDescription = true;
                tok = tokenizer.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTag(ASDocTag tag) {
        List<IASDocTag> list = this.tags.get(tag.getName());
        if (list == null) {
            list = new ArrayList<IASDocTag>();
            this.tags.put(tag.getName(), list);
        }
        list.add(tag);
    }

    public String toString() {
        return "ASASDocComment [description=" + this.description + "]";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean hasTag(String name) {
        List<IASDocTag> list = this.tags.get(name);
        return list != null && list.size() != 0;
    }

    @Override
    public IASDocTag getTag(String name) {
        List<IASDocTag> list = this.tags.get(name);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Map<String, List<IASDocTag>> getTags() {
        return this.tags;
    }

    public List<IASDocTag> getTagsByName(String name) {
        ArrayList<IASDocTag> result = new ArrayList<IASDocTag>();
        List<IASDocTag> list = this.tags.get(name);
        if (list == null) {
            return result;
        }
        for (IASDocTag tag : list) {
            result.add(tag);
        }
        return result;
    }

    @Override
    public void paste(IASDocComment source) {
        this.description = source.getDescription();
        if (source.hasTag("return")) {
            IASDocTag tag = source.getTag("return");
            this.addTag(new ASDocTag(tag.getName(), tag.getDescription()));
        }
        if (source.hasTag("param")) {
            Collection<IASDocTag> tags = source.getTagsByName("param");
            for (IASDocTag ptag : tags) {
                this.addTag(new ASDocTag(ptag.getName(), ptag.getDescription()));
            }
        }
    }

    class ASDocTag
    implements IASDocTag {
        private String name;
        private String description;

        public ASDocTag(String name) {
            if (name.indexOf(64) == 0) {
                name = name.substring(1);
            }
            this.setName(name);
        }

        public ASDocTag(String name, String description) {
            this(name);
            this.setDescription(description);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.equals("");
        }
    }
}

