/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.graph.IFlowgraph;
import org.apache.royale.abc.graph.algorithms.DepthFirstPreorderIterator;
import org.apache.royale.abc.graph.algorithms.DominatorTree;
import org.apache.royale.abc.semantics.Block;
import org.apache.royale.abc.semantics.ExceptionInfo;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.Label;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.visitors.IFlowGraphVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlFlowGraph
implements IFlowgraph {
    private final MethodBodyInfo mbi;
    private ArrayList<IBasicBlock> blocks = new ArrayList();
    private Block startBlock;
    private Map<Label, IBasicBlock> blocksByLabel = new HashMap<Label, IBasicBlock>();
    private ArrayList<IBasicBlock> catchTargets = new ArrayList();
    private DominatorTree dominatorTree = null;
    private static final Label END_OF_LABEL_SEQUENCE = new Label();

    ControlFlowGraph(MethodBodyInfo mbi) {
        this.mbi = mbi;
        this.startBlock = this.newBlock();
        this.buildCfg();
    }

    private void buildCfg() {
        Block current_block = this.startBlock;
        boolean last_block_transferred_control = false;
        Collections.sort(this.mbi.getInstructionList().getActiveLabels());
        Iterator<Label> labels = this.mbi.getInstructionList().getActiveLabels().iterator();
        Label next_label = this.getNextLabel(labels);
        HashMap successor_labels = new HashMap();
        ArrayList<Instruction> instructions = this.mbi.getInstructionList().getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            if (i == next_label.getPosition() || last_block_transferred_control) {
                if (current_block.size() > 0) {
                    Block prev_block = current_block;
                    current_block = this.newBlock();
                    if (prev_block.canFallThrough()) {
                        prev_block.addSuccessor(current_block);
                    }
                } else assert (current_block == this.startBlock);
                if (i == next_label.getPosition() && this.mbi.isCatchTarget(next_label)) {
                    this.catchTargets.add(current_block);
                }
                while (next_label.getPosition() == i) {
                    this.blocksByLabel.put(next_label, current_block);
                    next_label = this.getNextLabel(labels);
                }
            }
            Instruction insn = (Instruction)instructions.get(i);
            current_block.add(insn);
            last_block_transferred_control = insn.isTransferOfControl();
            if (!insn.isBranch()) continue;
            ArrayList<Label> successors = (ArrayList<Label>)successor_labels.get(current_block);
            if (successors == null) {
                successors = new ArrayList<Label>();
                successor_labels.put(current_block, successors);
            }
            if (insn.getOpcode() == 27) {
                for (int j = 0; j < insn.getOperandCount(); ++j) {
                    if (!(insn.getOperand(j) instanceof Label)) continue;
                    successors.add((Label)insn.getOperand(j));
                }
                continue;
            }
            successors.add(insn.getTarget());
        }
        for (Map.Entry entry : successor_labels.entrySet()) {
            for (Label target_label : (Collection)entry.getValue()) {
                IBasicBlock target_block = this.getBlock(target_label);
                if (target_block == null) continue;
                ((Block)entry.getKey()).addSuccessor(target_block);
            }
        }
    }

    @Override
    public IBasicBlock getBlock(Label l) {
        return this.blocksByLabel.get(l);
    }

    @Override
    public IBasicBlock getStartBlock() {
        return this.startBlock;
    }

    @Override
    public boolean isCatchTarget(IBasicBlock b) {
        return this.catchTargets.contains(b);
    }

    @Override
    public Iterable<IBasicBlock> blocksInControlFlowOrder() {
        return new Iterable<IBasicBlock>(){

            @Override
            public Iterator<IBasicBlock> iterator() {
                return new DepthFirstPreorderIterator(ControlFlowGraph.this.getRoots());
            }
        };
    }

    private Block newBlock() {
        Block result = new Block();
        this.blocks.add(result);
        return result;
    }

    private Label getNextLabel(Iterator<Label> labels) {
        if (labels.hasNext()) {
            return labels.next();
        }
        return END_OF_LABEL_SEQUENCE;
    }

    @Override
    public List<IBasicBlock> getBlocksInEntryOrder() {
        return Collections.unmodifiableList(this.blocks);
    }

    List<IBasicBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    public void traverseGraph(IFlowGraphVisitor visitor) {
        for (IBasicBlock b : this.blocksInControlFlowOrder()) {
            if (!visitor.visitBlock(b)) continue;
            for (Instruction i : b.getInstructions()) {
                visitor.visitInstruction(i);
            }
            visitor.visitEnd(b);
        }
    }

    @Override
    public DominatorTree getDominatorTree() {
        if (this.dominatorTree == null) {
            this.dominatorTree = new DominatorTree(this.getRoots());
        }
        return this.dominatorTree;
    }

    private Collection<IBasicBlock> getRoots() {
        ArrayList<IBasicBlock> roots = new ArrayList<IBasicBlock>();
        roots.add(this.startBlock);
        roots.addAll(this.catchTargets);
        return roots;
    }

    @Override
    public void removeUnreachableBlock(IBasicBlock b) {
        assert (!this.isReachable(b));
        boolean removedFormerlyReachable = false;
        for (ExceptionInfo ex : this.mbi.getExceptions()) {
            int bIdx;
            if (b.equals(this.getBlock(ex.getFrom()))) {
                if (b.equals(this.getBlock(ex.getTo()))) {
                    ex.setLive(false);
                    this.catchTargets.remove(this.getBlock(ex.getTarget()));
                    removedFormerlyReachable = true;
                    continue;
                }
                bIdx = this.blocks.indexOf(b);
                assert (bIdx >= 0 && bIdx < this.blocks.size());
                this.blocksByLabel.put(ex.getFrom(), this.blocks.get(bIdx + 1));
                continue;
            }
            if (!b.equals(this.getBlock(ex.getTo()))) continue;
            if (b.equals(this.getBlock(ex.getFrom()))) {
                ex.setLive(false);
                this.catchTargets.remove(this.getBlock(ex.getTarget()));
                removedFormerlyReachable = true;
                continue;
            }
            bIdx = this.blocks.indexOf(b);
            assert (bIdx >= 1 && bIdx < this.blocks.size());
            this.blocksByLabel.put(ex.getTo(), this.blocks.get(bIdx - 1));
        }
        if (removedFormerlyReachable) {
            this.dominatorTree = null;
        }
        this.blocks.remove(b);
    }

    @Override
    public boolean isReachable(IBasicBlock b) {
        return this.getDominatorTree().topologicalTraversal().contains(b);
    }

    @Override
    public int findLineNumber(IBasicBlock b) {
        return this.findLineNumber(b, 0, SearchDirection.Forward);
    }

    @Override
    public int findLineNumber(IBasicBlock b, int initialOffset) {
        return this.findLineNumber(b, b.size() - 1, SearchDirection.Backward);
    }

    private int findLineNumber(IBasicBlock b, int initialOffset, SearchDirection initialDirection) {
        assert (this.blocks.contains(b));
        Instruction result = this.searchBlock(b, 240, initialOffset, initialDirection);
        if (result != null) {
            return result.getImmediate() - 1;
        }
        for (int i = this.blocks.indexOf(b) - 1; i >= 0 && result == null; --i) {
            IBasicBlock candidate = this.blocks.get(i);
            result = this.searchBlock(candidate, 240, candidate.size() - 1, SearchDirection.Backward);
        }
        return result != null ? result.getImmediate() : -1;
    }

    @Override
    public String findSourcePath(IBasicBlock b) {
        return this.findSourcePath(b, 0, SearchDirection.Forward);
    }

    @Override
    public String findSourcePath(IBasicBlock b, int initialOffset) {
        return this.findSourcePath(b, initialOffset, SearchDirection.Backward);
    }

    private String findSourcePath(IBasicBlock b, int initialOffset, SearchDirection initialDirection) {
        assert (this.blocks.contains(b));
        Instruction result = this.searchBlock(b, 241, initialOffset, initialDirection);
        if (result == null) {
            for (int i = this.blocks.indexOf(b) - 1; i >= 0 && result == null; --i) {
                IBasicBlock candidate = this.blocks.get(i);
                result = this.searchBlock(candidate, 241, candidate.size() - 1, SearchDirection.Backward);
            }
        }
        if (result == null) {
            return null;
        }
        String debugFilename = result.getOperand(0).toString();
        char otherSeparator = File.separatorChar == '/' ? (char)'\\' : '/';
        debugFilename = debugFilename.replace(otherSeparator, File.separatorChar);
        return debugFilename.replace(';', File.separatorChar);
    }

    private Instruction searchBlock(IBasicBlock b, int opcode, int initialOffset, SearchDirection direction) {
        Instruction result = null;
        int blockSize = b.size();
        assert (initialOffset >= 0 && initialOffset < blockSize) : String.format("invalid initialOffset %d", initialOffset);
        int offset = initialOffset;
        while (result == null && offset >= 0 && offset < blockSize) {
            Instruction candidate = b.get(offset);
            if (candidate.getOpcode() == opcode) {
                result = candidate;
                continue;
            }
            if (direction == SearchDirection.Forward) {
                ++offset;
                continue;
            }
            --offset;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SearchDirection {
        Forward,
        Backward;

    }
}

