/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.models;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.graph.IFlowgraph;
import org.apache.royale.abc.models.FrameModelVisitor;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.Label;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.visitors.IDiagnosticsVisitor;
import org.apache.royale.abc.visitors.IFlowGraphVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameModelEncoder
implements IFlowGraphVisitor {
    private Set<IBasicBlock> visitedBlocks = new HashSet<IBasicBlock>();
    private final FrameModelVisitor<?> visitor;
    private final IFlowgraph cfg;
    private int instructionIndex = -1;

    public FrameModelEncoder(MethodBodyInfo mbi, FrameModelVisitor<?> visitor, IDiagnosticsVisitor diagnosticsVisitor) {
        this.cfg = mbi.getCfg();
        this.visitor = visitor;
    }

    @Override
    public boolean visitBlock(IBasicBlock b) {
        this.instructionIndex = 0;
        return this.visitedBlocks.add(b) && this.visitor.visitBlock(b);
    }

    public int getInstructionIndex() {
        return this.instructionIndex;
    }

    @Override
    public void visitInstruction(Instruction i) {
        switch (i.getOpcode()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                this.visitor.consumeValue(i, 2);
                this.visitor.branch(i, this.cfg.getBlock(i.getTarget()));
                break;
            }
            case 17: 
            case 18: {
                this.visitor.consumeValue(i, 1);
                this.visitor.branch(i, this.cfg.getBlock(i.getTarget()));
                break;
            }
            case 16: {
                this.visitor.branch(i, this.cfg.getBlock(i.getTarget()));
                break;
            }
            case 27: {
                this.visitor.consumeValue(i, 1);
                ArrayList<IBasicBlock> targets = new ArrayList<IBasicBlock>();
                for (int j = 0; j < i.getOperandCount(); ++j) {
                    if (!(i.getOperand(j) instanceof Label)) continue;
                    targets.add(this.cfg.getBlock((Label)i.getOperand(j)));
                }
                this.visitor.multiwayBranch(i, targets);
                break;
            }
            case 3: {
                this.visitor.consumeValue(i, 1);
                break;
            }
            case 72: {
                this.visitor.consumeValue(i, 1);
                break;
            }
            case 71: {
                this.visitor.noFrameEffect(i);
                break;
            }
            case 32: {
                this.visitor.produceValue(i);
                break;
            }
            case 33: {
                this.visitor.produceValue(i);
                break;
            }
            case 38: 
            case 39: {
                this.visitor.produceValue(i);
                break;
            }
            case 40: {
                this.visitor.produceValue(i);
                break;
            }
            case 36: 
            case 37: 
            case 45: {
                this.visitor.produceValue(i);
                break;
            }
            case 241: {
                this.visitor.noFrameEffect(i);
                break;
            }
            case 6: {
                this.visitor.noFrameEffect(i);
                break;
            }
            case 7: {
                this.visitor.consumeValue(i, 1);
                break;
            }
            case 44: {
                this.visitor.produceValue(i);
                break;
            }
            case 46: {
                this.visitor.produceValue(i);
                break;
            }
            case 47: {
                this.visitor.produceValue(i);
                break;
            }
            case 49: {
                this.visitor.produceValue(i);
                break;
            }
            case 212: {
                this.visitor.setlocal(i, 0);
                break;
            }
            case 213: {
                this.visitor.setlocal(i, 1);
                break;
            }
            case 214: {
                this.visitor.setlocal(i, 2);
                break;
            }
            case 215: {
                this.visitor.setlocal(i, 3);
                break;
            }
            case 99: {
                this.visitor.setlocal(i, i.getImmediate());
                break;
            }
            case 208: {
                this.visitor.getlocal(i, 0);
                break;
            }
            case 209: {
                this.visitor.getlocal(i, 1);
                break;
            }
            case 210: {
                this.visitor.getlocal(i, 2);
                break;
            }
            case 211: {
                this.visitor.getlocal(i, 3);
                break;
            }
            case 98: {
                this.visitor.getlocal(i, i.getImmediate());
                break;
            }
            case 8: {
                this.visitor.modifyLocal(i, i.getImmediate());
                break;
            }
            case 146: 
            case 148: 
            case 194: 
            case 195: {
                this.visitor.modifyLocal(i, i.getImmediate());
                break;
            }
            case 64: {
                this.visitor.produceValue(i);
                break;
            }
            case 96: {
                this.visitor.produceValue(i);
                break;
            }
            case 93: 
            case 94: {
                this.visitor.consumeAndProduceValue(i, this.runtimeNameAllowance(i.getOperand(0)));
                break;
            }
            case 88: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 95: {
                this.visitor.consumeAndProduceValue(i, this.runtimeNameAllowance(i.getOperand(0)));
                break;
            }
            case 97: 
            case 104: {
                this.visitor.consumeValue(i, 2 + this.runtimeNameAllowance(i.getOperand(0)));
                break;
            }
            case 102: {
                this.visitor.consumeAndProduceValue(i, 1 + this.runtimeNameAllowance(i.getOperand(0)));
                break;
            }
            case 89: {
                this.visitor.consumeAndProduceValue(i, 1 + this.runtimeNameAllowance(i.getOperand(0)));
                break;
            }
            case 120: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 106: {
                this.visitor.consumeAndProduceValue(i, 1 + this.runtimeNameAllowance(i.getOperand(0)));
                break;
            }
            case 134: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 135: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 128: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 118: 
            case 129: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 137: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 130: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 115: 
            case 131: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 116: 
            case 136: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 117: 
            case 132: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 122: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 133: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 178: {
                this.visitor.consumeAndProduceValue(i, 1 + this.runtimeNameAllowance(i.getOperand(0)));
                break;
            }
            case 179: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 119: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 68: {
                int argc = (Integer)i.getOperand(1);
                this.visitor.consumeAndProduceValue(i, argc + 1);
                break;
            }
            case 65: {
                this.visitor.consumeAndProduceValue(i, 2 + i.getImmediate());
                break;
            }
            case 66: {
                this.visitor.consumeAndProduceValue(i, 1 + i.getImmediate());
                break;
            }
            case 67: {
                this.visitor.consumeAndProduceValue(i, 1 + i.getImmediate());
                break;
            }
            case 70: 
            case 76: {
                this.visitor.consumeAndProduceValue(i, 1 + this.runtimeNameAllowance(i.getOperand(0)) + (Integer)i.getOperand(1));
                break;
            }
            case 79: {
                this.visitor.consumeValue(i, 1 + this.runtimeNameAllowance(i.getOperand(0)) + (Integer)i.getOperand(1));
                break;
            }
            case 74: {
                this.visitor.consumeAndProduceValue(i, 1 + this.runtimeNameAllowance(i.getOperand(0)) + (Integer)i.getOperand(1));
                break;
            }
            case 83: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 69: {
                this.visitor.consumeAndProduceValue(i, 1 + this.runtimeNameAllowance(i.getOperand(0)) + (Integer)i.getOperand(1));
                break;
            }
            case 78: {
                this.visitor.consumeValue(i, 1 + this.runtimeNameAllowance(i.getOperand(0)) + (Integer)i.getOperand(1));
                break;
            }
            case 4: {
                this.visitor.consumeAndProduceValue(i, 1 + this.runtimeNameAllowance(i.getOperand(0)));
                break;
            }
            case 5: {
                this.visitor.consumeValue(i, 2 + this.runtimeNameAllowance(i.getOperand(0)));
                break;
            }
            case 73: {
                this.visitor.consumeAndProduceValue(i, 1 + i.getImmediate());
                break;
            }
            case 85: {
                this.visitor.consumeAndProduceValue(i, 2 * i.getImmediate());
                break;
            }
            case 86: {
                this.visitor.consumeAndProduceValue(i, i.getImmediate());
                break;
            }
            case 28: 
            case 48: {
                this.visitor.moveValueToScopeStack(i);
                break;
            }
            case 87: {
                this.visitor.produceValue(i);
                break;
            }
            case 90: {
                this.visitor.produceValue(i);
                break;
            }
            case 29: {
                this.visitor.popscope(i);
                break;
            }
            case 101: {
                this.visitor.getScopeobject(i, i.getImmediate());
                break;
            }
            case 103: {
                this.visitor.getScopeobject(i, i.getImmediate());
                break;
            }
            case 100: {
                this.visitor.getScopeobject(i, 0);
                break;
            }
            case 110: {
                this.visitor.produceValue(i);
                break;
            }
            case 111: {
                this.visitor.consumeValue(i, 1);
                break;
            }
            case 108: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 109: {
                this.visitor.consumeValue(i, 2);
                break;
            }
            case 41: {
                this.visitor.consumeValue(i, 1);
                break;
            }
            case 42: {
                this.visitor.dup(i);
                break;
            }
            case 43: {
                this.visitor.swap(i);
                break;
            }
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 180: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 150: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 160: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 144: 
            case 145: 
            case 147: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 192: 
            case 193: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 197: 
            case 198: 
            case 199: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 196: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 168: 
            case 169: 
            case 170: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 165: 
            case 166: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 167: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 151: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 149: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 239: 
            case 240: 
            case 242: 
            case 243: {
                this.visitor.noFrameEffect(i);
                break;
            }
            case 30: 
            case 35: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 31: {
                this.visitor.consumeAndProduceValue(i, 2);
                break;
            }
            case 50: {
                this.visitor.hasnext2(i);
                this.visitor.produceValue(i);
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 56: 
            case 57: {
                this.visitor.consumeAndProduceValue(i, 1);
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.visitor.consumeValue(i, 2);
                break;
            }
            case 75: 
            case 77: 
            case 105: 
            case 107: {
                assert (false) : "internal only instruction:" + i;
                break;
            }
            default: {
                assert (false) : "unknown instruction:" + i;
                break;
            }
        }
        ++this.instructionIndex;
    }

    @Override
    public void visitEnd(IBasicBlock b) {
        for (IBasicBlock iBasicBlock : b.getSuccessors()) {
            this.visitor.visitEdge(b, iBasicBlock);
        }
        this.visitor.visitEndBlock(b);
    }

    private int runtimeNameAllowance(Object operand) {
        return operand instanceof Name ? ((Name)operand).runtimeNameAllowance() : 0;
    }
}

