/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.utils;

import com.google.common.base.Strings;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.BaseReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.MemberReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;
import org.apache.royale.compiler.internal.codegen.typedefs.utils.JSTypeUtils;

public class FunctionUtils {
    public static String toParameterType(BaseReference reference, String name) {
        String parameterType = FunctionUtils.hasTemplate(reference) && FunctionUtils.containsTemplate(reference, name) ? "Object" : JSTypeUtils.toParamTypeString(reference, name);
        return parameterType;
    }

    public static String toReturnString(BaseReference reference) {
        String returnType;
        StringBuilder sb = new StringBuilder();
        if (FunctionUtils.hasTemplate(reference)) {
            returnType = JSTypeUtils.toReturnTypeString(reference);
            if (FunctionUtils.containsTemplate(reference, returnType)) {
                returnType = "*";
            } else if (returnType.equals("RESULT")) {
                returnType = "Object";
            }
        } else {
            returnType = JSTypeUtils.toReturnTypeString(reference);
        }
        sb.append(returnType);
        return sb.toString();
    }

    public static String toParameterString(BaseReference reference, JSDocInfo comment, Node paramNode, boolean outputJS) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (paramNode != null) {
            int index = 0;
            int len = comment.getParameterCount();
            if (len == 0) {
                len = paramNode.getChildCount();
                if (len > 0) {
                    for (Node param : paramNode.children()) {
                        sb.append(param.getString());
                        if (!outputJS) {
                            sb.append(":Object");
                        }
                        if (index < len - 1) {
                            sb.append(", ");
                        }
                        ++index;
                    }
                }
            } else {
                for (String paramName : comment.getParameterNames()) {
                    sb.append(FunctionUtils.toParameter(reference, comment, paramName, comment.getParameterType(paramName), outputJS));
                    if (index < len - 1) {
                        sb.append(", ");
                    }
                    ++index;
                }
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static boolean canBeImported(ReferenceModel model, Node node, String typeName, String packageName) {
        boolean canImport = false;
        if (model != null && node != null && !Strings.isNullOrEmpty((String)typeName)) {
            ClassReference reference = new ClassReference(null, node, typeName);
            int lastDotPosition = typeName.lastIndexOf(".");
            canImport = lastDotPosition > -1 && !typeName.substring(0, lastDotPosition).equals(packageName);
            canImport &= model.isExcludedClass(reference) == null;
        }
        return canImport;
    }

    public static String toParameter(BaseReference reference, JSDocInfo comment, String paramName, JSTypeExpression parameterType, boolean outputJS) {
        StringBuilder sb = new StringBuilder();
        if (parameterType == null) {
            System.out.println("no parameter type for " + paramName + " " + reference.getQualifiedName());
            String paramType = "Object";
            if (outputJS) {
                sb.append(paramName);
            }
        } else if (parameterType.isVarArgs()) {
            if (outputJS) {
                sb.append("var_").append(paramName);
            } else {
                sb.append("...").append(paramName);
            }
        } else {
            String paramType = JSTypeUtils.toParamTypeString(reference, paramName);
            if (FunctionUtils.hasTemplate(reference) && FunctionUtils.containsTemplate(reference, paramType)) {
                paramType = "Object";
            }
            if (outputJS && parameterType.isOptionalArg()) {
                sb.append("opt_");
                sb.append(paramName);
            } else {
                sb.append(paramName);
            }
            if (!outputJS) {
                sb.append(":");
                sb.append(paramType);
                if (parameterType.isOptionalArg()) {
                    sb.append(" = ");
                    sb.append(FunctionUtils.toDefaultParameterValue(paramType));
                }
            }
        }
        return sb.toString();
    }

    private static String toDefaultParameterValue(String paramType) {
        if (paramType.equals("Function")) {
            return "null";
        }
        if (paramType.equals("Number")) {
            return "0";
        }
        if (paramType.equals("String")) {
            return "''";
        }
        if (paramType.equals("Boolean")) {
            return "false";
        }
        return "null";
    }

    public static boolean hasTemplate(BaseReference reference) {
        MemberReference memberRef;
        if (reference instanceof MemberReference && (memberRef = (MemberReference)reference).getClassReference().getComment().getTemplateTypeNames().size() > 0) {
            return true;
        }
        return reference.getComment().getTemplateTypeNames().size() > 0;
    }

    public static boolean containsTemplate(BaseReference reference, String name) {
        MemberReference memberRef;
        if (reference instanceof MemberReference && FunctionUtils.commentContainsTemplate((memberRef = (MemberReference)reference).getClassReference().getComment(), name)) {
            return true;
        }
        return FunctionUtils.commentContainsTemplate(reference.getComment(), name);
    }

    private static boolean commentContainsTemplate(JSDocInfo comment, String name) {
        for (String template : comment.getTemplateTypeNames()) {
            if (name.contains("<" + template + ">")) {
                return true;
            }
            if (!name.equals(template)) continue;
            return true;
        }
        return false;
    }
}

