/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.reference;

import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.MemberReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;
import org.apache.royale.compiler.internal.codegen.typedefs.utils.FunctionUtils;
import org.apache.royale.compiler.internal.codegen.typedefs.utils.JSTypeUtils;

public class FieldReference
extends MemberReference {
    private boolean isStatic;
    private boolean isConst;
    private String overrideStringType;
    private Node constantValueNode;

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setConst(boolean isConst) {
        this.isConst = isConst;
    }

    public void setOverrideStringType(String overrideStringType) {
        this.overrideStringType = overrideStringType;
    }

    public void setConstantValueNode(Node constantValueNode) {
        this.constantValueNode = constantValueNode;
    }

    public String toTypeAnnotationString() {
        JSType jsType = null;
        if (this.getComment() != null && this.getComment().getType() != null) {
            jsType = this.getModel().evaluate(this.getComment().getType());
        }
        return jsType != null ? jsType.toAnnotationString() : "Object";
    }

    public FieldReference(ReferenceModel model, ClassReference classReference, Node node, String name, JSDocInfo comment, boolean isStatic) {
        super(model, classReference, node, name, comment);
        this.isStatic = isStatic;
    }

    public void emit(StringBuilder sb) {
        if (this.getComment().isConstructor()) {
            return;
        }
        if (this.getQualifiedName().equals(this.getClassReference().getQualifiedName())) {
            return;
        }
        if (this.getClassReference().hasSuperField(this.getQualifiedName())) {
            return;
        }
        this.emitComment(sb);
        ExternCConfiguration.ExcludedMember excluded = this.isExcluded();
        if (excluded != null) {
            excluded.print(sb);
            return;
        }
        if (!(this.getClassReference().isInterface() || this.getComment().isOverride() || this.getClassReference().isPropertyInterfaceImplementation(this.getBaseName()))) {
            this.emitVar(sb);
        } else {
            this.emitAccessor(sb);
        }
    }

    private void emitAccessor(StringBuilder sb) {
        boolean isInterface = this.getClassReference().isInterface();
        String staticValue = this.isStatic ? "static " : "";
        String isPublic = isInterface ? "" : "public ";
        String getBody = isInterface ? "" : "{ return null; }";
        String setBody = isInterface ? "" : "{}";
        String type = this.toTypeString();
        if (type.contains("|") || type.contains("?")) {
            type = "*";
        }
        if (this.outputJS) {
            sb.append(this.getClassReference().getPackageName());
            sb.append(".");
            sb.append(this.getClassReference().getBaseName());
            sb.append(".");
            if (!this.isStatic) {
                sb.append("prototype.");
            }
            sb.append(this.getBaseName());
            sb.append(";\n");
            return;
        }
        sb.append(this.indent);
        sb.append(isPublic);
        sb.append(staticValue);
        sb.append("function get ");
        sb.append(this.getBaseName());
        sb.append("():");
        sb.append(type);
        sb.append(getBody);
        sb.append(";\n");
        sb.append(this.indent);
        sb.append(isPublic);
        sb.append(staticValue);
        sb.append("function set ");
        sb.append(this.getBaseName());
        sb.append("(value:");
        sb.append(type);
        sb.append("):void");
        sb.append(setBody);
        sb.append(";\n");
    }

    private void emitVar(StringBuilder sb) {
        String staticValue = this.isStatic ? "static " : "";
        String constVarValue = this.isConst ? "const " : "var ";
        String type = this.toTypeString();
        if (type.contains("|") || type.contains("?")) {
            type = "*";
        }
        if (this.outputJS) {
            sb.append(this.getClassReference().getPackageName());
            sb.append(".");
            sb.append(this.getClassReference().getBaseName());
            sb.append(".");
            if (!this.isStatic) {
                sb.append("prototype.");
            }
            sb.append(this.getBaseName());
            sb.append(";\n");
            return;
        }
        sb.append(this.indent);
        sb.append("public ");
        sb.append(staticValue);
        sb.append(constVarValue);
        sb.append(this.getQualifiedName());
        sb.append(":");
        sb.append(type);
        if (this.isConst) {
            this.emitConstValue(sb);
        }
        sb.append(";\n");
    }

    private void emitConstValue(StringBuilder sb) {
        sb.append(" = ");
        sb.append(this.toConstValue(this.constantValueNode));
    }

    private String toConstValue(Node node) {
        if (this.toTypeString().equals("Number")) {
            return Integer.toString(this.getClassReference().getEnumConstant());
        }
        if (node.isString()) {
            return "'" + node.getString() + "'";
        }
        return "undefined /* TODO type not set */";
    }

    public String toTypeString() {
        if (this.overrideStringType != null) {
            return this.overrideStringType;
        }
        String typeString = JSTypeUtils.toFieldTypeString(this);
        if (FunctionUtils.hasTemplate(this) && FunctionUtils.containsTemplate(this, typeString)) {
            return "Object";
        }
        return typeString;
    }

    protected void emitCommentBody(StringBuilder sb) {
        this.emitBlockDescription(sb);
        this.emitType(sb);
        this.emitSee(sb);
        this.emitSeeSourceFileName(sb);
    }

    private void emitType(StringBuilder sb) {
        JSTypeExpression type = this.getComment().getType();
        if (type != null) {
            if (this.outputJS) {
                sb.append(this.indent);
                sb.append(" * @type ");
                sb.append("{");
                sb.append(this.mapBackToJS(this.getModel().evaluate(type).toAnnotationString(), false));
                sb.append("} ");
                sb.append("\n");
            } else {
                sb.append(this.indent);
                sb.append(" * @see JSType - ");
                sb.append("[");
                sb.append(this.getModel().evaluate(type).toAnnotationString());
                sb.append("] ");
                String description = this.getComment().getReturnDescription();
                if (description != null) {
                    sb.append(description);
                }
                sb.append("\n");
            }
        }
    }
}

