/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.node;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.internal.codegen.js.jsc.JSCPublisher;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodePublisher
extends JSCPublisher {
    public boolean exportModule = false;

    public NodePublisher(Configuration config, RoyaleJSProject project) {
        super(project, config);
    }

    @Override
    protected String getTemplateDependencies(String type, String projectName, String deps) {
        StringBuilder depsJS = new StringBuilder();
        if ("intermediate".equals(type)) {
            depsJS.append("require(\"./library/closure/goog/bootstrap/nodejs\");\n");
            depsJS.append(deps);
            depsJS.append("goog.require(\"");
            depsJS.append(projectName);
            depsJS.append("\");\n");
        } else {
            depsJS.append("var ");
            depsJS.append(projectName);
            depsJS.append(" = require(\"./");
            depsJS.append(projectName);
            depsJS.append("\").");
            depsJS.append(projectName);
            depsJS.append(";\n");
        }
        return depsJS.toString();
    }

    @Override
    protected String getTemplateBody(String projectName) {
        StringBuilder bodyJS = new StringBuilder();
        if (this.exportModule) {
            bodyJS.append("module.exports = ");
            bodyJS.append(projectName);
            bodyJS.append(";");
        } else {
            bodyJS.append("new ");
            bodyJS.append(projectName);
            bodyJS.append("();");
        }
        return bodyJS.toString();
    }

    @Override
    protected void writeHTML(String type, String projectName, File targetDir, String deps, List<String> additionalHTML) throws IOException {
        StringBuilder contents = new StringBuilder();
        contents.append(this.getTemplateDependencies(type, projectName, deps));
        contents.append(this.getTemplateBody(projectName));
        this.writeFile(new File(targetDir, "index.js"), contents.toString(), false);
    }
}

