/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.royale;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FilterWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.royale.compiler.codegen.js.goog.IJSGoogDocEmitter;
import org.apache.royale.compiler.codegen.js.royale.IJSRoyaleEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.definitions.references.INamespaceResolvedReference;
import org.apache.royale.compiler.embedding.EmbedAttribute;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.jx.AccessorEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.AsIsEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.BinaryOperatorEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ClassEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.DefinePropertyFunctionEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.FieldEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ForEachEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.FunctionCallEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.IdentifierEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.InterfaceEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.LiteralEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.MemberAccessEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.MethodEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ObjectDefinePropertyEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.PackageFooterEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.PackageHeaderEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.SelfReferenceEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.SuperCallEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.VarDeclarationEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLRoyaleEmitter;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.embedding.EmbedMIMEType;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAsNode;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LabeledStatementNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NumericLiteralNode;
import org.apache.royale.compiler.problems.EmbedUnableToReadSourceProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IEmbedNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IFunctionObjectNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.ISetterNode;
import org.apache.royale.compiler.tree.as.ITypedExpressionNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.utils.ASNodeUtils;
import org.apache.royale.compiler.utils.NativeUtils;
import org.apache.royale.utils.FilenameNormalization;

public class JSRoyaleEmitter
extends JSGoogEmitter
implements IJSRoyaleEmitter {
    private JSRoyaleDocEmitter docEmitter = null;
    private PackageHeaderEmitter packageHeaderEmitter;
    public PackageFooterEmitter packageFooterEmitter;
    private BindableEmitter bindableEmitter;
    private ClassEmitter classEmitter;
    private InterfaceEmitter interfaceEmitter;
    private FieldEmitter fieldEmitter;
    public VarDeclarationEmitter varDeclarationEmitter;
    public AccessorEmitter accessorEmitter;
    public MethodEmitter methodEmitter;
    private FunctionCallEmitter functionCallEmitter;
    private SuperCallEmitter superCallEmitter;
    private ForEachEmitter forEachEmitter;
    private MemberAccessEmitter memberAccessEmitter;
    private BinaryOperatorEmitter binaryOperatorEmitter;
    private IdentifierEmitter identifierEmitter;
    private LiteralEmitter literalEmitter;
    private AsIsEmitter asIsEmitter;
    private SelfReferenceEmitter selfReferenceEmitter;
    private ObjectDefinePropertyEmitter objectDefinePropertyEmitter;
    private DefinePropertyFunctionEmitter definePropertyFunctionEmitter;
    public ArrayList<String> usedNames = new ArrayList();
    public ArrayList<String> staticUsedNames = new ArrayList();
    private boolean needNamespace;
    public MXMLRoyaleEmitter mxmlEmitter = null;

    public String postProcess(String output) {
        output = super.postProcess(output);
        String[] lines = output.split("\n");
        ArrayList<String> finalLines = new ArrayList<String>();
        boolean foundLanguage = false;
        boolean foundXML = false;
        boolean foundNamespace = false;
        boolean sawRequires = false;
        boolean stillSearching = true;
        int addIndex = -1;
        int provideIndex = -1;
        int len = lines.length;
        for (int i = 0; i < len; ++i) {
            String line = lines[i];
            if (stillSearching) {
                int c = line.indexOf(JSGoogEmitterTokens.GOOG_PROVIDE.getToken());
                if (c != -1) {
                    provideIndex = addIndex = i + 1;
                }
                if ((c = line.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken())) != -1) {
                    addIndex = -1;
                    int c2 = line.indexOf(")");
                    String s = line.substring(c + 14, c2 - 1);
                    if (s.equals(JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken())) {
                        foundLanguage = true;
                    } else if (s.equals("XML")) {
                        foundXML = true;
                    } else if (s.equals("Namespace")) {
                        foundNamespace = true;
                    }
                    sawRequires = true;
                } else if (sawRequires || i == len - 1) {
                    stillSearching = false;
                    ICompilerProject project = this.getWalker().getProject();
                    if (project instanceof RoyaleJSProject) {
                        StringBuilder appendString;
                        boolean needXML;
                        RoyaleJSProject royaleProject = (RoyaleJSProject)project;
                        boolean needLanguage = this.getModel().needLanguage;
                        if (needLanguage && !foundLanguage) {
                            StringBuilder appendString2 = new StringBuilder();
                            appendString2.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                            appendString2.append(ASEmitterTokens.PAREN_OPEN.getToken());
                            appendString2.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString2.append(JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken());
                            appendString2.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString2.append(ASEmitterTokens.PAREN_CLOSE.getToken());
                            appendString2.append(ASEmitterTokens.SEMICOLON.getToken());
                            if (addIndex != -1) {
                                finalLines.add(addIndex, appendString2.toString());
                                this.addLineToMappings(addIndex);
                            } else {
                                finalLines.add(appendString2.toString());
                                this.addLineToMappings(i);
                            }
                        }
                        if ((needXML = royaleProject.needXML) && !foundXML) {
                            appendString = new StringBuilder();
                            appendString.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_OPEN.getToken());
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append("XML");
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_CLOSE.getToken());
                            appendString.append(ASEmitterTokens.SEMICOLON.getToken());
                            if (addIndex != -1) {
                                finalLines.add(addIndex, appendString.toString());
                                this.addLineToMappings(addIndex);
                            } else {
                                finalLines.add(appendString.toString());
                                this.addLineToMappings(i);
                            }
                        }
                        if (this.needNamespace && !foundNamespace) {
                            appendString = new StringBuilder();
                            appendString.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_OPEN.getToken());
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append("Namespace");
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_CLOSE.getToken());
                            appendString.append(ASEmitterTokens.SEMICOLON.getToken());
                            if (addIndex != -1) {
                                finalLines.add(addIndex, appendString.toString());
                                this.addLineToMappings(addIndex);
                            } else {
                                finalLines.add(appendString.toString());
                                this.addLineToMappings(i);
                            }
                        }
                    }
                }
            }
            finalLines.add(line);
        }
        if (this.staticUsedNames.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(JSGoogEmitterTokens.ROYALE_STATIC_DEPENDENCY_LIST.getToken());
            boolean firstDependency = true;
            for (String staticName : this.staticUsedNames) {
                if (!firstDependency) {
                    sb.append(",");
                }
                firstDependency = false;
                sb.append(staticName);
            }
            sb.append("*/");
            finalLines.add(provideIndex, sb.toString());
        }
        return Joiner.on("\n").join(finalLines);
    }

    public BindableEmitter getBindableEmitter() {
        return this.bindableEmitter;
    }

    public FieldEmitter getFieldEmitter() {
        return this.fieldEmitter;
    }

    public ClassEmitter getClassEmitter() {
        return this.classEmitter;
    }

    public AccessorEmitter getAccessorEmitter() {
        return this.accessorEmitter;
    }

    public PackageFooterEmitter getPackageFooterEmitter() {
        return this.packageFooterEmitter;
    }

    public IJSGoogDocEmitter getDocEmitter() {
        if (this.docEmitter == null) {
            this.docEmitter = new JSRoyaleDocEmitter(this);
        }
        return this.docEmitter;
    }

    public JSRoyaleEmitter(FilterWriter out) {
        super(out);
        this.packageHeaderEmitter = new PackageHeaderEmitter(this);
        this.packageFooterEmitter = new PackageFooterEmitter(this);
        this.bindableEmitter = new BindableEmitter(this);
        this.classEmitter = new ClassEmitter(this);
        this.interfaceEmitter = new InterfaceEmitter(this);
        this.fieldEmitter = new FieldEmitter(this);
        this.varDeclarationEmitter = new VarDeclarationEmitter(this);
        this.accessorEmitter = new AccessorEmitter(this);
        this.methodEmitter = new MethodEmitter(this);
        this.functionCallEmitter = new FunctionCallEmitter(this);
        this.superCallEmitter = new SuperCallEmitter(this);
        this.forEachEmitter = new ForEachEmitter(this);
        this.memberAccessEmitter = new MemberAccessEmitter(this);
        this.binaryOperatorEmitter = new BinaryOperatorEmitter(this);
        this.identifierEmitter = new IdentifierEmitter(this);
        this.literalEmitter = new LiteralEmitter(this);
        this.asIsEmitter = new AsIsEmitter(this);
        this.selfReferenceEmitter = new SelfReferenceEmitter(this);
        this.objectDefinePropertyEmitter = new ObjectDefinePropertyEmitter(this);
        this.definePropertyFunctionEmitter = new DefinePropertyFunctionEmitter(this);
    }

    protected void writeIndent() {
        this.write(JSRoyaleEmitterTokens.INDENT);
    }

    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(JSRoyaleEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    public void emitLocalNamedFunction(IFunctionNode node) {
        IFunctionNode fnNode = (IFunctionNode)node.getAncestorOfType(IFunctionNode.class);
        if (fnNode.getEmittingLocalFunctions()) {
            super.emitLocalNamedFunction(node);
        }
    }

    public void emitFunctionBlockHeader(IFunctionNode node) {
        node.setEmittingLocalFunctions(true);
        super.emitFunctionBlockHeader(node);
        if (node.isConstructor()) {
            IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
            if (cnode.getDefinition().needsEventDispatcher(this.getWalker().getProject())) {
                if (this.getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.IMPLEMENTS) {
                    this.bindableEmitter.emitBindableImplementsConstructorCode();
                } else if (this.getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.EXTENDS) {
                    this.bindableEmitter.emitBindableExtendsConstructorCode(cnode.getDefinition().getQualifiedName(), false);
                }
            }
            this.emitComplexInitializers(cnode);
        }
        if (node.containsLocalFunctions()) {
            List anonFns = node.getLocalFunctions();
            int n = anonFns.size();
            for (int i = 0; i < n; ++i) {
                IFunctionNode anonFn = (IFunctionNode)anonFns.get(i);
                if (anonFn.getParent().getNodeID() == ASTNodeID.AnonymousFunctionID) {
                    this.write("var /** @type {Function} */ __localFn" + Integer.toString(i) + "__ = ");
                    this.getWalker().walk(anonFn.getParent());
                } else {
                    this.getWalker().walk((IASNode)anonFn);
                    this.write(ASEmitterTokens.SEMICOLON);
                }
                this.writeNewline();
            }
        }
        node.setEmittingLocalFunctions(false);
    }

    public void emitFunctionObject(IFunctionObjectNode node) {
        IFunctionNode fnNode = (IFunctionNode)node.getAncestorOfType(IFunctionNode.class);
        if (fnNode == null || fnNode.getEmittingLocalFunctions()) {
            super.emitFunctionObject(node);
        } else {
            List anonFns = fnNode.getLocalFunctions();
            int i = anonFns.indexOf(node.getFunctionNode());
            if (i < 0) {
                System.out.println("missing index for " + node.toString());
            } else {
                this.write("__localFn" + Integer.toString(i) + "__");
            }
        }
    }

    public void emitNamespace(INamespaceNode node) {
        this.needNamespace = true;
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.writeToken(ASEmitterTokens.NEW);
        this.write("Namespace");
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk((IASNode)node.getNamespaceURINode());
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
    }

    public boolean isCustomNamespace(FunctionNode node) {
        String nsName;
        INamespaceDecorationNode ns = node.getActualNamespaceNode();
        return ns != null && (nsName = node.getNamespace()) != "private" && nsName != "protected" && nsName != "internal" && nsName != "http://adobe.com/AS3/2006/builtin" && nsName != "public";
    }

    public boolean isCustomNamespace(FunctionDefinition def) {
        INamespaceDefinition nsDef = def.getNamespaceReference().resolveNamespaceReference(this.getWalker().getProject());
        String uri = nsDef.getURI();
        return !def.getNamespaceReference().isLanguageNamespace() && !uri.equals("http://adobe.com/AS3/2006/builtin") && !nsDef.getBaseName().equals(ASEmitterTokens.PRIVATE.getToken());
    }

    public void emitMemberName(IDefinitionNode node) {
        FunctionNode fn;
        if (node.getNodeID() == ASTNodeID.FunctionID && this.isCustomNamespace(fn = (FunctionNode)node)) {
            INamespaceDecorationNode ns = ((FunctionNode)node).getActualNamespaceNode();
            ICompilerProject project = this.getWalker().getProject();
            INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(project);
            this.formatQualifiedName(nsDef.getQualifiedName());
            String s = nsDef.getURI();
            this.write("[\"" + s + "::" + node.getName() + "\"]");
            return;
        }
        this.write(node.getName());
    }

    public String formatQualifiedName(String name) {
        return this.formatQualifiedName(name, false);
    }

    public String formatQualifiedName(String name, boolean isDoc) {
        if (this.mxmlEmitter != null) {
            name = this.mxmlEmitter.formatQualifiedName(name);
        }
        if (this.getModel().isInternalClass(name)) {
            return this.getModel().getInternalClasses().get(name);
        }
        if (NativeUtils.isJSNative(name)) {
            return name;
        }
        if (name.startsWith("window.")) {
            name = name.substring(7);
        } else if (!isDoc) {
            if (this.getModel().inStaticInitializer && !this.staticUsedNames.contains(name) && !NativeUtils.isJSNative(name)) {
                this.staticUsedNames.add(name);
            }
            if (!this.usedNames.contains(name) && !this.isExternal(name)) {
                this.usedNames.add(name);
            }
        }
        return name;
    }

    public String convertASTypeToJS(String name) {
        String result = name;
        if (name.equals("")) {
            result = "Object";
        } else if (name.equals("Class")) {
            result = "Object";
        } else if (name.equals("int") || name.equals("uint")) {
            result = "Number";
        }
        boolean isBuiltinFunction = name.matches("Vector\\.<.*>");
        if (isBuiltinFunction) {
            result = "Array";
        }
        return result;
    }

    public void emitPackageHeader(IPackageDefinition definition) {
        IPackageNode packageNode = definition.getNode();
        IFileNode fileNode = (IFileNode)packageNode.getAncestorOfType(IFileNode.class);
        int nodeCount = fileNode.getChildCount();
        String mainClassName = null;
        block0: for (int i = 0; i < nodeCount; ++i) {
            String className;
            IASNode pnode = fileNode.getChild(i);
            if (pnode instanceof IPackageNode) {
                IScopedNode snode = ((IPackageNode)pnode).getScopedNode();
                int snodeCount = snode.getChildCount();
                for (int j = 0; j < snodeCount; ++j) {
                    IASNode cnode = snode.getChild(j);
                    if (cnode instanceof IClassNode) {
                        mainClassName = ((IClassNode)cnode).getQualifiedName();
                        continue block0;
                    }
                    if (j != 0) continue;
                    if (cnode instanceof IFunctionNode) {
                        mainClassName = ((IFunctionNode)cnode).getQualifiedName();
                        continue;
                    }
                    if (cnode instanceof INamespaceNode) {
                        mainClassName = ((INamespaceNode)cnode).getQualifiedName();
                        continue;
                    }
                    if (!(cnode instanceof IVariableNode)) continue;
                    mainClassName = ((IVariableNode)cnode).getQualifiedName();
                }
                continue;
            }
            if (pnode instanceof IClassNode) {
                className = ((IClassNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                continue;
            }
            if (pnode instanceof IInterfaceNode) {
                className = ((IInterfaceNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                continue;
            }
            if (pnode instanceof IFunctionNode) {
                className = ((IFunctionNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                continue;
            }
            if (pnode instanceof INamespaceNode) {
                className = ((INamespaceNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                continue;
            }
            if (!(pnode instanceof IVariableNode)) continue;
            className = ((IVariableNode)pnode).getQualifiedName();
            this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
        }
        this.packageHeaderEmitter.emit(definition);
    }

    public void emitPackageHeaderContents(IPackageDefinition definition) {
        this.packageHeaderEmitter.emitContents(definition);
        this.usedNames.clear();
    }

    public void emitPackageFooter(IPackageDefinition definition) {
        this.packageFooterEmitter.emit(definition);
    }

    public void emitClass(IClassNode node) {
        this.classEmitter.emit(node);
    }

    public void emitInterface(IInterfaceNode node) {
        this.interfaceEmitter.emit(node);
    }

    public void emitField(IVariableNode node) {
        this.fieldEmitter.emit(node);
    }

    public void emitVarDeclaration(IVariableNode node) {
        this.varDeclarationEmitter.emit(node);
    }

    public void emitAccessors(IAccessorNode node) {
        this.accessorEmitter.emit(node);
    }

    public void emitGetAccessor(IGetterNode node) {
        this.accessorEmitter.emitGet(node);
    }

    public void emitSetAccessor(ISetterNode node) {
        this.accessorEmitter.emitSet(node);
    }

    public void emitMethod(IFunctionNode node) {
        this.methodEmitter.emit(node);
    }

    public void emitComplexInitializers(IClassNode node) {
        this.classEmitter.emitComplexInitializers(node);
    }

    public void emitFunctionCall(IFunctionCallNode node) {
        this.functionCallEmitter.emit(node);
    }

    public void emitForEachLoop(IForLoopNode node) {
        this.forEachEmitter.emit(node);
    }

    public void emitSuperCall(IASNode node, String type) {
        this.superCallEmitter.emit(node, type);
    }

    public void emitMemberAccessExpression(IMemberAccessExpressionNode node) {
        this.memberAccessEmitter.emit(node);
    }

    public void emitArguments(IContainerNode node) {
        IDefinition def;
        IExpressionNode nameNode;
        IFunctionCallNode fcNode;
        ICompilerProject project;
        IContainerNode newNode = node;
        int len = node.getChildCount();
        if (len == 2) {
            project = this.getWalker().getProject();
            fcNode = (IFunctionCallNode)node.getParent();
            nameNode = fcNode.getNameNode();
            def = nameNode.resolve(project);
            if (def != null && def.getBaseName().equals("insertAt") && def.getParent() != null && def.getParent().getQualifiedName().equals("Array") && nameNode instanceof MemberAccessExpressionNode) {
                newNode = EmitterUtils.insertArgumentsAt(node, 1, new IASNode[]{new NumericLiteralNode("0")});
            }
        }
        if (len == 1) {
            IDefinition parentDef;
            project = this.getWalker().getProject();
            fcNode = (IFunctionCallNode)node.getParent();
            nameNode = fcNode.getNameNode();
            def = nameNode.resolve(project);
            if (def != null && def.getBaseName().equals("removeAt")) {
                if (def.getParent() != null && def.getParent().getQualifiedName().equals("Array") && nameNode instanceof MemberAccessExpressionNode) {
                    newNode = EmitterUtils.insertArgumentsAfter(node, new IASNode[]{new NumericLiteralNode("1")});
                }
            } else if (def != null && def.getBaseName().equals("parseInt") && (parentDef = def.getParent()) == null && nameNode instanceof IdentifierNode) {
                NumericLiteralNode appendedArgument = new NumericLiteralNode("undefined");
                appendedArgument.setSynthetic(true);
                newNode = EmitterUtils.insertArgumentsAfter(node, new IASNode[]{appendedArgument});
            }
        }
        super.emitArguments(newNode);
    }

    public void emitE4XFilter(IMemberAccessExpressionNode node) {
        this.getModel().inE4xFilter = true;
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        this.write(".filter(function(node){return (node.");
        String s = this.stringifyNode((IASNode)node.getRightOperandNode());
        if (s.startsWith("(") && s.endsWith(")")) {
            s = s.substring(1, s.length() - 1);
        }
        this.write(s);
        this.write(")})");
        this.getModel().inE4xFilter = false;
    }

    public void emitBinaryOperator(IBinaryOperatorNode node) {
        this.binaryOperatorEmitter.emit(node);
    }

    public void emitIdentifier(IIdentifierNode node) {
        this.identifierEmitter.emit(node);
    }

    public void emitLiteral(ILiteralNode node) {
        this.literalEmitter.emit(node);
    }

    public void emitEmbed(IEmbedNode node) {
        EmbedData data = new EmbedData(node.getParent().getSourcePath(), null);
        boolean hadError = false;
        for (IMetaTagAttribute attribute : node.getAttributes()) {
            String key = attribute.getKey();
            String value = attribute.getValue();
            if (!data.addAttribute((ICompilerProject)((CompilerProject)this.project), (ISourceLocation)node.getParent(), key, value, this.getProblems())) continue;
            hadError = true;
        }
        if (hadError) {
            this.write("");
            return;
        }
        String source = (String)data.getAttribute(EmbedAttribute.SOURCE);
        EmbedMIMEType mimeType = (EmbedMIMEType)data.getAttribute(EmbedAttribute.MIME_TYPE);
        if (mimeType != null && mimeType.toString().equals(EmbedMIMEType.TEXT.toString()) && source != null) {
            File file = new File(FilenameNormalization.normalize((String)source));
            try {
                String newlineReplacement = "\\\\n";
                String s = FileUtils.readFileToString(file);
                s = s.replaceAll("\n", "__NEWLINE_PLACEHOLDER__");
                s = s.replaceAll("\r", "__CR_PLACEHOLDER__");
                s = s.replaceAll("\t", "__TAB_PLACEHOLDER__");
                s = s.replaceAll("\f", "__FORMFEED_PLACEHOLDER__");
                s = s.replaceAll("\b", "__BACKSPACE_PLACEHOLDER__");
                s = s.replaceAll("\\\\", "__ESCAPE_PLACEHOLDER__");
                s = s.replaceAll("\\\\\"", "__QUOTE_PLACEHOLDER__");
                s = s.replaceAll("\"", "\\\\\"");
                s = s.replaceAll("__QUOTE_PLACEHOLDER__", "\\\\\"");
                s = s.replaceAll("__ESCAPE_PLACEHOLDER__", "\\\\\\\\");
                s = s.replaceAll("__BACKSPACE_PLACEHOLDER__", "\\\\b");
                s = s.replaceAll("__FORMFEED_PLACEHOLDER__", "\\\\f");
                s = s.replaceAll("__TAB_PLACEHOLDER__", "\\\\t");
                s = s.replaceAll("__CR_PLACEHOLDER__", "\\\\r");
                s = s.replaceAll("__NEWLINE_PLACEHOLDER__", newlineReplacement);
                this.write("\"" + s + "\"");
            }
            catch (IOException e) {
                this.getProblems().add((ICompilerProblem)new EmbedUnableToReadSourceProblem((Exception)e, file.getPath()));
            }
        }
    }

    public void emitIsAs(IExpressionNode node, IExpressionNode left, IExpressionNode right, ASTNodeID id, boolean coercion) {
        this.asIsEmitter.emitIsAs(node, left, right, id, coercion);
    }

    protected void emitSelfReference(IFunctionNode node) {
        this.selfReferenceEmitter.emit(node);
    }

    protected void emitObjectDefineProperty(IAccessorNode node) {
        this.objectDefinePropertyEmitter.emit(node);
    }

    public void emitDefinePropertyFunction(IAccessorNode node) {
        this.definePropertyFunctionEmitter.emit(node);
    }

    public String stringifyDefineProperties(IClassDefinition cdef) {
        this.setBufferWrite(true);
        this.accessorEmitter.emit(cdef);
        String result = this.getBuilder().toString();
        this.getBuilder().setLength(0);
        this.setBufferWrite(false);
        return result;
    }

    public void emitClosureStart() {
        ICompilerProject project = this.getWalker().getProject();
        if (project instanceof RoyaleJSProject) {
            ((RoyaleJSProject)project).needLanguage = true;
        }
        this.getModel().needLanguage = true;
        this.write(JSRoyaleEmitterTokens.CLOSURE_FUNCTION_NAME);
        this.write(ASEmitterTokens.PAREN_OPEN);
    }

    public void emitClosureEnd(IASNode node, IDefinition nodeDef) {
        this.write(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        if (node.getNodeID() == ASTNodeID.IdentifierID) {
            if (nodeDef instanceof FunctionDefinition && this.isCustomNamespace((FunctionDefinition)nodeDef)) {
                String ns = ((INamespaceResolvedReference)((FunctionDefinition)nodeDef).getNamespaceReference()).resolveAETNamespace(this.getWalker().getProject()).getName();
                this.write(ns + "::");
            }
            this.write(((IIdentifierNode)node).getName());
        } else if (node.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            this.writeChainName(node);
        } else {
            System.out.println("unexpected node in emitClosureEnd");
        }
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    public void emitStatement(IASNode node) {
        if (node.getNodeID() == ASTNodeID.FunctionID) {
            return;
        }
        super.emitStatement(node);
    }

    private void writeChainName(IASNode node) {
        while (node.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            node = ((IMemberAccessExpressionNode)node).getRightOperandNode();
        }
        if (node.getNodeID() == ASTNodeID.IdentifierID) {
            this.write(((IdentifierNode)node).getName());
        } else {
            System.out.println("unexpected node in emitClosureEnd");
        }
    }

    public void emitUnaryOperator(IUnaryOperatorNode node) {
        if (node.getNodeID() == ASTNodeID.Op_DeleteID) {
            MemberAccessExpressionNode obj;
            if (node.getChild(0).getNodeID() == ASTNodeID.ArrayIndexExpressionID) {
                if (node.getChild(0).getChild(0).getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                    MemberAccessExpressionNode obj2 = (MemberAccessExpressionNode)node.getChild(0).getChild(0);
                    if (this.isXMLList(obj2)) {
                        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_OPEN);
                        }
                        this.getWalker().walk((IASNode)obj2);
                        DynamicAccessNode dan = (DynamicAccessNode)node.getChild(0);
                        IASNode indexNode = dan.getChild(1);
                        this.write(".removeChildAt(");
                        this.getWalker().walk(indexNode);
                        this.write(")");
                        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                        }
                        return;
                    }
                } else if (node.getChild(0).getChild(0).getNodeID() == ASTNodeID.IdentifierID) {
                    if (this.isXML((IExpressionNode)((IdentifierNode)node.getChild(0).getChild(0)))) {
                        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_OPEN);
                        }
                        this.getWalker().walk(node.getChild(0).getChild(0));
                        DynamicAccessNode dan = (DynamicAccessNode)node.getChild(0);
                        IASNode indexNode = dan.getChild(1);
                        this.write(".removeChild(");
                        this.getWalker().walk(indexNode);
                        this.write(")");
                        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                        }
                        return;
                    }
                    if (this.isProxy((IExpressionNode)((IdentifierNode)node.getChild(0).getChild(0)))) {
                        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_OPEN);
                        }
                        this.getWalker().walk(node.getChild(0).getChild(0));
                        DynamicAccessNode dan = (DynamicAccessNode)node.getChild(0);
                        IASNode indexNode = dan.getChild(1);
                        this.write(".deleteProperty(");
                        this.getWalker().walk(indexNode);
                        this.write(")");
                        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                        }
                        return;
                    }
                }
            } else if (node.getChild(0).getNodeID() == ASTNodeID.MemberAccessExpressionID && this.isXMLList(obj = (MemberAccessExpressionNode)node.getChild(0))) {
                if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                    this.write(ASEmitterTokens.PAREN_OPEN);
                }
                String s = this.stringifyNode((IASNode)obj.getLeftOperandNode());
                this.write(s);
                this.write(".removeChild('");
                s = this.stringifyNode((IASNode)obj.getRightOperandNode());
                this.write(s);
                this.write("')");
                if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                }
                return;
            }
        } else if (node.getNodeID() == ASTNodeID.Op_AtID) {
            IExpressionNode op = node.getOperandNode();
            if (op != null) {
                this.write("attribute('");
                this.getWalker().walk((IASNode)node.getOperandNode());
                this.write("')");
            } else if (node.getParent().getNodeID() == ASTNodeID.ArrayIndexExpressionID) {
                DynamicAccessNode parentNode = (DynamicAccessNode)node.getParent();
                this.write("attribute(");
                this.getWalker().walk((IASNode)parentNode.getRightOperandNode());
                this.write(")");
            }
            return;
        }
        super.emitUnaryOperator(node);
    }

    public boolean isXMLList(MemberAccessExpressionNode obj) {
        IExpressionNode leftNode = obj.getLeftOperandNode();
        IExpressionNode rightNode = obj.getRightOperandNode();
        ASTNodeID rightID = rightNode.getNodeID();
        if (rightID == ASTNodeID.IdentifierID) {
            ITypeDefinition rightDef = rightNode.resolveType(this.getWalker().getProject());
            if (rightDef != null) {
                if (IdentifierNode.isXMLish((IDefinition)rightDef, (ICompilerProject)this.getWalker().getProject())) {
                    return this.isLeftNodeXMLish(leftNode);
                }
                return false;
            }
            return this.isLeftNodeXMLish(leftNode);
        }
        return rightID == ASTNodeID.Op_AtID;
    }

    public boolean isLeftNodeXMLish(IExpressionNode leftNode) {
        ASTNodeID leftID = leftNode.getNodeID();
        if (leftID == ASTNodeID.IdentifierID) {
            ITypeDefinition leftDef = leftNode.resolveType(this.getWalker().getProject());
            if (leftDef != null) {
                return IdentifierNode.isXMLish((IDefinition)leftDef, (ICompilerProject)this.getWalker().getProject());
            }
        } else {
            if (leftID == ASTNodeID.MemberAccessExpressionID) {
                ITypeDefinition rightDef;
                MemberAccessExpressionNode maen = (MemberAccessExpressionNode)leftNode;
                IExpressionNode rightNode = maen.getRightOperandNode();
                ASTNodeID rightID = rightNode.getNodeID();
                if (rightID == ASTNodeID.IdentifierID && (rightDef = rightNode.resolveType(this.getWalker().getProject())) != null) {
                    return IdentifierNode.isXMLish((IDefinition)rightDef, (ICompilerProject)this.getWalker().getProject());
                }
                leftNode = maen.getLeftOperandNode();
                return this.isLeftNodeXMLish(leftNode);
            }
            if (leftID == ASTNodeID.FunctionCallID) {
                FunctionCallNode fcn = (FunctionCallNode)leftNode;
                String fname = fcn.getFunctionName();
                if (fname.equals("XML") || fname.equals("XMLList")) {
                    return true;
                }
            } else if (leftID == ASTNodeID.Op_AsID) {
                BinaryOperatorAsNode boan = (BinaryOperatorAsNode)leftNode;
                String fname = ((IdentifierNode)boan.getChild(1)).getName();
                if (fname.equals("XML") || fname.equals("XMLList")) {
                    return true;
                }
            } else if (leftID == ASTNodeID.ArrayIndexExpressionID) {
                ITypeDefinition leftDef = (leftNode = (IExpressionNode)leftNode.getChild(0)).resolveType(this.getWalker().getProject());
                if (leftDef != null) {
                    return IdentifierNode.isXMLish((IDefinition)leftDef, (ICompilerProject)this.getWalker().getProject());
                }
            } else if (leftID == ASTNodeID.E4XFilterID) {
                return true;
            }
        }
        return false;
    }

    public boolean isProxy(IExpressionNode obj) {
        RoyaleProject project = (RoyaleProject)this.getWalker().getProject();
        ITypeDefinition leftDef = obj.resolveType((ICompilerProject)project);
        if (leftDef == null) {
            if (obj.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                IExpressionNode leftNode = ((MemberAccessExpressionNode)obj).getLeftOperandNode();
                leftDef = leftNode.resolveType((ICompilerProject)project);
                if (leftDef != null && leftDef.isInstanceOf(project.getProxyBaseClass(), (ICompilerProject)project)) {
                    return true;
                }
                while (leftNode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                    leftDef = (leftNode = ((MemberAccessExpressionNode)leftNode).getLeftOperandNode()).resolveType((ICompilerProject)project);
                    if (leftDef == null || !leftDef.isInstanceOf(project.getProxyBaseClass(), (ICompilerProject)project)) continue;
                    return true;
                }
            }
            return false;
        }
        return leftDef.isInstanceOf(project.getProxyBaseClass(), (ICompilerProject)project);
    }

    public boolean isDateProperty(IExpressionNode obj, boolean writeAccess) {
        RoyaleProject project = (RoyaleProject)this.getWalker().getProject();
        if (obj.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            IExpressionNode leftNode = ((MemberAccessExpressionNode)obj).getLeftOperandNode();
            IExpressionNode rightNode = ((MemberAccessExpressionNode)obj).getRightOperandNode();
            ITypeDefinition leftDef = leftNode.resolveType((ICompilerProject)project);
            IDefinition rightDef = rightNode.resolve((ICompilerProject)project);
            if (leftDef != null && leftDef.getQualifiedName().equals("Date")) {
                BinaryOperatorEmitter.DatePropertiesGetters propGetter;
                BinaryOperatorEmitter.DatePropertiesSetters propSetter;
                if (rightDef instanceof AccessorDefinition) {
                    return true;
                }
                if (rightDef == null && rightNode.getNodeID() == ASTNodeID.IdentifierID && (writeAccess ? (propSetter = BinaryOperatorEmitter.DatePropertiesSetters.valueOf(((IIdentifierNode)rightNode).getName().toUpperCase())) != null : (propGetter = BinaryOperatorEmitter.DatePropertiesGetters.valueOf(((IIdentifierNode)rightNode).getName().toUpperCase())) != null)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isXML(IExpressionNode obj) {
        ITypeDefinition leftDef = obj.resolveType(this.getWalker().getProject());
        return IdentifierNode.isXMLish((IDefinition)leftDef, (ICompilerProject)this.getWalker().getProject());
    }

    public MemberAccessExpressionNode getLastMAEInChain(MemberAccessExpressionNode node) {
        while (node.getRightOperandNode() instanceof MemberAccessExpressionNode) {
            node = (MemberAccessExpressionNode)node.getRightOperandNode();
        }
        return node;
    }

    public void emitLabelStatement(LabeledStatementNode node) {
        BlockNode innerBlock = node.getLabeledStatement();
        if (innerBlock.getChildCount() == 1 && innerBlock.getChild(0).getNodeID() == ASTNodeID.ForEachLoopID) {
            this.getWalker().walk((IASNode)node.getLabeledStatement());
            return;
        }
        super.emitLabelStatement(node);
    }

    public void emitTypedExpression(ITypedExpressionNode node) {
        this.write(JSRoyaleEmitterTokens.VECTOR);
    }

    boolean isExternal(String className) {
        ICompilerProject project = this.getWalker().getProject();
        ICompilationUnit cu = project.resolveQNameToCompilationUnit(className);
        if (cu == null) {
            return false;
        }
        return ((RoyaleJSProject)project).isExternalLinkage(cu);
    }
}

