/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.flexbuilder;

import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.tools.flexbuilder.BuilderConfiguration;
import flex2.tools.oem.Application;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.LibraryCache;
import flex2.tools.oem.VirtualLocalFile;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BuilderApplication
extends Application {
    private BuilderConfiguration c;
    private static final Set<String> excludes = new HashSet<String>();

    public BuilderApplication(File file) throws FileNotFoundException {
        super(file);
    }

    public BuilderApplication(File file, LibraryCache cache) throws FileNotFoundException {
        super(file, cache);
    }

    public BuilderApplication(VirtualLocalFile file) {
        super(file);
    }

    public BuilderApplication(VirtualLocalFile[] files) {
        super(files);
    }

    public Configuration getDefaultConfiguration() {
        return new BuilderConfiguration(super.getDefaultConfiguration());
    }

    public void setConfiguration(Configuration configuration) {
        if (configuration instanceof BuilderConfiguration) {
            this.c = (BuilderConfiguration)configuration;
            super.setConfiguration(this.c.configuration);
        } else {
            super.setConfiguration(configuration);
        }
    }

    public Configuration getConfiguration() {
        return this.c != null ? this.c : super.getConfiguration();
    }

    protected int compile(boolean incremental) {
        String[] args;
        OEMConfiguration config = null;
        if (this.c != null && (args = this.c.extra) != null && args.length > 0 && (config = (OEMConfiguration)this.c.configuration) != null) {
            ConfigurationBuffer cfgbuf = OEMUtil.getCommandLineConfigurationBuffer(OEMUtil.getLogger(this.getLogger(), null), this.resolver, args);
            if (cfgbuf == null) {
                return -1;
            }
            List<Object[]> positions = cfgbuf.getPositions();
            int length = positions.size();
            for (int i = 0; i < length; ++i) {
                String value2;
                Object[] a = positions.get(i);
                String var = (String)a[0];
                if ("link-report".equals(var)) {
                    config.keepLinkReport(true);
                    continue;
                }
                if ("compiler.debug".equals(var)) {
                    try {
                        value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        String debugPassword = cfgbuf.peekSimpleConfigurationVar("debug-password");
                        if ("true".equals(value2)) {
                            config.enableDebugging(true, debugPassword);
                            continue;
                        }
                        if (!"false".equals(value2)) continue;
                        config.enableDebugging(false, debugPassword);
                    }
                    catch (ConfigurationException value2) {}
                    continue;
                }
                if ("compiler.verbose-stacktraces".equals(var)) {
                    try {
                        value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value2)) {
                            config.enableVerboseStacktraces(true);
                            continue;
                        }
                        if (!"false".equals(value2)) continue;
                        config.enableVerboseStacktraces(false);
                    }
                    catch (ConfigurationException value3) {}
                    continue;
                }
                if ("compiler.accessible".equals(var)) {
                    try {
                        value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value2)) {
                            config.enableAccessibility(true);
                            continue;
                        }
                        if (!"false".equals(value2)) continue;
                        config.enableAccessibility(false);
                    }
                    catch (ConfigurationException value4) {}
                    continue;
                }
                if ("compiler.strict".equals(var)) {
                    try {
                        value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value2)) {
                            config.enableStrictChecking(true);
                            continue;
                        }
                        if (!"false".equals(value2)) continue;
                        config.enableStrictChecking(false);
                    }
                    catch (ConfigurationException value5) {}
                    continue;
                }
                if ("help".equals(var)) continue;
                if ("output".equals(var)) {
                    try {
                        value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        this.setOutput(new File(value2));
                    }
                    catch (ConfigurationException value6) {}
                    continue;
                }
                if ("size-report".equals(var)) {
                    config.keepSizeReport(true);
                    continue;
                }
                if ("version".equals(var)) continue;
                if ("warnings".equals(var)) {
                    try {
                        value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value2)) {
                            config.showActionScriptWarnings(true);
                            config.showBindingWarnings(true);
                            config.showDeprecationWarnings(true);
                            config.showUnusedTypeSelectorWarnings(true);
                            continue;
                        }
                        if (!"false".equals(value2)) continue;
                        config.showActionScriptWarnings(false);
                        config.showBindingWarnings(false);
                        config.showDeprecationWarnings(false);
                        config.showUnusedTypeSelectorWarnings(false);
                    }
                    catch (ConfigurationException value7) {}
                    continue;
                }
                if ("compiler.show-actionscript-warnings".equals(var)) {
                    try {
                        value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value2)) {
                            config.showActionScriptWarnings(true);
                            continue;
                        }
                        if (!"false".equals(value2)) continue;
                        config.showActionScriptWarnings(false);
                    }
                    catch (ConfigurationException value8) {}
                    continue;
                }
                if ("compiler.show-deprecation-warnings".equals(var)) {
                    try {
                        value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value2)) {
                            config.showDeprecationWarnings(true);
                            continue;
                        }
                        if (!"false".equals(value2)) continue;
                        config.showDeprecationWarnings(false);
                    }
                    catch (ConfigurationException value9) {}
                    continue;
                }
                if ("compiler.show-shadowed-device-font-warnings".equals(var)) {
                    try {
                        value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value2)) {
                            config.showShadowedDeviceFontWarnings(true);
                            continue;
                        }
                        if (!"false".equals(value2)) continue;
                        config.showShadowedDeviceFontWarnings(false);
                    }
                    catch (ConfigurationException value10) {}
                    continue;
                }
                if ("compiler.show-binding-warnings".equals(var)) {
                    try {
                        value2 = cfgbuf.peekSimpleConfigurationVar(var);
                        if ("true".equals(value2)) {
                            config.showBindingWarnings(true);
                            continue;
                        }
                        if (!"false".equals(value2)) continue;
                        config.showBindingWarnings(false);
                    }
                    catch (ConfigurationException value11) {}
                    continue;
                }
                if (!"compiler.show-unused-type-selector-warnings".equals(var)) continue;
                try {
                    value2 = cfgbuf.peekSimpleConfigurationVar(var);
                    if ("true".equals(value2)) {
                        config.showUnusedTypeSelectorWarnings(true);
                        continue;
                    }
                    if (!"false".equals(value2)) continue;
                    config.showUnusedTypeSelectorWarnings(false);
                    continue;
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
            config.setConfiguration(OEMUtil.trim(args, cfgbuf, excludes));
        }
        int result = super.compile(incremental);
        return result;
    }

    static {
        excludes.add("help");
        excludes.add("output");
        excludes.add("version");
        excludes.add("warnings");
        excludes.add("compiler.debug");
        excludes.add("compiler.profile");
        excludes.add("compiler.accessible");
        excludes.add("compiler.strict");
        excludes.add("compiler.show-actionscript-warnings");
        excludes.add("compiler.show-unused-type-selector-warnings");
        excludes.add("compiler.show-deprecation-warnings");
        excludes.add("compiler.show-shadowed-device-font-warnings");
        excludes.add("compiler.show-binding-warnings");
        excludes.add("compiler.verbose-stacktraces");
    }
}

