/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerException;
import flex2.compiler.Source;
import flex2.compiler.SourcePath;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceList {
    private Map<String, Source> sources;
    private List<File> directories;
    private String[] mimeTypes;

    public SourceList(List<VirtualFile> files, VirtualFile[] classPath, VirtualFile appPath, String[] mimeTypes) throws CompilerException {
        this(files, classPath, appPath, mimeTypes, true);
    }

    public SourceList(List<VirtualFile> files, VirtualFile[] classPath, VirtualFile appPath, String[] mimeTypes, boolean lastIsRoot) throws CompilerException {
        VirtualFile[] vfiles = new VirtualFile[files.size()];
        files.toArray(vfiles);
        this.init(vfiles, classPath, appPath, mimeTypes, lastIsRoot);
    }

    private void init(VirtualFile[] files, VirtualFile[] classPath, VirtualFile appPath, String[] mimeTypes, boolean lastIsRoot) throws CompilerException {
        this.mimeTypes = mimeTypes;
        this.sources = new LinkedHashMap<String, Source>(files.length);
        this.directories = new ArrayList<File>(classPath == null ? 0 : classPath.length);
        SourcePath.addApplicationParentToSourcePath(appPath, classPath, this.directories);
        SourcePath.addPathElements(classPath, this.directories, true, null);
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            VirtualFile pathRoot;
            String name;
            if (appPath != null && files[i].getName().equals(appPath.getName()) || this.isSupported(files[i])) {
                name = files[i].getName();
                pathRoot = this.calculatePathRoot(files[i]);
                if (pathRoot == null) {
                    FileNotInSourcePath ex = new FileNotInSourcePath(name);
                    ThreadLocalToolkit.log(ex);
                    throw ex;
                }
            } else {
                UnsupportedFileType ex = new UnsupportedFileType(files[i].getName());
                ThreadLocalToolkit.log(ex);
                throw ex;
            }
            String relativePath = this.calculateRelativePath(name);
            String namespaceURI = relativePath.replace('/', '.');
            String localPart = this.calculateLocalPart(name);
            Source source = new Source(files[i], pathRoot, relativePath, localPart, this, false, i == length - 1 && lastIsRoot);
            String className = CompilerAPI.constructClassName(namespaceURI, localPart);
            this.sources.put(className, source);
        }
    }

    private VirtualFile calculatePathRoot(VirtualFile f) {
        return SourceList.calculatePathRoot(f, this.directories);
    }

    static VirtualFile calculatePathRoot(VirtualFile f, List<File> directories) {
        String name = f.getName();
        if (directories != null) {
            for (File directory : directories) {
                String dir = directory.getAbsolutePath();
                if (!name.startsWith(dir)) continue;
                return new LocalFile(FileUtil.openFile(dir));
            }
        }
        return null;
    }

    private String calculateRelativePath(String name) {
        if (this.directories != null) {
            for (File directory : this.directories) {
                String dir = directory.getAbsolutePath() + File.separatorChar;
                if (!name.startsWith(dir)) continue;
                int index = (name = name.substring(dir.length())).lastIndexOf(File.separatorChar);
                if (index != -1) {
                    return name.substring(0, index).replace(File.separatorChar, '/');
                }
                return "";
            }
        }
        return "";
    }

    private String calculateLocalPart(String name) {
        String leafName = name.substring(name.lastIndexOf(File.separatorChar) + 1);
        String localPart = leafName.substring(0, leafName.lastIndexOf(46));
        return localPart;
    }

    public List<Source> retrieveSources() {
        ArrayList<Source> sources = new ArrayList<Source>(this.sources.size());
        for (String name : this.sources.keySet()) {
            Source s = this.sources.get(name);
            if (s != null && !s.exists()) {
                s = null;
            }
            if (s == null) continue;
            sources.add(s);
        }
        return sources;
    }

    private boolean isSupported(VirtualFile file) {
        for (String mimeType : this.mimeTypes) {
            if (!mimeType.equals(file.getMimeType())) continue;
            return true;
        }
        return false;
    }

    public List<File> getPaths() {
        return this.directories;
    }

    String[] getMimeTypes() {
        return this.mimeTypes;
    }

    public Map<String, Source> sources() {
        return this.sources;
    }

    public static class UnsupportedFileType
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5300063184460255877L;
        public final String name;

        public UnsupportedFileType(String name) {
            this.name = name;
        }
    }

    public static class FileNotInSourcePath
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1516975612657669682L;
        public final String name;

        public FileNotInSourcePath(String name) {
            this.name = name;
        }
    }
}

