/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.problems;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.royale.compiler.Messages;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbedSourceAttributeDoesNotExistProblem
extends CompilerProblem {
    public static final String DESCRIPTION = "Could not find Embed source '${embedSource}'. Searched ${locations}";
    public static final int errorCode = 1353;
    public final String embedSource;
    public final String locations;

    public EmbedSourceAttributeDoesNotExistProblem(ISourceLocation site, String embedSource, Map<String, String> searchedLocations) {
        super(site);
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> iter = searchedLocations.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String path = entry.getKey();
            String format = entry.getValue();
            String message = Messages.getString(format, Collections.singletonMap("path", path));
            sb.append(message);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        this.embedSource = embedSource;
        this.locations = sb.toString();
    }
}

