/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.io.StringWriter;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.tree.mxml.XMLBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.MXMLDualContentProblem;
import org.apache.royale.compiler.problems.MXMLUnknownXMLFormatProblem;
import org.apache.royale.compiler.problems.MXMLXMLOnlyOneRootTagProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLXMLNode;

class MXMLXMLNode
extends MXMLInstanceNode
implements IMXMLXMLNode {
    private IMXMLTagData rootTag;
    private IMXMLXMLNode.XML_TYPE xmlType = IMXMLXMLNode.XML_TYPE.E4X;
    boolean multipleTags = false;
    private String xmlString;

    MXMLXMLNode(NodeBase parent) {
        super(parent);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLXMLID;
    }

    public String getName() {
        return "XML";
    }

    public IMXMLXMLNode.XML_TYPE getXMLType() {
        return this.xmlType;
    }

    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            String sourcePath = MXMLXMLNode.resolveSourceAttributePath(builder, attribute, info);
            if (sourcePath != null) {
                this.xmlString = builder.readExternalFile(attribute, sourcePath);
            }
        } else if (attribute.isSpecialAttribute("format")) {
            String attrValue = attribute.getRawValue().toLowerCase();
            if (attrValue.equals("e4x")) {
                this.xmlType = IMXMLXMLNode.XML_TYPE.E4X;
            } else if (attrValue.equals("xml")) {
                this.xmlType = IMXMLXMLNode.XML_TYPE.OLDXML;
            } else {
                MXMLUnknownXMLFormatProblem problem = new MXMLUnknownXMLFormatProblem(attribute);
                builder.addProblem(problem);
                this.xmlType = IMXMLXMLNode.XML_TYPE.OLDXML;
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        info.hasDualContent = true;
        if (this.rootTag == null) {
            this.rootTag = childTag;
        } else {
            this.multipleTags = true;
        }
    }

    public IClassDefinition getClassReference(ICompilerProject project) {
        if (this.xmlType == IMXMLXMLNode.XML_TYPE.OLDXML) {
            ASProjectScope projectScope = (ASProjectScope)project.getScope();
            return (IClassDefinition)projectScope.findDefinitionByName("flash.xml.XMLNode");
        }
        return super.getClassReference(project);
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (info.hasSourceAttribute && info.hasDualContent) {
            MXMLDualContentProblem problem = new MXMLDualContentProblem(tag, tag.getShortName());
            builder.addProblem(problem);
            return;
        }
        if (this.multipleTags) {
            builder.addProblem(new MXMLXMLOnlyOneRootTagProblem(tag));
        }
        this.analyzeXML(builder);
        this.rootTag = null;
        if (this.xmlType == IMXMLXMLNode.XML_TYPE.OLDXML) {
            RoyaleProject project = builder.getProject();
            builder.addExpressionDependency(project.getXMLUtilClass());
        }
    }

    public String getXMLString() {
        return this.xmlString;
    }

    private void analyzeXML(MXMLTreeBuilder builder) {
        if (this.rootTag != null) {
            StringWriter writer = new StringWriter();
            XMLBuilder xmlBuilder = new XMLBuilder(this, this.rootTag, this.rootTag.getCompositePrefixMap(), builder);
            xmlBuilder.processNode(this.rootTag, writer);
            this.setChildren(xmlBuilder.getDatabindings().toArray(new IMXMLNode[0]));
            this.xmlString = writer.toString();
        }
    }
}

