/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.common.XMLName;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.tree.mxml.MXMLWebServiceOperationNode;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLWebServiceNode;

class MXMLWebServiceNode
extends MXMLInstanceNode
implements IMXMLWebServiceNode {
    private static final String TAG_OPERATION = "operation";
    private static final String BASENAME_WEB_SERVICE_OPERATION = "WebServiceOperation";

    MXMLWebServiceNode(NodeBase parent) {
        super(parent);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLWebServiceID;
    }

    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        if (childTag.getShortName().equals(TAG_OPERATION)) {
            RoyaleProject project = builder.getProject();
            XMLName name = new XMLName(childTag.getXMLName().getXMLNamespace(), BASENAME_WEB_SERVICE_OPERATION);
            String qname = builder.getFileScope().resolveXMLNameToQualifiedName(name, builder.getMXMLDialect());
            String webServiceOperationQName = project.getWebServiceOperationQName();
            if (qname != null && qname.equals(webServiceOperationQName)) {
                MXMLWebServiceOperationNode operationNode = new MXMLWebServiceOperationNode(this);
                operationNode.setClassReference(project, webServiceOperationQName);
                operationNode.initializeFromTag(builder, childTag);
                info.addChildNode(operationNode);
            }
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
    }
}

