/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.mxml.MXMLData;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.mxml.MXMLTagData;
import org.apache.royale.compiler.internal.mxml.MXMLTextData;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLArrayNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLComponentNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLDeferredInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLSpecifierNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.tree.mxml.MXMLVectorNode;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MXMLBadChildTagPropertyAssignmentProblem;
import org.apache.royale.compiler.problems.MXMLMultipleInitializersProblem;
import org.apache.royale.compiler.problems.MXMLSemanticProblem;
import org.apache.royale.compiler.problems.MXMLUnresolvedTagProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MXMLPropertySpecifierNode
extends MXMLSpecifierNodeBase
implements IMXMLPropertySpecifierNode {
    private static final EnumSet<MXMLDialect.TextParsingFlags> FLAGS = EnumSet.of(MXMLDialect.TextParsingFlags.ALLOW_ARRAY, new MXMLDialect.TextParsingFlags[]{MXMLDialect.TextParsingFlags.ALLOW_BINDING, MXMLDialect.TextParsingFlags.ALLOW_COLOR_NAME, MXMLDialect.TextParsingFlags.ALLOW_COMPILER_DIRECTIVE, MXMLDialect.TextParsingFlags.ALLOW_ESCAPED_COMPILER_DIRECTIVE, MXMLDialect.TextParsingFlags.ALLOW_PERCENT});
    private String dynamicName;
    private MXMLInstanceNode instanceNode;
    private Boolean firstInstanceProblemAdded = false;

    MXMLPropertySpecifierNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLPropertySpecifierID;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.instanceNode : null;
    }

    @Override
    public int getChildCount() {
        return this.instanceNode != null ? 1 : 0;
    }

    @Override
    public IMXMLInstanceNode getInstanceNode() {
        return this.instanceNode;
    }

    void setInstanceNode(MXMLInstanceNode instanceNode) {
        this.instanceNode = instanceNode;
    }

    private ITypeDefinition getPropertyType(MXMLTreeBuilder builder) {
        IDefinition definition = this.getDefinition();
        RoyaleProject project = builder.getProject();
        if (definition == null) {
            return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
        }
        return definition.resolveType(project);
    }

    protected String getPropertyTypeName(MXMLTreeBuilder builder) {
        ITypeDefinition propertyType = this.getPropertyType(builder);
        if (propertyType == null) {
            return "*";
        }
        return propertyType.getQualifiedName();
    }

    void setDynamicName(String dynamicName) {
        this.dynamicName = dynamicName;
    }

    @Override
    public String getName() {
        return this.dynamicName != null ? this.dynamicName : super.getName();
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void initializeFromAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializeFromAttribute(builder, attribute, info);
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] fragments = attribute.getValueFragments(problems);
        info.addSourceFragments(attribute.getSourcePath(), fragments);
        this.processFragments(builder, attribute, info);
        info.clearFragments();
    }

    private void processFragments(MXMLTreeBuilder builder, ISourceLocation sourceLocation, MXMLNodeBase.MXMLNodeInfo info) {
        IVariableDefinition percentProxyDefinition;
        ITypeDefinition propertyType = this.getPropertyType(builder);
        ISourceFragment[] fragments = info.getSourceFragments();
        ISourceLocation location = info.getSourceLocation();
        if (location == null) {
            location = sourceLocation;
        }
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        Object flags = FLAGS.clone();
        IDefinition definition = this.getDefinition();
        RoyaleProject project = builder.getProject();
        if (definition instanceof IVariableDefinition) {
            if (((IVariableDefinition)definition).hasCollapseWhiteSpace(project)) {
                ((AbstractCollection)flags).add(MXMLDialect.TextParsingFlags.COLLAPSE_WHITE_SPACE);
            }
            if (((IVariableDefinition)definition).hasRichTextContent(project)) {
                ((AbstractCollection)flags).add(MXMLDialect.TextParsingFlags.RICH_TEXT_CONTENT);
            }
        }
        this.instanceNode = builder.createInstanceNode(this, propertyType, fragments, location, (EnumSet<MXMLDialect.TextParsingFlags>)flags, classNode);
        if (this.instanceNode == null) {
            this.markInvalidForCodeGen();
        }
        if ((percentProxyDefinition = builder.getPercentProxyDefinition()) != null) {
            this.setDefinition(percentProxyDefinition);
        }
    }

    @Override
    protected void initializeFromTag(MXMLTreeBuilder builder, IMXMLTagData tag) {
        String propertyTypeName = this.getPropertyTypeName(builder);
        if (propertyTypeName.contains("Vector.<") || propertyTypeName.equals("Array")) {
            for (IMXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
                if (!(unit instanceof IMXMLTagData)) continue;
                IMXMLTagData unitTag = (IMXMLTagData)unit;
                IDefinition definition = builder.getFileScope().resolveTagToDefinition(unitTag);
                if (propertyTypeName.contains("Vector.<") && !definition.getQualifiedName().contains("Vector.<")) {
                    this.initializeDefaultProperty(builder, (IVariableDefinition)this.getDefinition(), this.getListOfUnits(tag));
                    return;
                }
                if (!propertyTypeName.equals("Array") || definition == null || definition.getQualifiedName().equals("Array")) continue;
                this.initializeDefaultProperty(builder, (IVariableDefinition)this.getDefinition(), this.getListOfUnits(tag));
                return;
            }
        }
        super.initializeFromTag(builder, tag);
    }

    List<IMXMLUnitData> getListOfUnits(IMXMLTagData tag) {
        ArrayList<IMXMLUnitData> list = new ArrayList<IMXMLUnitData>();
        for (IMXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            list.add(unit);
        }
        return list;
    }

    @Override
    protected void initializeFromText(MXMLTreeBuilder builder, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializeFromText(builder, text, info);
        this.accumulateTextFragments(builder, text, info);
        this.processFragments(builder, text, info);
    }

    void initializeDefaultProperty(MXMLTreeBuilder builder, IVariableDefinition defaultPropertyDefinition, List<IMXMLUnitData> contentUnits) {
        RoyaleProject project = builder.getProject();
        assert (contentUnits.isEmpty() || !builder.getFileScope().isScriptTag(contentUnits.get(0))) : "Script tags should not start a default property!";
        assert (contentUnits.isEmpty() || !builder.getFileScope().isScriptTag(contentUnits.get(contentUnits.size() - 1))) : "Trailing script tags should be removed from default property content units!";
        this.setLocation(builder, contentUnits);
        String propertyTypeName = this.getPropertyTypeName(builder);
        if (propertyTypeName.equals(project.getDeferredInstanceInterface()) || propertyTypeName.equals(project.getTransientDeferredInstanceInterface())) {
            this.instanceNode = new MXMLDeferredInstanceNode(this);
            ((MXMLDeferredInstanceNode)this.instanceNode).initializeDefaultProperty(builder, defaultPropertyDefinition, contentUnits);
        } else if (propertyTypeName.equals("Array") && this.oneChildIsNotArray(builder, contentUnits)) {
            this.instanceNode = new MXMLArrayNode(this);
            ((MXMLArrayNode)this.instanceNode).initializeDefaultProperty(builder, defaultPropertyDefinition, contentUnits);
        } else if (propertyTypeName.contains("Vector.<") && this.oneChildIsNotVector(builder, contentUnits)) {
            this.instanceNode = new MXMLVectorNode(this);
            ((MXMLVectorNode)this.instanceNode).initializeDefaultProperty(builder, defaultPropertyDefinition, contentUnits);
        } else if (contentUnits.size() == 1 && contentUnits.get(0) instanceof IMXMLTagData) {
            IMXMLTagData tag = (IMXMLTagData)contentUnits.get(0);
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(tag);
            if (definition instanceof ClassDefinition) {
                this.instanceNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
                this.instanceNode.setClassReference(project, (ClassDefinition)definition);
                this.instanceNode.initializeFromTag(builder, tag);
            } else if (definition == null && defaultPropertyDefinition.getBaseName().equals("html")) {
                String text = ((MXMLTagData)tag).stringify();
                MXMLToken textToken = new MXMLToken(12, tag.getStart(), tag.getEnd(), tag.getLine(), tag.getColumn(), text);
                MXMLTextData textData = new MXMLTextData(textToken);
                textData.setLocation((MXMLData)tag.getParent(), tag.getIndex());
                this.initializeFromText(builder, textData, this.createNodeInfo(builder));
            }
        }
    }

    private boolean oneChildIsNotArray(MXMLTreeBuilder builder, List<IMXMLUnitData> contentUnits) {
        if (contentUnits.size() != 1) {
            return true;
        }
        if (contentUnits.get(0) instanceof IMXMLTagData) {
            IMXMLTagData tag = (IMXMLTagData)contentUnits.get(0);
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(tag);
            if (definition.getQualifiedName().equals("Array")) {
                return false;
            }
        }
        return true;
    }

    private boolean oneChildIsNotVector(MXMLTreeBuilder builder, List<IMXMLUnitData> contentUnits) {
        if (contentUnits.size() != 1) {
            return true;
        }
        if (contentUnits.get(0) instanceof IMXMLTagData) {
            IMXMLTagData tag = (IMXMLTagData)contentUnits.get(0);
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(tag);
            if (definition.getQualifiedName().contains("Vector.<")) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLFileScope fileScope = builder.getFileScope();
        MXMLInstanceNode instanceNode = null;
        if (fileScope.isComponentTag(childTag)) {
            instanceNode = new MXMLComponentNode(this);
            instanceNode.initializeFromTag(builder, childTag);
        } else {
            RoyaleProject project;
            String propertyTypeName = this.getPropertyTypeName(builder);
            if (propertyTypeName.equals((project = builder.getProject()).getDeferredInstanceInterface()) || propertyTypeName.equals(project.getTransientDeferredInstanceInterface())) {
                instanceNode = new MXMLDeferredInstanceNode(this);
                instanceNode.initializeFromTag(builder, tag);
            } else {
                IDefinition definition = builder.getFileScope().resolveTagToDefinition(childTag);
                if (definition instanceof ClassDefinition) {
                    instanceNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
                    instanceNode.setClassReference(project, (ClassDefinition)definition);
                    instanceNode.initializeFromTag(builder, childTag);
                } else {
                    String uri = childTag.getURI();
                    if (uri != null && uri.equals("http://ns.adobe.com/mxml/2009")) {
                        instanceNode = MXMLInstanceNode.createInstanceNode(builder, childTag.getShortName(), this);
                        instanceNode.setClassReference(project, childTag.getShortName());
                        instanceNode.initializeFromTag(builder, childTag);
                    } else {
                        MXMLUnresolvedTagProblem problem = new MXMLUnresolvedTagProblem(childTag);
                        builder.addProblem(problem);
                    }
                }
            }
            ITypeDefinition assignToType = this.getPropertyType(builder);
            if (assignToType != project.getBuiltinType(IASLanguageConstants.BuiltinType.ARRAY)) {
                MXMLSemanticProblem problem;
                if (instanceNode != null && this.instanceNode == null && !instanceNode.getClassReference(project).isInstanceOf(assignToType, (ICompilerProject)project) && assignToType != project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE)) {
                    problem = new MXMLBadChildTagPropertyAssignmentProblem(childTag, instanceNode.getClassReference(project).getQualifiedName(), propertyTypeName);
                    builder.addProblem(problem);
                    instanceNode = null;
                } else if (this.instanceNode != null && instanceNode != null) {
                    if (!this.firstInstanceProblemAdded.booleanValue()) {
                        problem = new MXMLMultipleInitializersProblem(tag.getFirstChild(false), this.getPropertyTypeName(builder));
                        builder.addProblem(problem);
                        this.firstInstanceProblemAdded = true;
                    }
                    problem = new MXMLMultipleInitializersProblem(childTag, this.getPropertyTypeName(builder));
                    builder.addProblem(problem);
                    instanceNode = null;
                }
            }
        }
        if (instanceNode != null) {
            this.instanceNode = instanceNode;
        }
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        this.accumulateTextFragments(builder, text, info);
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        RoyaleProject project = builder.getProject();
        IDefinition definition = this.getDefinition();
        if (definition != null && definition.getTypeAsDisplayString().equals("Array") && (this.instanceNode == null || !(this.instanceNode instanceof MXMLArrayNode) && !this.instanceNode.getClassReference(project).getQualifiedName().equals("Array"))) {
            this.instanceNode = new MXMLArrayNode(this);
            this.instanceNode.setClassReference(project, "Array");
            ((MXMLArrayNode)this.instanceNode).initializeFromTag(builder, tag);
        }
        if (this.instanceNode == null) {
            this.processFragments(builder, tag, info);
        }
    }

    @Override
    public IVariableDefinition getPercentProxyDefinition(RoyaleProject project) {
        IClassDefinition classDefinition;
        IVariableDefinition propertyDefinition = (IVariableDefinition)this.getDefinition();
        String percentProxy = propertyDefinition.getPercentProxy(project);
        if (percentProxy == null) {
            return null;
        }
        ASScope classScope = (ASScope)propertyDefinition.getContainingScope();
        IDefinition proxyDefinition = classScope.getPropertyFromDef(project, classDefinition = (IClassDefinition)((Object)classScope.getDefinition()), percentProxy, false);
        if (!(proxyDefinition instanceof IVariableDefinition)) {
            return null;
        }
        return (IVariableDefinition)proxyDefinition;
    }
}

