/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.INamespaceAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;

public class NamespaceAccessExpressionNode
extends BinaryOperatorNodeBase
implements INamespaceAccessExpressionNode {
    public NamespaceAccessExpressionNode(ExpressionNodeBase left, IASToken operator, ExpressionNodeBase right) {
        super(operator, left instanceof IdentifierNode ? new NamespaceIdentifierNode((IdentifierNode)left) : left, right);
        this.leftOperandNode.span(left.getAbsoluteStart(), left.getAbsoluteEnd(), left.getLine(), left.getColumn());
    }

    protected NamespaceAccessExpressionNode(NamespaceAccessExpressionNode other) {
        super(other);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.NamespaceAccessExpressionID;
    }

    public IDefinition resolve(ICompilerProject project) {
        return this.rightOperandNode.resolve(project);
    }

    public ITypeDefinition resolveType(ICompilerProject project) {
        return this.rightOperandNode.resolveType(project);
    }

    protected NamespaceAccessExpressionNode copy() {
        return new NamespaceAccessExpressionNode(this);
    }

    boolean isQualifiedExpr(ExpressionNodeBase e) {
        return e == this.rightOperandNode;
    }

    ExpressionNodeBase getQualifier(ExpressionNodeBase e) {
        if (e == this.rightOperandNode) {
            return this.leftOperandNode;
        }
        return null;
    }

    boolean isAttributeExpr(ExpressionNodeBase e) {
        ExpressionNodeBase p;
        if (e == this.rightOperandNode && (p = this.getParentExpression()) != null) {
            return p.isAttributeExpr(this);
        }
        return false;
    }

    boolean isPartOfMemberRef(ExpressionNodeBase e) {
        ExpressionNodeBase p;
        if (e == this.rightOperandNode && (p = this.getParentExpression()) != null) {
            return p.isPartOfMemberRef(this);
        }
        return false;
    }

    ExpressionNodeBase getBaseForMemberRef(ExpressionNodeBase e) {
        ExpressionNodeBase p;
        if (e == this.rightOperandNode && (p = this.getParentExpression()) != null) {
            return p.getBaseForMemberRef(this);
        }
        return null;
    }

    public INamespaceReference computeNamespaceReference() {
        return this.rightOperandNode.computeNamespaceReference();
    }

    public IOperatorNode.OperatorType getOperator() {
        return IOperatorNode.OperatorType.NAMESPACE_ACCESS;
    }
}

