/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.royale.compiler.asdoc.IASDocComment;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.IMetaInfo;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.ModifierNode;
import org.apache.royale.compiler.internal.tree.as.ModifiersContainerNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.TreeNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.royale.compiler.internal.tree.as.parts.DecorationPart;
import org.apache.royale.compiler.internal.tree.as.parts.IDecorationPart;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDocumentableDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDefinitionNode
extends TreeNode
implements IDocumentableDefinitionNode,
IDefinitionNode {
    protected ExpressionNodeBase nameNode;
    private IDecorationPart decorationPart;
    protected IDefinition definition;

    private static int accumulateChildStart(IASNode child, int start) {
        int childStart = child.getStart();
        if (childStart >= 0 && childStart < start) {
            start = childStart;
        }
        return start;
    }

    private static boolean shouldIgnoreChildForTooling(IASNode child) {
        return child instanceof IMetaTagsNode;
    }

    @Override
    public int getSpanningStart() {
        INamespaceDecorationNode namespace;
        int result = this.getAbsoluteStart();
        ModifiersSet modifiers = this.getModifiers();
        INamespaceDecorationNode iNamespaceDecorationNode = namespace = this.decorationPart != null ? this.decorationPart.getNamespace() : null;
        if (modifiers != null && modifiers.getStart() < result && modifiers.getStart() >= 0) {
            result = modifiers.getStart();
        }
        if (namespace != null && namespace.getAbsoluteStart() < result && namespace.getAbsoluteStart() >= 0) {
            result = namespace.getAbsoluteStart();
        }
        return result;
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
            this.reconnectDef(scope);
        }
        super.analyze(set, scope, problems);
    }

    @Override
    public void normalize(boolean fillInOffsets) {
        super.normalize(fillInOffsets);
        if (this.decorationPart != null) {
            this.decorationPart.compact();
        }
    }

    @Override
    public boolean hasExplicitComment() {
        return this.decorationPart.getASDocComment() != null;
    }

    @Override
    public IMetaTagsNode getMetaTags() {
        return this.decorationPart.getMetadata();
    }

    @Override
    public IMetaInfo[] getMetaInfos() {
        IMetaTagsNode metaTagsNode = this.getMetaTags();
        if (metaTagsNode == null) {
            return new IMetaInfo[0];
        }
        return metaTagsNode.getAllTags();
    }

    @Override
    public boolean hasNamespace(String namespace) {
        String thisNamespace = this.getNamespace();
        if (thisNamespace != null) {
            if (thisNamespace.indexOf(46) != -1 || namespace.indexOf(46) != -1) {
                // empty if block
            }
            return thisNamespace.compareTo(namespace) == 0;
        }
        return false;
    }

    @Override
    public String getNamespace() {
        INamespaceDecorationNode namespace = this.decorationPart.getNamespace();
        return namespace != null ? namespace.getName() : "internal";
    }

    @Override
    public boolean hasModifier(ASModifier modifier) {
        ModifiersContainerNode modifiers = this.decorationPart.getModifiers();
        return modifiers != null ? modifiers.getModifierSet().hasModifier(modifier) : false;
    }

    @Override
    public IExpressionNode getNameExpressionNode() {
        return this.nameNode;
    }

    @Override
    public String getName() {
        return this.nameNode instanceof IdentifierNode ? ((IdentifierNode)this.nameNode).getName() : "";
    }

    @Override
    public int getNameStart() {
        return this.nameNode != null ? this.nameNode.getStart() : -1;
    }

    @Override
    public int getNameEnd() {
        return this.nameNode != null ? this.nameNode.getEnd() : -1;
    }

    @Override
    public int getNameAbsoluteStart() {
        return this.nameNode != null ? this.nameNode.getAbsoluteStart() : -1;
    }

    @Override
    public int getNameAbsoluteEnd() {
        return this.nameNode != null ? this.nameNode.getAbsoluteEnd() : -1;
    }

    @Override
    public DefinitionBase getDefinition() {
        return (DefinitionBase)this.definition;
    }

    protected void init(ExpressionNodeBase nameNode) {
        this.nameNode = nameNode;
        this.decorationPart = this.createDecorationPart();
    }

    protected IDecorationPart createDecorationPart() {
        return new DecorationPart();
    }

    protected IDecorationPart getDecorationPart() {
        return this.decorationPart;
    }

    public void setMetaTags(MetaTagsNode tags) {
        if (this.decorationPart != null && tags != null) {
            tags.setDecorationTarget(this);
            this.decorationPart.setMetadata(tags);
        }
    }

    public void setNamespace(INamespaceDecorationNode namespace) {
        if (namespace != null) {
            NodeBase namespaceNode = (NodeBase)((Object)namespace);
            namespaceNode.setParent(this);
            this.decorationPart.setNamespace(namespace);
        }
    }

    public INamespaceDecorationNode getNamespaceNode() {
        return this.decorationPart.getNamespace();
    }

    protected MetaTagsNode getMetaTagsNode() {
        return this.decorationPart.getMetadata();
    }

    public void addModifier(ModifierNode node) {
        ModifiersContainerNode modifiers = this.decorationPart.getModifiers();
        if (modifiers == null) {
            modifiers = new ModifiersContainerNode();
            this.decorationPart.setModifiers(modifiers);
        }
        modifiers.addModifier(node);
    }

    public void setModifiersContainer(ModifiersContainerNode container) {
        this.decorationPart.setModifiers(container);
    }

    public ModifiersSet getModifiers() {
        ModifiersContainerNode modifiers;
        ModifiersContainerNode modifiersContainerNode = modifiers = this.decorationPart != null ? this.decorationPart.getModifiers() : null;
        if (modifiers != null) {
            return modifiers.getModifierSet();
        }
        return null;
    }

    public ModifiersContainerNode getModifiersContainer() {
        return this.decorationPart.getModifiers();
    }

    protected int getNodeStartForTooling() {
        int start = this.getEnd();
        for (int i = 0; i < this.getChildCount(); ++i) {
            int childStart;
            IASNode child = this.getChild(i);
            if (BaseDefinitionNode.shouldIgnoreChildForTooling(child) || (childStart = BaseDefinitionNode.accumulateChildStart(child, start)) >= start) continue;
            return childStart;
        }
        return start;
    }

    public void setASDocComment(IASDocComment ref) {
        if (this.decorationPart != null) {
            this.decorationPart.setASDocComment(ref);
        }
    }

    @Override
    public IASDocComment getASDocComment() {
        return this.decorationPart.getASDocComment();
    }

    protected void addDecorationChildren(boolean fillInOffsets) {
        this.addChildInOrder(this.decorationPart.getMetadata(), fillInOffsets);
        this.addChildInOrder(this.decorationPart.getModifiers(), fillInOffsets);
        this.addChildInOrder((NodeBase)((Object)this.decorationPart.getNamespace()), fillInOffsets);
    }

    protected void fillInNamespaceAndModifiers(DefinitionBase db) {
        INamespaceReference namespaceReference = NamespaceDefinition.createNamespaceReference((IASScope)this.getASScope(), this.getNamespaceNode(), this.hasModifier(ASModifier.STATIC));
        db.setNamespaceReference(namespaceReference);
        this.fillInModifiers(db);
    }

    protected void fillInModifiers(DefinitionBase db) {
        this.setDefinition(db);
        if (this.hasModifier(ASModifier.DYNAMIC)) {
            db.setDynamic();
        }
        if (this.hasModifier(ASModifier.FINAL)) {
            db.setFinal();
        }
        if (this.hasModifier(ASModifier.NATIVE)) {
            db.setNative();
        }
        if (this.hasModifier(ASModifier.OVERRIDE)) {
            db.setOverride();
        }
        if (this.hasModifier(ASModifier.STATIC)) {
            db.setStatic();
        }
    }

    protected void fillInMetadata(DefinitionBase definition) {
        MetaTagsNode metaTagsNode = this.getMetaTagsNode();
        if (metaTagsNode == null) {
            return;
        }
        IMetaTag[] metaTags = metaTagsNode.buildMetaTags(this.getFileSpecification(), definition);
        definition.setMetaTags(metaTags);
    }

    protected void setDefinition(IDefinition definition) {
        this.definition = definition;
    }

    void reconnectDef(ASScope containingScope) {
        String baseName = this.getName();
        IDefinitionSet s = containingScope.getLocalDefinitionSetByName(baseName);
        if (s != null) {
            int l = s.getSize();
            for (int i = 0; i < l; ++i) {
                IDefinition d = s.getDefinition(i);
                if (d.getAbsoluteStart() != this.getAbsoluteStart()) continue;
                this.setDefinition(d);
                ((DefinitionBase)d).setNode(this);
            }
        }
    }
}

