/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.DependencyTypeSet;
import org.apache.royale.compiler.config.RSLSettings;
import org.apache.royale.compiler.exceptions.LibraryCircularDependencyException;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.targets.RoyaleApplicationFrame1Info;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.swc.ISWC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FlexRSLInfo {
    private final RoyaleApplicationFrame1Info frame1Info;
    private final ITargetSettings targetSettings;
    private final RoyaleProject royaleProject;
    final ArrayList<RSLSettings> requiredRSLs;
    final ArrayList<RSLSettings> placeholderRSLs;

    FlexRSLInfo(RoyaleApplicationFrame1Info frame1Info, RoyaleProject royaleProject, ITargetSettings targetSettings) {
        this.frame1Info = frame1Info;
        this.royaleProject = royaleProject;
        this.targetSettings = targetSettings;
        this.requiredRSLs = new ArrayList();
        this.placeholderRSLs = new ArrayList();
        List<RSLSettings> cdRSLs = targetSettings.getRuntimeSharedLibraryPath();
        Set<String> unusedRSLs = this.getUnusedRSLs(cdRSLs);
        for (RSLSettings rslSettings : cdRSLs) {
            if (unusedRSLs.contains(rslSettings.getLibraryFile().getAbsolutePath())) {
                this.placeholderRSLs.add(rslSettings);
                continue;
            }
            this.requiredRSLs.add(rslSettings);
        }
    }

    private Set<String> getUnusedRSLs(List<RSLSettings> cdRSLs) {
        if (!this.targetSettings.removeUnusedRuntimeSharedLibraryPaths()) {
            return Collections.emptySet();
        }
        LinkedList<String> unusedRSLs = new LinkedList<String>();
        HashSet<String> loadedDownstreamRSLs = new HashSet<String>();
        boolean addDownstreamRSL = false;
        for (RSLSettings info : cdRSLs) {
            String swcPath = info.getLibraryFile().getAbsolutePath();
            if (this.isSWCFiltered(swcPath)) continue;
            if (!this.frame1Info.contributingSWCs.contains(swcPath) && !info.isForceLoad()) {
                unusedRSLs.add(swcPath);
                addDownstreamRSL = true;
                continue;
            }
            if (!addDownstreamRSL) continue;
            loadedDownstreamRSLs.add(swcPath);
        }
        if (unusedRSLs.size() == 0) {
            return Collections.emptySet();
        }
        Set<String> requiredInheritanceRSLs = this.filterBasedOnInheritanceDependencies(unusedRSLs, loadedDownstreamRSLs);
        unusedRSLs.removeAll(requiredInheritanceRSLs);
        if (unusedRSLs.size() == 0) {
            return Collections.emptySet();
        }
        return new HashSet<String>(unusedRSLs);
    }

    private Set<String> filterBasedOnInheritanceDependencies(List<String> swcPaths, Set<String> swcPathsFilter) {
        if (swcPathsFilter.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> inheritanceDependencies = new HashSet<String>(swcPathsFilter.size());
        DependencyTypeSet inheritanceDependency = DependencyTypeSet.of(DependencyType.INHERITANCE);
        for (String swcPath : swcPathsFilter) {
            Set<String> swcDependencies;
            try {
                swcDependencies = this.royaleProject.computeLibraryDependencies(new File(swcPath), inheritanceDependency);
            }
            catch (LibraryCircularDependencyException e) {
                assert (false) : e.getMessage();
                continue;
            }
            inheritanceDependencies.addAll(swcDependencies);
        }
        if (inheritanceDependencies.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> results = new HashSet<String>();
        ListIterator<String> iter = swcPaths.listIterator(swcPaths.size());
        while (iter.hasPrevious()) {
            String targetSWC = iter.previous();
            if (!inheritanceDependencies.contains(targetSWC)) continue;
            results.add(targetSWC);
            if (!iter.hasPrevious()) continue;
            try {
                inheritanceDependencies.addAll(this.royaleProject.computeLibraryDependencies(new File(targetSWC), inheritanceDependency));
            }
            catch (LibraryCircularDependencyException e) {
                assert (false) : e.getMessage();
            }
        }
        return results;
    }

    private boolean isSWCFiltered(String swcPath) {
        ISWC swc;
        if (this.royaleProject.getCompatibilityVersion() == null) {
            return false;
        }
        int compatibilityVersion = this.royaleProject.getCompatibilityVersion();
        return compatibilityVersion < (swc = this.royaleProject.getWorkspace().getSWCManager().get(new File(swcPath))).getVersion().getRoyaleMinSupportedVersionInt();
    }
}

