/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.scopes.IDefinitionStore;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionStore1;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionStore4;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionStoreBase;
import org.apache.royale.compiler.scopes.IDefinitionSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmallDefinitionStore2
extends SmallDefinitionStoreBase {
    IDefinitionSet definitionSet0;
    IDefinitionSet definitionSet1;

    public SmallDefinitionStore2() {
    }

    public SmallDefinitionStore2(SmallDefinitionStore1 other) {
        this.definitionSet0 = other.definitionSet0;
    }

    @Override
    public int getCapacity() {
        return 2;
    }

    @Override
    public IDefinitionStore createLargerStore() {
        return new SmallDefinitionStore4(this);
    }

    @Override
    public IDefinitionSet getDefinitionSetByName(String baseName) {
        assert (baseName != null) : "The baseName of a definition must be non-null";
        if (baseName.equals(SmallDefinitionStore2.getBaseName(this.definitionSet0))) {
            return this.definitionSet0;
        }
        if (baseName.equals(SmallDefinitionStore2.getBaseName(this.definitionSet1))) {
            return this.definitionSet1;
        }
        return null;
    }

    @Override
    public void putDefinitionSetByName(String baseName, IDefinitionSet set) {
        if (baseName.equals(SmallDefinitionStore2.getBaseName(this.definitionSet0))) {
            this.definitionSet0 = set;
        }
        if (baseName.equals(SmallDefinitionStore2.getBaseName(this.definitionSet1))) {
            this.definitionSet1 = set;
        }
    }

    @Override
    public Collection<String> getAllNames() {
        int n = this.getCapacity();
        ArrayList<String> list = new ArrayList<String>(n);
        SmallDefinitionStore2.addBaseNameToList(list, this.definitionSet0);
        SmallDefinitionStore2.addBaseNameToList(list, this.definitionSet1);
        return list;
    }

    @Override
    public Collection<IDefinitionSet> getAllDefinitionSets() {
        int n = this.getCapacity();
        ArrayList<IDefinitionSet> list = new ArrayList<IDefinitionSet>(n);
        SmallDefinitionStore2.addDefinitionSetToList(list, this.definitionSet0);
        SmallDefinitionStore2.addDefinitionSetToList(list, this.definitionSet1);
        return list;
    }

    @Override
    public Collection<IDefinition> getAllDefinitions() {
        int n = this.getCapacity();
        ArrayList<IDefinition> list = new ArrayList<IDefinition>(n);
        SmallDefinitionStore2.addDefinitionsToList(list, this.definitionSet0);
        SmallDefinitionStore2.addDefinitionsToList(list, this.definitionSet1);
        return list;
    }

    @Override
    protected int findIndexForBaseName(String baseName) {
        assert (baseName != null) : "The baseName of a definition must be non-null";
        if (baseName.equals(SmallDefinitionStore2.getBaseName(this.definitionSet0))) {
            return 0;
        }
        if (baseName.equals(SmallDefinitionStore2.getBaseName(this.definitionSet1))) {
            return 1;
        }
        return -1;
    }

    @Override
    protected int findAvailableIndex() {
        if (this.definitionSet0 == null) {
            return 0;
        }
        if (this.definitionSet1 == null) {
            return 1;
        }
        return -1;
    }

    @Override
    protected IDefinitionSet getDefinitionSet(int i) {
        assert (i >= 0 && i < this.getCapacity()) : "The index must be within the capacity of the store";
        switch (i) {
            case 0: {
                return this.definitionSet0;
            }
            case 1: {
                return this.definitionSet1;
            }
        }
        return null;
    }

    @Override
    protected void setDefinitionSet(int i, IDefinitionSet definitionSet) {
        assert (i >= 0 && i < this.getCapacity()) : "The index must be within the capacity of the store";
        switch (i) {
            case 0: {
                this.definitionSet0 = definitionSet;
                break;
            }
            case 1: {
                this.definitionSet1 = definitionSet;
            }
        }
    }
}

