/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.common.Multiname;
import org.apache.royale.compiler.common.XMLName;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.units.MXMLCompilationUnit;
import org.apache.royale.compiler.mxml.IMXMLData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.mxml.IXMLNameResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXMLFileScope
extends ASFileScope
implements IXMLNameResolver {
    private final RoyaleProject project;
    private final MXMLDialect mxmlDialect;
    private final Set<String> sourceDependencies;
    private ClassDefinition mainClassDefinition;
    private Map<XMLName, ClassDefinition> fxDefinitionsMap;
    private Map<Integer, ClassDefinition> fxDefinitionsOffsetMap;
    private Map<XMLName, ClassDefinition> fxComponentsMap;
    private Map<Integer, ClassDefinition> fxComponentsOffsetMap;

    public MXMLFileScope(MXMLCompilationUnit compilationUnit, String filePath, IMXMLData mxmlData) {
        super(compilationUnit.getProject().getWorkspace(), filePath);
        this.project = compilationUnit.getProject();
        this.mxmlDialect = mxmlData.getMXMLDialect();
        this.sourceDependencies = new HashSet<String>();
        this.addImplicitImportsForMXML();
    }

    private void addImplicitImportsForMXML() {
        for (String implicitImport : this.project.getImplicitImportsForMXML(this.mxmlDialect)) {
            this.addImport(implicitImport);
        }
    }

    public ClassDefinition getMainClassDefinition() {
        assert (this.mainClassDefinition != null) : "Main class definition should be set before it is retrieved";
        return this.mainClassDefinition;
    }

    public void setMainClassDefinition(ClassDefinition mainClassDefinition) {
        assert (this.mainClassDefinition == null) : "Main class definition should only be set once.";
        assert (mainClassDefinition != null);
        this.mainClassDefinition = mainClassDefinition;
    }

    public ImmutableSet<String> getSourceDependencies() {
        return ImmutableSet.copyOf(this.sourceDependencies);
    }

    public void addSourceDependency(String filename) {
        this.sourceDependencies.add(filename);
    }

    public ClassDefinition addFXComponent(String mainClassQName, int componentTagStart, String componentClassName, String componentBaseClassQName) {
        String className = componentClassName != null ? componentClassName : this.generateComponentClassName(mainClassQName);
        String packageName = Multiname.getPackageNameForQName(className);
        String baseName = Multiname.getBaseNameForQName(className);
        String namespace = packageName.isEmpty() ? "*" : packageName + ".*";
        XMLName xmlName = new XMLName(namespace, baseName);
        ClassDefinition fxComponentClassDefinition = new ClassDefinition(className, this.getFilePrivateNamespaceReference());
        fxComponentClassDefinition.setBaseClassReference(ReferenceFactory.packageQualifiedReference(this.getWorkspace(), componentBaseClassQName));
        fxComponentClassDefinition.setMetaTags(new IMetaTag[0]);
        this.addDefinition(fxComponentClassDefinition);
        TypeScope classScope = new TypeScope((ASScope)this, fxComponentClassDefinition);
        classScope.setContainingDefinition(fxComponentClassDefinition);
        fxComponentClassDefinition.setContainedScope(classScope);
        fxComponentClassDefinition.setupThisAndSuper();
        if (this.fxComponentsMap == null) {
            this.fxComponentsMap = new HashMap<XMLName, ClassDefinition>();
        }
        this.fxComponentsMap.put(xmlName, fxComponentClassDefinition);
        if (this.fxComponentsOffsetMap == null) {
            this.fxComponentsOffsetMap = new HashMap<Integer, ClassDefinition>();
        }
        this.fxComponentsOffsetMap.put(componentTagStart, fxComponentClassDefinition);
        return fxComponentClassDefinition;
    }

    private String generateComponentClassName(String mainClassQName) {
        int currentComponentCount = this.fxComponentsOffsetMap != null ? this.fxComponentsOffsetMap.size() : 0;
        return mainClassQName.replace('.', '_') + "_component" + String.valueOf(currentComponentCount);
    }

    public ClassDefinition getClassDefinitionForComponentTag(IMXMLTagData componentTag) {
        return this.fxComponentsOffsetMap != null ? this.fxComponentsOffsetMap.get(componentTag.getAbsoluteStart()) : null;
    }

    public ClassDefinition addFXDefinition(String mainClassQName, IMXMLTagData definitionTag, String definitionName, String definitionBaseClassQName) {
        String className = this.generateDefinitionClassName(mainClassQName);
        XMLName definitionXMLName = new XMLName(definitionTag.getURI(), definitionName);
        ClassDefinition fxDefinitionClassDefinition = new ClassDefinition(className, this.getFilePrivateNamespaceReference());
        fxDefinitionClassDefinition.setBaseClassReference(ReferenceFactory.packageQualifiedReference(this.getWorkspace(), definitionBaseClassQName));
        fxDefinitionClassDefinition.setMetaTags(new IMetaTag[0]);
        this.addDefinition(fxDefinitionClassDefinition);
        TypeScope classScope = new TypeScope((ASScope)this, fxDefinitionClassDefinition);
        classScope.setContainingDefinition(fxDefinitionClassDefinition);
        fxDefinitionClassDefinition.setContainedScope(classScope);
        fxDefinitionClassDefinition.setupThisAndSuper();
        if (this.fxDefinitionsMap == null) {
            this.fxDefinitionsMap = new HashMap<XMLName, ClassDefinition>();
        }
        this.fxDefinitionsMap.put(definitionXMLName, fxDefinitionClassDefinition);
        if (this.fxDefinitionsOffsetMap == null) {
            this.fxDefinitionsOffsetMap = new HashMap<Integer, ClassDefinition>();
        }
        this.fxDefinitionsOffsetMap.put(definitionTag.getAbsoluteStart(), fxDefinitionClassDefinition);
        return fxDefinitionClassDefinition;
    }

    private String generateDefinitionClassName(String mainClassQName) {
        int currentDefinitionCount = this.fxDefinitionsMap != null ? this.fxDefinitionsMap.size() : 0;
        return mainClassQName.replace('.', '_') + "_definition" + String.valueOf(currentDefinitionCount);
    }

    public String resolveTagToQualifiedName(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        return this.resolveXMLNameToQualifiedName(tagName, tag.getParent().getMXMLDialect());
    }

    @Override
    public String resolveXMLNameToQualifiedName(XMLName tagName, MXMLDialect mxmlDialect) {
        ClassDefinition classDef = this.getClassDefinitionForDefinitionTagName(tagName);
        if (classDef != null) {
            return classDef.getQualifiedName();
        }
        return this.project.resolveXMLNameToQualifiedName(tagName, mxmlDialect);
    }

    public IReference resolveTagToReference(IMXMLTagData tag) {
        String qname = this.resolveTagToQualifiedName(tag);
        if (qname != null) {
            return ReferenceFactory.packageQualifiedReference(this.getWorkspace(), qname);
        }
        return null;
    }

    public IDefinition resolveTagToDefinition(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        return this.resolveXMLNameToDefinition(tagName, tag.getParent().getMXMLDialect());
    }

    @Override
    public IDefinition resolveXMLNameToDefinition(XMLName tagXMLName, MXMLDialect mxmlDialect) {
        ClassDefinition componentTagClassDef = this.getClassDefinitionForComponentTagName(tagXMLName);
        if (componentTagClassDef != null) {
            return componentTagClassDef;
        }
        ClassDefinition definitionTagClassDef = this.getClassDefinitionForDefinitionTagName(tagXMLName);
        if (definitionTagClassDef != null) {
            return definitionTagClassDef;
        }
        return this.project.resolveXMLNameToDefinition(tagXMLName, mxmlDialect);
    }

    public ClassDefinition getClassDefinitionForComponentTagName(XMLName componentTagName) {
        return this.fxComponentsMap != null ? this.fxComponentsMap.get(componentTagName) : null;
    }

    public ClassDefinition getClassDefinitionForDefinitionTag(IMXMLTagData definitionTag) {
        return this.fxDefinitionsOffsetMap != null ? this.fxDefinitionsOffsetMap.get(definitionTag.getAbsoluteStart()) : null;
    }

    public ClassDefinition getClassDefinitionForDefinitionTagName(XMLName definitionTagName) {
        return this.fxDefinitionsMap != null ? this.fxDefinitionsMap.get(definitionTagName) : null;
    }

    public IClassDefinition[] getLibraryDefinitions() {
        return this.fxDefinitionsMap != null ? this.fxDefinitionsMap.values().toArray(new IClassDefinition[0]) : new IClassDefinition[]{};
    }

    public XMLName[] getLibraryDefinitionTagNames() {
        return this.fxDefinitionsMap != null ? this.fxDefinitionsMap.keySet().toArray(new XMLName[0]) : new XMLName[]{};
    }

    public boolean isBindingTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName bindingTagName = this.mxmlDialect.resolveBinding();
        return tagName.equals(bindingTagName);
    }

    public boolean isComponentTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName componentTagName = this.mxmlDialect.resolveComponent();
        return tagName.equals(componentTagName);
    }

    public boolean isDeclarationsTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName declarationsTagName = this.mxmlDialect.resolveDeclarations();
        return tagName.equals(declarationsTagName);
    }

    public boolean isDefinitionTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName definitionTagName = this.mxmlDialect.resolveDefinition();
        return tagName.equals(definitionTagName);
    }

    public boolean isLibraryTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName libraryTagName = this.mxmlDialect.resolveLibrary();
        return tagName.equals(libraryTagName);
    }

    public boolean isMetadataTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName metadataTagName = this.mxmlDialect.resolveMetadata();
        return tagName.equals(metadataTagName);
    }

    public boolean isModelTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName modelTagName = this.mxmlDialect.resolveModel();
        return tagName.equals(modelTagName);
    }

    public boolean isPrivateTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName privateTagName = this.mxmlDialect.resolvePrivate();
        return tagName.equals(privateTagName);
    }

    public boolean isReparentTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName reparentTagName = this.mxmlDialect.resolveReparent();
        return tagName.equals(reparentTagName);
    }

    public boolean isScriptTag(IMXMLUnitData unitData) {
        if (unitData instanceof IMXMLTagData) {
            return this.isScriptTag((IMXMLTagData)unitData);
        }
        return false;
    }

    public boolean isScriptTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName scriptTagName = this.mxmlDialect.resolveScript();
        return tagName.equals(scriptTagName);
    }

    public boolean isStringTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName stringTagName = this.mxmlDialect.resolveString();
        return tagName.equals(stringTagName);
    }

    public boolean isStyleTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName styleTagName = this.mxmlDialect.resolveStyle();
        return tagName.equals(styleTagName);
    }

    public boolean isXMLTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName xmlTagName = this.mxmlDialect.resolveXML();
        return tagName.equals(xmlTagName);
    }

    public boolean isXMLListTag(IMXMLTagData tag) {
        XMLName tagName = tag.getXMLName();
        XMLName xmlListTagName = this.mxmlDialect.resolveXMLList();
        return tagName.equals(xmlListTagName);
    }
}

