/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.royale.compiler.internal.graph.Graph;
import org.apache.royale.compiler.internal.graph.IGraphEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedGraph<V, E extends IGraphEdge<V>>
extends Graph<V, E> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addVertex(V vertex) {
        this.lock.writeLock().lock();
        try {
            boolean bl = super.addVertex(vertex);
            Object var4_3 = null;
            this.lock.writeLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVertex(V vertex) {
        this.lock.writeLock().lock();
        try {
            super.removeVertex(vertex);
            Object var3_2 = null;
            this.lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E setEdge(V from, V to, E e) {
        E e2;
        this.lock.writeLock().lock();
        try {
            e2 = super.setEdge(e);
            Object var6_5 = null;
            this.lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getEdge(V from, V to) {
        Object e;
        this.lock.writeLock().lock();
        try {
            e = super.getEdge(from, to);
            Object var5_4 = null;
            this.lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> getOutgoingEdges(V vertex) {
        this.lock.readLock().lock();
        try {
            Set result = super.getOutgoingEdges(vertex);
            Set set = result == Collections.EMPTY_SET ? result : Collections.unmodifiableSet(new HashSet(result));
            Object var5_4 = null;
            this.lock.readLock().unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> getIncomingEdges(V vertex) {
        this.lock.readLock().lock();
        try {
            Set result = super.getIncomingEdges(vertex);
            Set set = result == Collections.EMPTY_SET ? result : Collections.unmodifiableSet(new HashSet(result));
            Object var5_4 = null;
            this.lock.readLock().unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E removeEdge(E edge) {
        E e;
        this.lock.writeLock().lock();
        try {
            e = super.removeEdge(edge);
            Object var4_3 = null;
            this.lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<V> getVertices() {
        this.lock.readLock().lock();
        try {
            Set result = super.getVertices();
            Set set = Collections.unmodifiableSet(new HashSet(result));
            Object var4_3 = null;
            this.lock.readLock().unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    public Lock writeLock() {
        return this.lock.writeLock();
    }

    public Lock readLock() {
        return this.lock.readLock();
    }
}

