/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.CDATANode;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.internal.fxg.dom.GraphicContentNode;
import org.apache.royale.compiler.internal.fxg.dom.ITextNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.AbstractRichTextNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.BRNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.DivNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.ImgNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.LinkNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.ParagraphNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.SpanNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TCYNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TabNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TextHelper;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TextLayoutFormatNode;
import org.apache.royale.compiler.internal.fxg.dom.types.AlignmentBaseline;
import org.apache.royale.compiler.internal.fxg.dom.types.BaselineOffset;
import org.apache.royale.compiler.internal.fxg.dom.types.BaselineShift;
import org.apache.royale.compiler.internal.fxg.dom.types.BlockProgression;
import org.apache.royale.compiler.internal.fxg.dom.types.BreakOpportunity;
import org.apache.royale.compiler.internal.fxg.dom.types.ColorWithEnum;
import org.apache.royale.compiler.internal.fxg.dom.types.DigitCase;
import org.apache.royale.compiler.internal.fxg.dom.types.DigitWidth;
import org.apache.royale.compiler.internal.fxg.dom.types.Direction;
import org.apache.royale.compiler.internal.fxg.dom.types.DominantBaseline;
import org.apache.royale.compiler.internal.fxg.dom.types.FontStyle;
import org.apache.royale.compiler.internal.fxg.dom.types.FontWeight;
import org.apache.royale.compiler.internal.fxg.dom.types.JustificationRule;
import org.apache.royale.compiler.internal.fxg.dom.types.JustificationStyle;
import org.apache.royale.compiler.internal.fxg.dom.types.Kerning;
import org.apache.royale.compiler.internal.fxg.dom.types.LeadingModel;
import org.apache.royale.compiler.internal.fxg.dom.types.LigatureLevel;
import org.apache.royale.compiler.internal.fxg.dom.types.LineBreak;
import org.apache.royale.compiler.internal.fxg.dom.types.NumberAuto;
import org.apache.royale.compiler.internal.fxg.dom.types.NumberInherit;
import org.apache.royale.compiler.internal.fxg.dom.types.TextAlign;
import org.apache.royale.compiler.internal.fxg.dom.types.TextDecoration;
import org.apache.royale.compiler.internal.fxg.dom.types.TextJustify;
import org.apache.royale.compiler.internal.fxg.dom.types.TextRotation;
import org.apache.royale.compiler.internal.fxg.dom.types.TypographicCase;
import org.apache.royale.compiler.internal.fxg.dom.types.VerticalAlign;
import org.apache.royale.compiler.internal.fxg.dom.types.WhiteSpaceCollapse;
import org.apache.royale.compiler.problems.FXGContentNotContiguousProblem;
import org.apache.royale.compiler.problems.FXGInvalidChildNodeProblem;
import org.apache.royale.compiler.problems.FXGMissingAttributeProblem;
import org.apache.royale.compiler.problems.FXGMultipleElementProblem;
import org.apache.royale.compiler.problems.FXGUnknownAttributeValueProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextNode
extends GraphicContentNode
implements ITextNode {
    protected static final double FONTSIZE_MIN_INCLUSIVE = 1.0;
    protected static final double FONTSIZE_MAX_INCLUSIVE = 720.0;
    protected static final double PADDING_MIN_INCLUSIVE = 0.0;
    protected static final double PADDING_MAX_INCLUSIVE = 1000.0;
    protected static final double BASELINEOFFSET_MIN_INCLUSIVE = 0.0;
    protected static final double BASELINEOFFSET_MAX_INCLUSIVE = 1000.0;
    protected static final double BASELINESHIFT_MIN_INCLUSIVE = -1000.0;
    protected static final double BASELINESHIFT_MAX_INCLUSIVE = 1000.0;
    protected static final int COLUMNCOUNT_MIN_INCLUSIVE = 0;
    protected static final int COLUMNCOUNT_MAX_INCLUSIVE = 50;
    protected static final double COLUMNGAP_MIN_INCLUSIVE = 0.0;
    protected static final double COLUMNGAP_MAX_INCLUSIVE = 1000.0;
    protected static final double COLUMNWIDTH_MIN_INCLUSIVE = 0.0;
    protected static final double COLUMNWIDTH_MAX_INCLUSIVE = 8000.0;
    protected static final double LINEHEIGHT_PERCENT_MIN_INCLUSIVE = -1000.0;
    protected static final double LINEHEIGHT_PERCENT_MAX_INCLUSIVE = 1000.0;
    protected static final double LINEHEIGHT_PIXEL_MIN_INCLUSIVE = -720.0;
    protected static final double LINEHEIGHT_PIXEL_MAX_INCLUSIVE = 720.0;
    protected static final double PARAGRAPH_INDENT_MIN_INCLUSIVE = 0.0;
    protected static final double PARAGRAPH_INDENT_MAX_INCLUSIVE = 1000.0;
    protected static final double PARAGRAPH_SPACE_MIN_INCLUSIVE = 0.0;
    protected static final double PARAGRAPH_SPACE_MAX_INCLUSIVE = 1000.0;
    protected static final double TEXTINDENT_MIN_INCLUSIVE = -1000.0;
    protected static final double TEXTINDENT_MAX_INCLUSIVE = 1000.0;
    protected static final double TRACKING_MIN_INCLUSIVE = -1000.0;
    protected static final double TRACKING_MAX_INCLUSIVE = 1000.0;
    public double width = 0.0;
    public double height = 0.0;
    public BlockProgression blockProgression = BlockProgression.TB;
    public NumberInherit paddingLeft = NumberInherit.newInstance(0.0);
    public NumberInherit paddingRight = NumberInherit.newInstance(0.0);
    public NumberInherit paddingTop = NumberInherit.newInstance(0.0);
    public NumberInherit paddingBottom = NumberInherit.newInstance(0.0);
    public LineBreak lineBreak = LineBreak.TOFIT;
    public NumberInherit columnGap = NumberInherit.newInstance(20.0);
    public NumberAuto columnCount = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public NumberAuto columnWidth = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public BaselineOffset firstBaselineOffset = BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
    public VerticalAlign verticalAlign = VerticalAlign.TOP;
    public TextAlign textAlign = TextAlign.START;
    public TextAlign textAlignLast = TextAlign.START;
    public double textIndent = 0.0;
    public double paragraphStartIndent = 0.0;
    public double paragraphEndIndent = 0.0;
    public double paragraphSpaceBefore = 0.0;
    public double paragraphSpaceAfter = 0.0;
    public Direction direction = Direction.LTR;
    public JustificationRule justificationRule = JustificationRule.AUTO;
    public JustificationStyle justificationStyle = JustificationStyle.PRIORITIZELEASTADJUSTMENT;
    public TextJustify textJustify = TextJustify.INTERWORD;
    public LeadingModel leadingModel = LeadingModel.AUTO;
    public String tabStops = "";
    public String fontFamily = "Arial";
    public double fontSize = 12.0;
    public FontStyle fontStyle = FontStyle.NORMAL;
    public FontWeight fontWeight = FontWeight.NORMAL;
    public Kerning kerning = Kerning.AUTO;
    public double lineHeight = 120.0;
    public TextDecoration textDecoration = TextDecoration.NONE;
    public boolean lineThrough = false;
    public int color = -16777216;
    public double textAlpha = 1.0;
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.COLLAPSE;
    public NumberInherit backgroundAlpha = NumberInherit.newInstance(1.0);
    public ColorWithEnum backgroundColor = ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
    public BaselineShift baselineShift = BaselineShift.newInstance(0.0);
    public BreakOpportunity breakOpportunity = BreakOpportunity.AUTO;
    public DigitCase digitCase = DigitCase.DEFAULT;
    public DigitWidth digitWidth = DigitWidth.DEFAULT;
    public DominantBaseline dominantBaseline = DominantBaseline.AUTO;
    public AlignmentBaseline alignmentBaseline = AlignmentBaseline.USEDOMINANTBASELINE;
    public LigatureLevel ligatureLevel = LigatureLevel.COMMON;
    public String locale = "en";
    public TypographicCase typographicCase = TypographicCase.DEFAULT;
    public double trackingLeft = 0.0;
    public double trackingRight = 0.0;
    public TextRotation textRotation = TextRotation.AUTO;
    public TextLayoutFormatNode linkNormalFormat = null;
    public TextLayoutFormatNode linkHoverFormat = null;
    public TextLayoutFormatNode linkActiveFormat = null;
    private boolean contiguous = false;
    protected Map<String, String> textAttributes;
    protected List<ITextNode> content;
    protected Map<String, ITextNode> properties;

    @Override
    public Map<String, String> getTextAttributes() {
        return this.textAttributes;
    }

    @Override
    public List<ITextNode> getTextChildren() {
        return this.content;
    }

    @Override
    public Map<String, ITextNode> getTextProperties() {
        return this.properties;
    }

    @Override
    public void addTextProperty(String propertyName, ITextNode node, Collection<ICompilerProblem> problems) {
        if (node instanceof TextLayoutFormatNode) {
            if ("linkActiveFormat".equals(propertyName)) {
                if (this.linkActiveFormat == null) {
                    this.linkActiveFormat = (TextLayoutFormatNode)node;
                    this.linkActiveFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap<String, ITextNode>(3);
                    }
                    this.properties.put(propertyName, this.linkActiveFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else if ("linkHoverFormat".equals(propertyName)) {
                if (this.linkHoverFormat == null) {
                    this.linkHoverFormat = (TextLayoutFormatNode)node;
                    this.linkHoverFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap<String, ITextNode>(3);
                    }
                    this.properties.put(propertyName, this.linkHoverFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else if ("linkNormalFormat".equals(propertyName)) {
                if (this.linkNormalFormat == null) {
                    this.linkNormalFormat = (TextLayoutFormatNode)node;
                    this.linkNormalFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap<String, ITextNode>(3);
                    }
                    this.properties.put(propertyName, this.linkNormalFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else {
                problems.add(new FXGUnknownAttributeValueProblem(this.getDocumentPath(), node.getStartLine(), node.getStartColumn(), node.getNodeName(), propertyName));
            }
        } else {
            this.addChild(node, problems);
        }
    }

    public void addContentChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof ParagraphNode || child instanceof DivNode || child instanceof SpanNode || child instanceof BRNode || child instanceof TabNode || child instanceof TCYNode || child instanceof LinkNode || child instanceof ImgNode || child instanceof CDATANode) {
            if (child instanceof LinkNode && ((LinkNode)child).href == null) {
                problems.add(new FXGMissingAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "href", child.getNodeName()));
                return;
            }
            if (this.content == null) {
                this.content = new ArrayList<ITextNode>();
                this.contiguous = true;
            }
            if (!this.contiguous) {
                problems.add(new FXGContentNotContiguousProblem(child.getDocumentPath(), child.getStartLine(), child.getStartColumn(), this.getNodeName()));
                return;
            }
        } else {
            problems.add(new FXGInvalidChildNodeProblem(child.getDocumentPath(), child.getStartLine(), child.getStartColumn(), child.getNodeName(), this.getNodeName()));
            return;
        }
        this.content.add((ITextNode)child);
        if (child instanceof AbstractRichTextNode) {
            ((AbstractRichTextNode)child).setParent(this);
        }
    }

    protected void rememberAttribute(String name, String value) {
        if (this.textAttributes == null) {
            this.textAttributes = new HashMap<String, String>(4);
        }
        this.textAttributes.put(name, value);
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof CDATANode) {
            if (TextHelper.ignorableWhitespace(((CDATANode)child).content)) {
                return;
            }
            problems.add(new FXGContentNotContiguousProblem(child.getDocumentPath(), child.getStartLine(), child.getStartColumn(), this.getNodeName()));
            return;
        }
        super.addChild(child, problems);
        this.contiguous = false;
    }

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        children.addAll(super.getChildren());
        if (this.content != null) {
            children.addAll(this.content);
        }
        if (this.getTextProperties() != null) {
            children.addAll(this.getTextProperties().values());
        }
        return children;
    }

    @Override
    public String getNodeName() {
        return "RichText";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name, this.width, problems);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name, this.height, problems);
        } else if ("blockProgression".equals(name)) {
            this.blockProgression = TextHelper.getBlockProgression(this, value, this.blockProgression, problems);
        } else if ("paddingLeft".equals(name)) {
            this.paddingLeft = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingLeft.getNumberInheritAsDbl(), problems);
        } else if ("paddingRight".equals(name)) {
            this.paddingRight = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingRight.getNumberInheritAsDbl(), problems);
        } else if ("paddingTop".equals(name)) {
            this.paddingTop = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingTop.getNumberInheritAsDbl(), problems);
        } else if ("paddingBottom".equals(name)) {
            this.paddingBottom = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingBottom.getNumberInheritAsDbl(), problems);
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = TextHelper.getLineBreak(this, value, this.lineBreak, problems);
        } else if ("columnGap".equals(name)) {
            this.columnGap = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.columnGap.getNumberInheritAsDbl(), problems);
        } else if ("columnCount".equals(name)) {
            this.columnCount = this.getNumberAutoInt(this, name, value, 0, 50, this.columnCount.getNumberAutoAsInt(), problems);
        } else if ("columnWidth".equals(name)) {
            this.columnWidth = this.getNumberAutoDbl(this, name, value, 0.0, 8000.0, this.columnWidth.getNumberAutoAsDbl(), problems);
        } else if ("firstBaselineOffset".equals(name)) {
            this.firstBaselineOffset = this.getFirstBaselineOffset(this, name, value, 0.0, 1000.0, this.firstBaselineOffset.getBaselineOffsetAsDbl(), problems);
        } else if ("verticalAlign".equals(name)) {
            this.verticalAlign = TextHelper.getVerticalAlign(this, value, this.verticalAlign, problems);
        } else if ("textAlign".equals(name)) {
            this.textAlign = TextHelper.getTextAlign(this, value, this.textAlign, problems);
        } else if ("textAlignLast".equals(name)) {
            this.textAlignLast = TextHelper.getTextAlign(this, value, this.textAlignLast, problems);
        } else if ("textIndent".equals(name)) {
            this.textIndent = DOMParserHelper.parseDouble(this, value, name, -1000.0, 1000.0, this.textIndent, problems);
        } else if ("paragraphStartIndent".equals(name)) {
            this.paragraphStartIndent = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphStartIndent, problems);
        } else if ("paragraphEndIndent".equals(name)) {
            this.paragraphEndIndent = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphEndIndent, problems);
        } else if ("paragraphSpaceBefore".equals(name)) {
            this.paragraphSpaceBefore = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphSpaceBefore, problems);
        } else if ("paragraphSpaceAfter".equals(name)) {
            this.paragraphSpaceAfter = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphSpaceAfter, problems);
        } else if ("direction".equals(name)) {
            this.direction = TextHelper.getDirection(this, value, this.direction, problems);
        } else if ("justificationRule".equals(name)) {
            this.justificationRule = TextHelper.getJustificationRule(this, value, this.justificationRule, problems);
        } else if ("justificationStyle".equals(name)) {
            this.justificationStyle = TextHelper.getJustificationStyle(this, value, this.justificationStyle, problems);
        } else if ("textJustify".equals(name)) {
            this.textJustify = TextHelper.getTextJustify(this, value, this.textJustify, problems);
        } else if ("leadingModel".equals(name)) {
            this.leadingModel = TextHelper.getLeadingModel(this, value, this.leadingModel, problems);
        } else if ("tabStops".equals(name)) {
            this.tabStops = TextHelper.parseTabStops(this, value, this.tabStops, problems);
        } else if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = DOMParserHelper.parseDouble(this, value, name, 1.0, 720.0, this.fontSize, problems);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = TextHelper.getFontStyle(this, value, this.fontStyle, problems);
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = TextHelper.getFontWeight(this, value, this.fontWeight, problems);
        } else if ("kerning".equals(name)) {
            this.kerning = TextHelper.getKerning(this, value, this.kerning, problems);
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = DOMParserHelper.parseNumberPercentWithSeparateRange(this, value, name, -720.0, 720.0, -1000.0, 1000.0, this.lineHeight, problems);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = TextHelper.getTextDecoration(this, value, this.textDecoration, problems);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = DOMParserHelper.parseBoolean(this, value, name, this.lineThrough, problems);
        } else if ("color".equals(name)) {
            this.color = DOMParserHelper.parseRGB(this, value, name, this.color, problems);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.textAlpha, problems);
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = TextHelper.getWhiteSpaceCollapse(this, value, this.whiteSpaceCollapse, problems);
        } else if ("backgroundAlpha".equals(name)) {
            this.backgroundAlpha = this.getAlphaInherit(this, name, value, 0.0, 1.0, this.backgroundAlpha.getNumberInheritAsDbl(), problems);
        } else if ("backgroundColor".equals(name)) {
            this.backgroundColor = this.getColorWithEnum(this, name, value, this.backgroundColor.getColorWithEnumAsString(), problems);
        } else if ("baselineShift".equals(name)) {
            this.baselineShift = this.getBaselineShift(this, name, value, -1000.0, 1000.0, this.baselineShift.getBaselineShiftAsDbl(), problems);
        } else if ("breakOpportunity".equals(name)) {
            this.breakOpportunity = TextHelper.getBreakOpportunity(this, value, this.breakOpportunity, problems);
        } else if ("digitCase".equals(name)) {
            this.digitCase = TextHelper.getDigitCase(this, value, this.digitCase, problems);
        } else if ("digitWidth".equals(name)) {
            this.digitWidth = TextHelper.getDigitWidth(this, value, this.digitWidth, problems);
        } else if ("dominantBaseline".equals(name)) {
            this.dominantBaseline = TextHelper.getDominantBaseline(this, value, this.dominantBaseline, problems);
        } else if ("alignmentBaseline".equals(name)) {
            this.alignmentBaseline = TextHelper.getAlignmentBaseline(this, value, this.alignmentBaseline, problems);
        } else if ("ligatureLevel".equals(name)) {
            this.ligatureLevel = TextHelper.getLigatureLevel(this, value, this.ligatureLevel, problems);
        } else if ("locale".equals(name)) {
            this.locale = value;
        } else if ("typographicCase".equals(name)) {
            this.typographicCase = TextHelper.getTypographicCase(this, value, this.typographicCase, problems);
        } else if ("trackingLeft".equals(name)) {
            this.trackingLeft = DOMParserHelper.parseNumberPercent(this, value, name, -1000.0, 1000.0, this.trackingLeft, problems);
        } else if ("trackingRight".equals(name)) {
            this.trackingRight = DOMParserHelper.parseNumberPercent(this, value, name, -1000.0, 1000.0, this.trackingRight, problems);
        } else if ("textRotation".equals(name)) {
            this.textRotation = TextHelper.getTextRotation(this, value, this.textRotation, problems);
        } else if (!"id".equals(name)) {
            super.setAttribute(name, value, problems);
        }
        this.rememberAttribute(name, value);
    }

    private BaselineOffset getFirstBaselineOffset(IFXGNode node, String name, String value, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        if ("auto".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
        }
        if ("ascent".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.ASCENT);
        }
        if ("lineHeight".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.LINEHEIGHT);
        }
        try {
            return BaselineOffset.newInstance(DOMParserHelper.parseDouble(this, value, min, max));
        }
        catch (Exception e) {
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return BaselineOffset.newInstance(defaultValue);
        }
    }

    private NumberAuto getNumberAutoDbl(IFXGNode node, String name, String value, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return NumberAuto.newInstance(DOMParserHelper.parseDouble(this, value, min, max));
        }
        catch (Exception e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return NumberAuto.newInstance(defaultValue);
        }
    }

    private NumberAuto getNumberAutoInt(IFXGNode node, String name, String value, int min, int max, int defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return NumberAuto.newInstance(DOMParserHelper.parseInt(this, value, min, max));
        }
        catch (Exception e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return NumberAuto.newInstance(defaultValue);
        }
    }

    private NumberInherit getNumberInherit(IFXGNode node, String name, String value, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return NumberInherit.newInstance(DOMParserHelper.parseDouble(this, value, min, max));
        }
        catch (Exception e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return NumberInherit.newInstance(defaultValue);
        }
    }

    private BaselineShift getBaselineShift(IFXGNode node, String name, String value, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return BaselineShift.newInstance(DOMParserHelper.parseNumberPercent(this, value, min, max));
        }
        catch (Exception e) {
            if ("superscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUPERSCRIPT);
            }
            if ("subscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUBSCRIPT);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return BaselineShift.newInstance(defaultValue);
        }
    }

    private NumberInherit getAlphaInherit(IFXGNode node, String name, String value, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return NumberInherit.newInstance(DOMParserHelper.parseDouble(this, value, 0.0, 1.0));
        }
        catch (Exception e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return NumberInherit.newInstance(defaultValue);
        }
    }

    private ColorWithEnum getColorWithEnum(IFXGNode node, String attribute, String value, int defaultValue, Collection<ICompilerProblem> problems) {
        if ("transparent".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
        }
        if ("inherit".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.INHERIT);
        }
        return ColorWithEnum.newInstance(DOMParserHelper.parseRGB(this, value, attribute, defaultValue, problems));
    }
}

